@extends('layout')

@section('title')
    Поиск запроса {{ $find }}
@stop

@section('content')

    <h1>Поиск запроса {{ $find }}</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item"><a href="/forums/search">Поиск</a></li>
            <li class="breadcrumb-item active">Поиск запроса</li>
        </ol>
    </nav>

    <p class="search-title">Найдено совпадений в сообщениях: {{ $page->total }}</p>

   <div class="forum-block">
    @foreach ($posts as $post)
        <div class="new-themes-post">
           <ul>
            <li><a href="/topics/{{ $post->topic_id }}/{{ $post->id }}"><span class="icon-post-new"><i class="material-icons">search</i></span>{{ $post->topic->title }}</a></li>
            
        </ul>

        <div class="forum-text">{!! bbCode($post->text) !!}
            </div>
            
            <div class="forum-pagist">
            <a class="f" href="/topics/{{ $post->topic->forum->id }}"><i class="material-icons">keyboard_arrow_right</i>Раздел:{{ $post->topic->forum->title }}</a>
            </div>
            <div class="forum-bottom">
            <span>Написал: {!! $post->user->getProfile() !!} <br>({{ dateFixed($post->created_at) }})</span>
            
            
            </div>
        
</div>
    @endforeach
    </div>

    {!! pagination($page) !!}
    </div>
@stop
