@extends('layout')

@section('title')
    Поиск запроса {{ $find }}
@stop

@section('content')

    <h1>Поиск запроса {{ $find }}</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item"><a href="/forums/search">Поиск</a></li>
            <li class="breadcrumb-item active">Поиск запроса</li>
        </ol>
    </nav>

    <p class="search-title">Найдено совпадений в темах: {{ $page->total }}</p>

   <div class="forum-block">
    @foreach ($topics as $topic)
        <div class="new-themes-post">
            <ul><li><a href="/topics/{{ $topic->id }}"><span class="icon-post-new"><i class="material-icons">search</i></span>{{ $topic->title }}  {{ $topic->count_posts }}</a></li></ul>
            
       
        <div class="forum-pagist">
           <div class="p"> {!! $topic->pagination() !!}</div>
            <a class="f" href="/topics/{{ $topic->forum->id }}"><i class="material-icons">keyboard_arrow_right</i>Раздел:{{ $topic->forum->title }}</a>
            </div>
            <div class="forum-bottom">
            <span>
            Сообщение: {!! $topic->lastPost->user->getProfile(null, false) !!} <br> ({{ dateFixed($topic->lastPost->created_at) }})</span>
            </div>
        </div>
    @endforeach
</div>
    {!! pagination($page) !!}
    </div>
@stop
