@extends('layout')

@section('title')
    Топ популярных постов
@stop

@section('content')
    <h1>Топ популярных постов</h1>
<div class="forum-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/forums">Форум</a></li>
            <li class="breadcrumb-item active">Топ популярных постов</li>
        </ol>
    </nav>

   <div class="main-new-link">
   <div class="l-block">
       <button class="m">Период<i class="fa fa-caret-down" aria-hidden="true"></i></button>
       <ul class="main-link">
    <?php $active = ($period == 1) ? 'success' : 'light'; ?>
           <li><a href="/forums/top/posts?period=1">Сутки</a></li>

    <?php $active = ($period == 7) ? 'success' : 'light'; ?>
    <li><a href="/forums/top/posts?period=7" >Неделя</a></li>

    <?php $active = ($period == 30) ? 'success' : 'light'; ?>
    <li><a href="/forums/top/posts?period=30">Месяц</a></li>

    <?php $active = ($period == 365) ? 'success' : 'light'; ?>
    <li><a href="/forums/top/posts?period=365" >Год</a></li>

    <?php $active = (empty($period)) ? 'success' : 'light'; ?>
    <li><a href="/forums/top/posts" >За все время</a></li>
    </ul>
    </div>
    </div>

   <div class="forum-block">
    @if ($posts->isNotEmpty())
        @foreach ($posts as $data)
           <div class="new-themes-post">
            <ul>
                <li><a href="/topics/{{ $data->topic_id }}/{{ $data->id }}"><span class="icon-post-new"><i class="material-icons">star</i></span>{{ $data->topic->title }} Рейтинг: {{ $data->rating }}</a></li>
                
            </ul>
           
               <div class="forum-text">
                {!! bbCode($data->text) !!}
                </div>

               <div class="forum-bottom">
               <span>Написал: {{ $data->user->login }} <br>({{ dateFixed($data->created_at) }})</span>

                @if (isAdmin())
                    <span>({{ $data->brow }}, {{ $data->ip }})</span>
                @endif
              </div>
            </div>
        @endforeach
        </div>

        {!! pagination($page) !!}
    @else
        {!! showError('Сообщений еще нет!') !!}
    @endif
    </div>
@stop
