@extends('layout')

@section('title')
    Загрузки - Список файлов {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')
    <h1>Файлы {{ $user->login }}</h1>
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>
            <li class="breadcrumb-item active">Файлы {{ $user->login }}</li>
        </ol>
    </nav>

    @if ($user->id == getUser('id'))
       <div class="post-nav-link">
        <?php $type = ($active == 1) ? 'success' : 'light'; ?>
        <a href="/downs/active/files?active=1">Проверенные</a>

        <?php $type = ($active == 0) ? 'success' : 'light'; ?>
        <a href="/downs/active/files?active=0">Ожидающие</a>
        </div>
    @endif

   <div class="down-block">
    @if ($downs->isNotEmpty())
        @foreach ($downs as $down)
            <?php $rating = $down->rated ? round($down->rating / $down->rated, 1) : 0; ?>

           <div class="new-main-files">
            <ul>
                <li><a href="/downs/{{ $down->id }}"><span class="icon-files"><i class="material-icons">person</i></span>{{ $down->title }} {{ $down->count_comments }}</a></li> 
            </ul>
            <div class="new-main-bottom">
               
                <span class="links"><a href="/loads/{{ $down->category->id }}"><i class="material-icons">keyboard_arrow_right</i>Категория: {{ $down->category->name }}</a></span>
                <span>Рейтинг: {{ $rating }}</span>
                <span>Скачиваний: {{ $down->loads }}</span>
                <span>Автор: {!! $down->user->getProfile() !!} ({{ dateFixed($down->created_at) }})</span>
                
            </div>
            </div>

        @endforeach
</div>
        {!! pagination($page) !!}
    @else
        {!! showError('Опубликованных файлов еще нет!') !!}
    @endif
    </div>
@stop
