@extends('layout')

@section('title')
    {{ $down->title }}
@stop

@section('description', stripString($down->text))

@section('content')

    <h1>{{ $down->title }}</h1>
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>

            @if ($down->category->parent->id)
                <li class="breadcrumb-item"><a href="/loads/{{ $down->category->parent->id }}">{{ $down->category->parent->name }}</a></li>
            @endif

            <li class="breadcrumb-item"><a href="/loads/{{ $down->category_id }}">{{ $down->category->name }}</a></li>
            <li class="breadcrumb-item active">{{ $down->title }}</li>
            <li class="breadcrumb-item"><a href="/downs/rss/{{ $down->id }}">RSS-лента</a></li>

            @if (isAdmin('admin'))
                <li class="breadcrumb-item"><a href="/admin/downs/edit/{{ $down->id }}">Редактировать</a></li>
            @endif
        </ol>
    </nav>

    @if (! $down->active)
        <div class="p-1 bg-warning text-dark">
            <b>Внимание!</b> Данная загрузка ожидает проверки модератором!<br>
            @if ($down->user_id == getUser('id'))
                <i class="fa fa-pencil-alt"></i> <a href="/downs/edit/{{ $down->id }}">Перейти к редактированию</a>
            @endif
        </div><br>
    @endif

   <div class="loads-block">
    <div class="load-text">
        {!! bbCode($down->text) !!}
    </div>

    @if ($down->files->isNotEmpty())
        @if ($down->getFiles()->isNotEmpty())
            <div class="loads-link">
                @foreach ($down->getFiles() as $file)
                    @if ($file->hash && file_exists(HOME . $file->hash))
                       <ul>
                        <li><a href="/downs/download/{{ $file->id }}"><i class="material-icons">save</i>{{ $file->name }}  ({{ formatSize($file->size) }})</a></li>
                        </ul>

                        @if ($file->extension === 'mp3')
                           <div class="audio">
                            <audio  preload="none" controls style="max-width:100%;">
                                <source src="{{ $file->hash }}" type="audio/mp3">
                            </audio>
                          </div>
                        @endif

                        @if ($file->extension === 'mp4')
                            <?php $poster = file_exists(HOME . $file->hash . '.jpg') ? $file->hash . '.jpg' : null; ?>

                          <div class="video">
                           <video width="640" height="360" style="max-width:100%;" poster="{{ $poster }}" preload="none" controls playsinline>
                               <source src="{{ $file->hash }}" type="video/mp4">
                           </video>
                           </div>
                        @endif

                        @if ($file->extension === 'zip')
                           <div class="shows">
                            <a href="/downs/zip/{{ $file->id }}">Просмотреть архив</a>
                            </div>
                        @endif
                    @else
                        <i class="fa fa-download"></i> Файл не найден
                    @endif
                @endforeach
            </div>
        @endif

        @if ($down->getImages()->isNotEmpty())
            <div class="image-cont">
                @foreach ($down->getImages() as $image)
                    <a href="{{ $image->hash }}" class="gallery" data-group="{{ $down->id }}">{!! resizeImage($image->hash, ['alt' => $down->title]) !!}</a>
                @endforeach
            </div>
        @endif
    @else
        {!! showError('Файлы еще не загружены!') !!}
    @endif

    
        <div class="rating-comment-block">
        @if (getUser() && getUser('id') != $down->user_id)
       <div class="rating">
        <form class="rating-ds" action="/downs/votes/{{ $down->id }}" method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">

            <div class="form-group{{ hasError('score') }}">
                <select class="form-control" id="score" name="score">
                    <option value="5" {{ $down->vote == 5 ? ' selected' : '' }}>Отлично</option>
                    <option value="4" {{ $down->vote == 4 ? ' selected' : '' }}>Хорошо</option>
                    <option value="3" {{ $down->vote == 3 ? ' selected' : '' }}>Нормально</option>
                    <option value="2" {{ $down->vote == 2 ? ' selected' : '' }}>Плохо</option>
                    <option value="1" {{ $down->vote == 1 ? ' selected' : '' }}>Отстой</option>
                </select>
                {!! textError('protect') !!}
            </div>
            
            <button class="btns">Оценить</button>
            
        </form>
        </div>
        
    @endif
      
     <div class="comment">
            <a href="/downs/comments/{{ $down->id }}"> <i class="fa fa-comment"></i> Комментарии {{ $down->count_comments }}</a> 
        </div>
       </div>
        
        
<div class="down-bottom">
       <ul>
           <li>Рейтинг: {!! ratingVote($rating) !!}</li>
        <li>Всего голосов: <b>{{ $down->rated }}</b></li>
        <li>Всего скачиваний: <b>{{ $down->loads }}</b></li>
        <li>Добавлено: {!! $down->user->getProfile() !!} ({{ dateFixed($down->created_at) }})</li>
    </ul>
</div>


     </div>
    </div>
@stop
