@extends('layout')

@section('title')
    Загрузки
@stop

@section('content')

    <h1>Загрузки</h1>
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Загрузки</li>
        </ol>
    </nav>

   <div class="main-new-link">
   <div class="l-block">
    @if (getUser())
       <button class="m">Мои: <i class="fa fa-caret-down" aria-hidden="true"></i></button>
       <ul class="main-link">
           <li><a href="/downs/active/files">файлы</a></li>
           <li><a href="/downs/active/comments">комментарии</a></li>
        </ul>
    @endif
</div>
   
   <div class="l-block">
   <button class="o">Новые: <i class="fa fa-caret-down" aria-hidden="true"></i></button>
    <ul class="ob-link">
        <li><a href="/downs">файлы</a></li>
        <li><a href="/downs/comments">комментарии</a></li>
    </ul>
    </div>

   <div class="l-block">
    @if (getUser())
            <a class="bt" href="/downs/create">Добавить файл</a>
    @endif
    </div>
    </div>
    
    
    <div class="down-block">
    @foreach ($categories as $category)
       <div class="down">
        <ul>
            <li><a href="/loads/{{ $category->id }}"><span class="icon-down"><i class="material-icons">folder</i></span>
               {{ $category->name }}  @if ($category->new)
                <span class="count-down">
                {{ $category->count_downs }}/+{{ $category->new->count_downs }}</span>
            @else
                <span class="count-down">{{ $category->count_downs }}</span>
            @endif
            </a></li>
           
        </ul>
       

        <div class="podcat">
           <ul>
            @if ($category->children->isNotEmpty())
                @foreach ($category->children as $child)
                     <li><a href="/loads/{{ $child->id }}">
                      <i class="material-icons">folder_open</i>
                       {{ $child['name'] }} @if ($child->new)
                       <span class="count-podcat">
                        {{ $child->count_downs }}/<span class="plus">+{{ $child->new->count_downs }}</span><br>
                         </span>
                    @else
                        <span class="count-podcat">{{ $child->count_downs }}</span><br>
                    @endif
                        
                         @endforeach</a></li>
                    
            @endif
            </ul>
        </div>
        
         </div>
    @endforeach
    </div>

    <div class="post-nav-link">
    <a href="/loads/top">Топ файлов</a>
    <a href="/loads/search">Поиск</a>
    <a href="/loads/rss">RSS</a>
    </div>
    </div>
@stop
