@extends('layout')

@section('title')
    {{ $category->name }} (Стр. {{ $page->current }})
@stop

@section('content')


    <h1>{{ $category->name }}</h1>
    
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>

            @if ($category->parent->id)
                <li class="breadcrumb-item"><a href="/loads/{{ $category->parent->id }}">{{ $category->parent->name }}</a></li>
            @endif

            <li class="breadcrumb-item active">{{ $category->name }}</li>

            @if (isAdmin('admin'))
                <li class="breadcrumb-item"><a href="/admin/loads/{{ $category->id }}?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

   <div class="main-new-link">
   
   <div class="l-block">
    <button class="m">Сортировать: <i class="fa fa-caret-down" aria-hidden="true"></i></button>

   <ul class="main-link">
    <?php $active = ($order === 'created_at') ? 'success' : 'light'; ?>
       <li><a href="/loads/{{ $category->id }}?sort=time">По дате</a></li>

    <?php $active = ($order === 'loads') ? 'success' : 'light'; ?>
    <li><a href="/loads/{{ $category->id }}?sort=loads">Скачивания</a></li>

    <?php $active = ($order === 'rated') ? 'success' : 'light'; ?>
    <li><a href="/loads/{{ $category->id }}?sort=rated">Оценки</a></li>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
    <li><a href="/loads/{{ $category->id }}?sort=comments">Комментарии</a></li>
    </ul>
    </div>

     
     <div class="l-block">
      @if (getUser() && ! $category->closed)
        <div class="btns">
            <a class="bt" href="/downs/create?cid={{ $category->id }}">Добавить файл</a>
        </div>
    @endif
    </div>
   </div>
   
   <div class="down-block">
    @if ($category->children->isNotEmpty() && $page->current == 1)
       <div class="down-load">
        <ul class="down-cat">
            @foreach ($category->children as $child)
                <li>
                    <a href="/loads/{{ $child->id }}"><i class="material-icons">folder</i>{{ $child->name }} <span class="count-load">{{ $child->count_downs }}</span></a> </li>
            @endforeach
        </ul>
       </div>
    @endif
    </div>
 
 <div class="load-load">
    @if ($downs->isNotEmpty())
        @foreach ($downs as $data)
           
            <?php $rating = $data->rated ? round($data->rating / $data->rated, 1) : 0; ?>

           
            <ul class="down-file">
                <li><a href="/downs/{{ $data->id }}">
                <i class="material-icons">insert_drive_file</i>{{ $data->title }} <span class="count-load">{{ $data->count_comments }}</span></a></li> 
            </ul>
        @endforeach
</div>
        {!! pagination($page) !!}
    @else
        @if (! $category->closed)
            {!! showError('В данной категории еще нет файлов!') !!}
        @endif
    @endif

    @if ($category->closed)
        {!! showError('В данной категории запрещена загрузка файлов!') !!}
    @endif

   <div class="post-nav-link">
       <a href="/loads/top">Топ файлов</a>
    <a href="/loads/search">Поиск</a>
    </div>
    </div>
@stop
