@extends('layout')

@section('title')
    Топ популярных файлов (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Топ популярных файлов</h1>
<div class="down-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/loads">Загрузки</a></li>
            <li class="breadcrumb-item active">Топ файлов</li>
        </ol>
    </nav>

   <div class="main-new-link">
   <div class="l-block">
    <button class="m"> Сортировать: <i class="fa fa-caret-down" aria-hidden="true"></i></button>
    <ul class="main-link">
    <?php $active = ($order === 'loads') ? 'success' : 'light'; ?>
        <li><a href="/loads/top?sort=loads">Скачивания</a></li>

    <?php $active = ($order === 'rated') ? 'success' : 'light'; ?>
    <li><a href="/loads/top?sort=rated">Оценки</a></li>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
    <li><a href="/loads/top?sort=comments">Комментарии</a></li>
    </ul>
    </div>
   </div>

   <div class="down-block">
    @if ($downs->isNotEmpty())

        @foreach ($downs as $data)
            <?php $rating = $data->rated ? round($data->rating / $data->rated, 1) : 0; ?>

           <div class="top-files">
            <ul>
                <li>
                <a href="/downs/{{ $data->id }}"><span class="icons-top"><i class="material-icons">star_rate</i></span>{{ $data->title }} {{ $data->count_comments }}</a></li> 
            </ul>


               <div class="bottom-top-files">
               <span class="links"> <a href="/loads/{{ $data->category->id }}"><i class="material-icons">keyboard_arrow_right</i>Категория:  {{ $data->category->name }}</a></span>
                <span>Рейтинг: {{ $rating }}</span>
                <span>Скачиваний: {{ $data->loads }}</span>
                </div>
                
                <div class="top-files-comment">
                <a href="/downs/comments/{{ $data->id }}"><i class="material-icons">comment</i> {{ $data->count_comments }}</a> 
               
               </div>
            
        </div>
        @endforeach
</div>
        {!! pagination($page) !!}
    @else
        @if (! $category->closed)
            {!! showError('Файлы не найдены!') !!}
        @endif
    @endif
    </div>
@stop
