@extends('layout')

@section('title')
    Приватные сообщения
@stop

@section('content')

    <h1>Приватные сообщения</h1>

   <div class="privat-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/menu">Мое меню</a></li>
            <li class="breadcrumb-item active">Входящие</li>
        </ol>
    </nav>

    @if ($newprivat > 0)
        <div style="text-align:center"><b><span style="color:#ff0000">Получено новых писем: {{ getUser('newprivat') }}</span></b></div>
    @endif

    @if ($page->total >= (setting('limitmail') - (setting('limitmail') / 10)) && $page->total < setting('limitmail'))
        <div style="text-align:center"><b><span style="color:#ff0000">Ваш ящик почти заполнен, необходимо очистить или удалить старые сообщения!</span></b></div>
    @endif

    @if ($page->total >= setting('limitmail'))
        <div style="text-align:center"><b><span style="color:#ff0000">Ваш ящик переполнен, вы не сможете получать письма пока не очистите его!</span></b></div>
    @endif

   <div class="privat-message">
       <span class="active"><i class="fa fa-envelope"></i> Входящие <b>{{ $page->total }}</b></span>
       <a href="/messages/outbox"><i class="fa fa-paper-plane" aria-hidden="true"></i> Отправленные <b>{{  $page->totalOutbox }}</b></a>
</div>

    @if ($messages->isNotEmpty())

        <form action="/messages/delete?page={{ $page->current }}" method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">
            <div class="form text-right">
                <label for="all">Отметить все</label>
                <input type="checkbox" id="all" onchange="var o=this.form.elements;for(var i=0;i&lt;o.length;i++)o[i].checked=this.checked">
            </div>

            @foreach ($messages as $data)
               <div class="post">
                <div class="b">
                    <div class="float-right">
                        @if ($data->author->id)
                            <a href="/messages/send?user={{ $data->author->login }}" title="Ответить"><i class="fa fa-reply text-muted"></i></a>
                            <a href="/messages/history?user={{ $data->author->login }}" title="История"><i class="fa fa-history text-muted"></i></a>
                            <a href="#" onclick="return sendComplaint(this)" data-type="{{ App\Models\Inbox::class }} " data-id="{{ $data->id }}" data-token="{{ $_SESSION['token'] }}" rel="nofollow" title="Жалоба"><i class="fa fa-bell text-muted"></i></a>
                        @endif

                        <input type="checkbox" name="del[]" value="{{ $data->id }}">
                    </div>

                    <div class="img">
                        {!! $data->author->getAvatar() !!}
                        {!! $data->author->getOnline() !!}
                    </div>

                    @if ($data->author->id)
                        <b>{!! $data->author->getProfile() !!}</b> ({{ dateFixed($data->created_at) }})<br>
                        {!! $data->author->getStatus() !!}
                    @else
                        <b>Система</b> ({{ dateFixed($data->created_at) }})<br>
                    @endif
                </div>
                <div class="message">{!! bbCode($data->text) !!}</div>
            </div>
            @endforeach

            <div class="delit">
                <button class="del">Удалить выбранное</button>
            </div>
        </form>

        {!! pagination($page) !!}

       <div class="tex-center">
           <span>Всего писем: <b>{{ $page->total }}</b></span>
           <span>Объем ящика: <b>{{ setting('limitmail') }}</b></span>
</div>

      <div class="privat-nav">
       <ul>
           <li><a href="/messages/clear?token={{ $_SESSION['token'] }}"><span class="icon"><i class="fa fa-times"></i></span>Очистить ящик</a></li>
    @else
        {!! showError('Входящих писем еще нет!') !!}
    @endif


       <li><a href="/searchusers"><span class="icon"><i class="fa fa-search"></i></span>Поиск контактов</a></li>
       <li><a href="/messages/send"><span class="icon"><i class="fa fa-envelope"></i></span>Написать письмо</a></li>
       <li><a href="/contacts"><span class="icon"><i class="fa fa-address-book"></i></span>Контакт</a></li> 
       <li><a href="/ignores"><span class="icon"><i class="fa fa-ban" aria-hidden="true"></i></span>Игнор</a></li>
</ul>
</div>
</div>
@stop
