@extends('layout')

@section('title')
    Новое сообщение
@stop

@section('content')

    <h1>Новое сообщение</h1>
<div class="privat-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/menu">Мое меню</a></li>
            <li class="breadcrumb-item"><a href="/messages">Приватные сообщения</a></li>
            <li class="breadcrumb-item active">Новое сообщение</li>
        </ol>
    </nav>

    @if ($user)

       <div class="dls">
           <span><i class="fa fa-envelope"></i> Сообщение для <b>{!! $user->getProfile() !!}</b></span>
         <a href="/messages/history?user={{ $user->login  }}"><i class="fa fa-history"></i> История переписки</a>
    </div>

        @if (getUser()->isIgnore($user))
            <b><span style="color:#ff0000">Внимание, данный пользователь находится в игнор-листе!</span></b><br>
        @endif

        <div class="form">
            <form action="/messages/send?user={{ $user->login }}" method="post">
                <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">

                <div class="form-group{{ hasError('msg') }}">
                    <label for="msg">Сообщение:</label>
                    <textarea class="form-control markItUp" id="msg" rows="5" name="msg" placeholder="Текст сообщения" required>{{ getInput('msg') }}</textarea>
                    {!! textError('msg') !!}
                </div>

                @if (getUser('point') < setting('privatprotect'))
                    {!! view('app/_captcha') !!}
                @endif

                <button class="btn btn-primary">Отправить</button>
            </form>
        </div>

    @else

        <div class="form">
            <form action="/messages/send" method="post">
                <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">

                <div class="form-group{{ hasError('user') }}">
                    <label for="inputLogin">Логин:</label>
                    <input type="text" class="form-control" id="inputLogin" name="user" maxlength="20" value="{{ getInput('user') }}">
                    {!! textError('user') !!}
                </div>

                @if ($contacts->isNotEmpty())
                    <label for="inputContact">Или выберите из списка</label>
                    <select class="form-control" id="inputContact" name="contact">

                        <option value="0">Список контактов</option>

                        @foreach ($contacts as $data)
                            <option value="{{ $data->contactor->login }}">{{ $data->contactor->login }}</option>
                        @endforeach
                    </select><br>
                @endif

                <div class="form-group{{ hasError('msg') }}">
                    <label for="msg">Сообщение:</label>
                    <textarea class="form-control markItUp" id="msg" rows="5" name="msg" placeholder="Текст сообщения" required>{{ getInput('msg') }}</textarea>
                    {!! textError('msg') !!}
                </div>

                @if (getUser('point') < setting('privatprotect'))
                    {!! view('app/_captcha') !!}
                @endif

                <button class="btns">Отправить</button>
            </form>
        </div>

        <div class="tex-center">Введите логин или выберите пользователя из своего контакт-листа</div>
    @endif

  <div class="privat-nav">
   <ul>
     <li><a href="/searchusers"><span class="icon"><i class="fa fa-search"></i></span>Поиск контактов</a></li>
     <li><a href="/messages/send"><span class="icon"><i class="fa fa-envelope"></i></span>Написать письмо</a></li>
     <li><a href="/contacts"><span class="icon"><i class="fa fa-address-book"></i></span>Контакт</a></li>
     <li><a href="/ignores"><span class="icon"><i class="fa fa-ban" aria-hidden="true"></i></span>Игнор</a></li>
      </ul>
</div>
</div>
@stop
