@extends('layout')

@section('title')
    Предложения / Проблемы
@stop

@section('content')


    <h1>Предложения / Проблемы</h1>
<div class="offers-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Предложения / Проблемы</li>

            @if (isAdmin('admin'))
                <li class="breadcrumb-item"><a href="/admin/offers/{{ $type }}?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

   <div class="main-new-link">
      <div class="l-block">
       <button class="m">Сортировать: <i class="fa fa-caret-down" aria-hidden="true"></i></button>
       <ul class="main-link">
    <?php $active = ($order === 'rating') ? 'success' : 'light'; ?>
           <li><a href="/offers/{{ $type }}?sort=rating">Голоса</a></li>

    <?php $active = ($order === 'created_at') ? 'success' : 'light'; ?>
    <li><a href="/offers/{{ $type }}?sort=time">Дата</a></li>

    <?php $active = ($order === 'status') ? 'success' : 'light'; ?>
    <li><a href="/offers/{{ $type }}?sort=status">Статус</a></li>

    <?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
    <li><a href="/offers/{{ $type }}?sort=comments">Комментарии</a></li>
          </ul>
   </div>
   <div class="l-block">
          @if (getUser())
           
            <a class="bt" href="/offers/create?type={{ $type }}">Добавить</a>
             
    @endif
   </div>
    </div>
     <div class="offers-nav-link">
    @if ($type === 'offer')
        <a href="/offers/offer">Предложения <span class="badge badge-light">{{ $page->total }}</span></a>
        <a class="red" href="/offers/issue">Проблемы <span class="badge badge-light">{{ $page->otherTotal }}</span></a>
    @else
        <a href="/offers/offer">Предложения <span class="badge badge-light">{{ $page->otherTotal }}</span></a>
        <a class="red" href="/offers/issue">Проблемы <span class="badge badge-light">{{ $page->total }}</span></a>
    @endif
</div>
    
    
    <div class="offers-block">
    @if ($offers->isNotEmpty())

        @foreach ($offers as $data)
           <div class="offers">
            <ul>
                <li><a href="/offers/{{ $data->id }}">{{ $data->title }}</a></li>
            </ul>
            <div class="statuses">
                <span>{!! $data->getStatus() !!}</span>
                <span>(Голосов: {{ $data->rating }})</span>
            </div>
            
           <div class="offers-text">{!! bbCode($data->text) !!}</div>
            
            <div class="offers-bottom">
            <span>Добавлено: {!! $data->user->getProfile() !!} <br> ({{ dateFixed($data->created_at) }})</span>
            <span class="comment"><a href="/offers/comments/{{ $data->id }}"><span class="icon"><i class="fa fa-comment"></i></span><span class="count">
                {{ $data->count_comments }}
            </span></a></span>
            <!--<a href="/offers/end/{{ $data['id'] }}">&raquo;</a>-->
            </div>
            
            </div>
        @endforeach
        </div>

        {!! pagination($page) !!}

        <div class="text-center">Всего записей: <b>{{ $page->total }}</b>
    </div>
    @else
        {!! showError('Записей еще нет!') !!}
    @endif
    
    </div>
@stop
