@extends('layout')

@section('title')
    Галерея (Стр. {{ $page->current }})
@stop

@section('content')


    <h1>Галерея</h1>

   <div class="photos-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Галерея</li>

            @if (isAdmin())
                <li class="breadcrumb-item"><a href="/admin/photos?page={{ $page->current }}">Управление</a></li>
            @endif
        </ol>
    </nav>

  
   <div class="main-new-link">
    @if (getUser())
      <div class="l-block">
       <button class="m"> Мои: <i class="fa fa-caret-down" aria-hidden="true"></i></button>
       <ul class="main-link">
           <li><a href="/photos/albums/{{ getUser('login') }}">фото</a></li>
           <li><a href="/photos/comments/{{ getUser('login') }}">комментарии</a></li>
        </ul>
       </div>
    @endif
    
    <div class="l-block">
   <button class="o">Все:<i class="fa fa-caret-down" aria-hidden="true"></i></button>
   <ul class="ob-link">
    <li><a href="/photos/albums">альбомы</a></li>
    <li><a href="/photos/comments">комментарии</a></li>
    <li><a href="/photos/top">Топ фото</a></li>
    </ul>
    </div>
    <div class="l-block">@if (getUser())
        
            <a class="bt" href="/photos/create">Добавить фото</a>
        
    @endif</div>
</div>
   
   <!-- @if (getUser())
        <div class="btns">
            <a  href="/photos/create">Добавить фото</a>
        </div>
    @endif-->
    
    <div class="photos-block">
    @if ($photos->isNotEmpty())
        @foreach ($photos as $photo)

           <div class="gallery">
            <ul>
                <li><a href="/photos/{{ $photo->id }}">{{ $photo->title }} (Рейтинг: {!! formatNum($photo->rating) !!})</a></li>
                
            </ul>

            <div class="gallery-img">
                <?php $countFiles = $photo->files->count() ?>
                <div id="myCarousel{{ $loop->iteration }}" class="carousel slide" data-ride="carousel">
                    @if ($countFiles > 1)
                        <ol class="carousel-indicators">
                            @for ($i = 0; $i < $countFiles; $i++)
                                <li data-target="#myCarousel{{ $loop->iteration }}" data-slide-to="{{ $i }}"{!! empty($i) ? ' class="active"' : '' !!}></li>
                            @endfor
                        </ol>
                    @endif

                    <div class="carousel-inner">
                        @foreach ($photo->files as $file)
                        <div class="carousel-item{{ $loop->first ? ' active' : '' }}">
                            <a href="/photos/{{ $photo->id }}">{!! resizeImage($file->hash, ['alt' => $photo->title, 'class' => 'img-fluis']) !!}</a>
                        </div>
                        @endforeach
                    </div>

                    @if ($countFiles > 1)
                        <a class="carousel-control-prev" href="#myCarousel{{ $loop->iteration }}" role="button" data-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                        </a>
                        <a class="carousel-control-next" href="#myCarousel{{ $loop->iteration }}" role="button" data-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                        </a>
                    @endif
                </div>
                </div>

               <div class="gallery-text">
                @if ($photo->text)
                    {!! bbCode($photo->text) !!}
                    
                @endif
                </div>

               <div class="gallery-bottom">
                <span>Добавлено: {!! $photo->user->getProfile() !!} <br> ({{ dateFixed($photo->created_at) }})</span>
                <span class="comment"><a href="/photos/comments/{{ $photo->id }}"><i class="fa fa-comment"></i> <span class="count">{{ $photo->count_comments }}</span></a></span> 
                <!--<a href="/photos/end/{{ $photo->id }}">&raquo;</a>-->
                </div>
            
            </div>
        @endforeach
</div>

        {!! pagination($page) !!}

       <div class="vsego">
        Всего фотографий: <b>{{ $page->total }}</b>
</div>
        

    @else
        {!! showError('Фотографий нет, будь первым!') !!}
    @endif
    
    </div>
@stop
