@extends('layout')

@section('title')
    Топ популярных фотографий
@stop

@section('content')

    <h1>Топ популярных фотографий</h1>
<div class="photos-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item active">Топ популярных фотографий</li>
        </ol>
    </nav>

    @if ($photos->isNotEmpty())

       <div class="main-new-link">
       <div class="l-block">
       <button class="m">Сортировать: <i class="fa fa-caret-down" aria-hidden="true"></i></button>
       <ul class="main-link">
        <li><?php $active = ($order === 'rating') ? 'success' : 'light'; ?>
           <a href="/photos/top?sort=rating">Оценки</a></li>

        <li><?php $active = ($order === 'count_comments') ? 'success' : 'light'; ?>
        <a href="/photos/top?sort=comments">Комментарии</a></li>
        </ul>
        </div>
    </div>


       <div class="photos-block">
        @foreach ($photos as $photo)
           <div class="gallery">
            <ul>
                <li><a href="/photos/{{ $photo->id }}"> {{ $photo->title }} ({!! formatNum($photo->rating) !!})</a></li>
            </ul>

            <div class="gallery-img">
                <?php $countFiles = $photo->files->count() ?>
    
                    @if ($countFiles > 1)
                        <ol class="carousel-indicators">
                            @for ($i = 0; $i < $countFiles; $i++)
                                <li data-target="#myCarousel{{ $loop->iteration }}" data-slide-to="{{ $i }}"{!! empty($i) ? ' class="active"' : '' !!}></li>
                            @endfor
                        </ol>
                    @endif

                    <div class="carousel-inner">
                        @foreach ($photo->files as $file)
                            <div class="carousel-item{{ $loop->first ? ' active' : '' }}">
                                {!! resizeImage($file->hash, ['alt' => $photo->title, 'class' => 'img-fluis']) !!}
                            </div>
                        @endforeach
                    </div>

                    @if ($countFiles > 1)
                        <a class="carousel-control-prev" href="#myCarousel{{ $loop->iteration }}" role="button" data-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                        </a>
                        <a class="carousel-control-next" href="#myCarousel{{ $loop->iteration }}" role="button" data-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                        </a>
                    @endif
                
    </div>

               <div class="gallery-text">{!! bbCode($photo->text) !!}</div>
                

               <div class="gallery-bottom">
                <span>Добавлено: {!! $photo->user->getProfile() !!} <br> ({{ dateFixed($photo->created_at) }})</span>
                <span class="comment">
                <a href="/photos/comments/{{ $photo->id }}"><i class="fa fa-comment"></i>  <span class="count">{{ $photo->count_comments }}</span></a> </span>
                <!--<a href="/photos/end/{{ $photo->id }}">&raquo;</a>-->
                </div>
           
            </div>
        @endforeach
</div>

        {!! pagination($page) !!}
    @else
        {!! showError('Загруженных фотографий еще нет!') !!}
    @endif
    </div>
@stop
