@extends('layout')

@section('title')
    Альбом {{ $user->login }} (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Альбом {{ $user->login }}</h1>
<div class="photos-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item active">Альбом {{ $user->login }}</li>
        </ol>
    </nav>

   <div class="photos-block">
    @if ($photos->isNotEmpty())

        @foreach ($photos as $photo)
            <div class="gallery">
               
                <ul>
                <li><a href="/photos/{{ $photo->id }}"> {{ $photo->title }}</a></li>
                </ul>

              
                @if ($moder)
                    <div class="del">
                    <a href="/photos/edit/{{ $photo->id }}?page={{ $page->current }}">Редактировать</a>
                    <a href="/photos/delete/{{ $photo->id }}?page={{ $page->current }}&amp;token={{ $_SESSION['token'] }}" onclick="return confirm('Вы подтверждаете удаление изображения?')">Удалить</a>
                    </div>
                @endif
            
            <div class="gallery-img">
                <?php $countFiles = $photo->files->count() ?>
                
                    @if ($countFiles > 1)
                        <ol class="carousel-indicators">
                            @for ($i = 0; $i < $countFiles; $i++)
                                <li data-target="#myCarousel{{ $loop->iteration }}" data-slide-to="{{ $i }}"{!! empty($i) ? ' class="active"' : '' !!}></li>
                            @endfor
                        </ol>
                    @endif

                    <div class="carousel-inner">
                        @foreach ($photo->files as $file)
                            <div class="carousel-item{{ $loop->first ? ' active' : '' }}">
                                {!! resizeImage($file->hash, ['alt' => $photo->title, 'class' => 'img-fluis']) !!}
                            </div>
                        @endforeach
                    </div>

                    @if ($countFiles > 1)
                        <a class="carousel-control-prev" href="#myCarousel{{ $loop->iteration }}" role="button" data-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                        </a>
                        <a class="carousel-control-next" href="#myCarousel{{ $loop->iteration }}" role="button" data-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                        </a>
                    @endif
               
    </div>
                <div class="gallery-text">

                @if ($photo->text)
                   {!! bbCode($photo->text) !!}
                   
                @endif
                </div>

               <div class="gallery-bottom">
                <span>Добавлено: {!! $photo->user->getProfile() !!} <br> ({{ dateFixed($photo->created_at) }})</span>
                <span class="comment"><a href="/photos/comments/{{ $photo->id }}"><i class="fa fa-comment"></i>  <span class="count">{{ $photo->count_comments }}</span></a></span>
                
                </div>
            
</div>
        @endforeach
</div>

        {!! pagination($page) !!}

       <div class="vsego">
        Всего фотографий: <b>{{ $page->total }}</b>
</div>
    @else
        {!! showError('Фотографий в альбоме еще нет!') !!}
    @endif

</div>
@stop
