@extends('layout')

@section('title')
    {{ $photo->title }}
@stop

@section('content')

    <h1>{{ $photo->title }}</h1>

   <div class="photos-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/photos">Галерея</a></li>
            <li class="breadcrumb-item"><a href="/photos/albums/{{ $photo->user->login }}">Альбом</a></li>
            <li class="breadcrumb-item active">{{ $photo->title }}</li>
        </ol>
    </nav>

<div class="photos-block">
  <div class="gallery">
   <div class="del">
    @if (isAdmin())
        <a href="/admin/photos/edit/{{ $photo->id }}">Редактировать</a>
       <a href="/admin/photos/delete/{{ $photo->id }}?token={{ $_SESSION['token'] }}" onclick="return confirm('Вы подтверждаете удаление изображения?')">Удалить</a>
    @endif

    @if ($photo->user->id == getUser('id') && ! isAdmin())
        <a href="/photos/edit/{{ $photo->id }}">Редактировать</a>
        <a href="/photos/delete/{{ $photo->id }}?token={{ $_SESSION['token'] }}" onclick="return confirm('Вы подтверждаете удаление изображения?')">Удалить</a>
    @endif
</div>
   
    <div class="gallery-img">
        @foreach ($photo->files as $file)
            <a href="{{ $file->hash }}" class="gallery" data-group="{{ $photo->id }}"><img  class="img-fluis" src="{{ $file->hash }}" alt="image"></a>
          
        @endforeach
      </div>

       <div class="gallery-text">
        @if ($photo->text)
            {!! bbCode($photo->text) !!}
            
        @endif
        </div>

        <div class="js-rating">
           <!--<span class="rats">Рейтинг:</span>-->
            @unless (getUser('id') == $photo->user_id)
                <a class="red post-rating-down<?= $photo->vote == '-' ? ' active' : '' ?>" href="#" onclick="return changeRating(this);" data-id="{{ $photo->id }}" data-type="{{ App\Models\Photo::class }}" data-vote="-" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-down"></i></a>
            @endunless
            <span>{!! formatNum($photo->rating) !!}</span>
            @unless (getUser('id') == $photo->user_id)
                <a class="post-rating-up<?= $photo->vote == '+' ? ' active' : '' ?>" href="#" onclick="return changeRating(this);" data-id="{{ $photo->id }}" data-type="{{ App\Models\Photo::class }}" data-vote="+" data-token="{{ $_SESSION['token'] }}"><i class="fa fa-thumbs-up"></i></a>
            @endunless
        </div>

       <div class="gallery-bottom">
           <span>Добавлено: {!! $photo->user->getProfile() !!} <br> ({{ dateFixed($photo->created_at) }})</span>
           <span class="comment"><a href="/photos/comments/{{ $photo->id }}"><i class="fa fa-comment"></i> <span class="count">
               {{ $photo->count_comments }}
           </span></a></span>
        
        <!--<a href="/photos/end/{{ $photo->id }}">&raquo;</a>-->
        </div>
   
    </div>
</div>

    <?php $nav = photoNavigation($photo->id); ?>

    @if ($nav['next'] || $nav['prev'])
        <div class="gallery-nav">
            @if ($nav['next'])
                <a href="/photos/{{ $nav['next'] }}"><i class="fa fa-arrow-left" aria-hidden="true"></i> Назад</a>
            @endif

            @if ($nav['prev'])
                <a href="/photos/{{ $nav['prev'] }}">Вперед <i class="fa fa-arrow-right" aria-hidden="true"></i> </a>
            @endif
        </div>
    @endif
    </div>
@stop
