@extends('layout')

@section('title')
    Рейтинг репутации (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Рейтинг репутации</h1>

   <div class="users-list-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Рейтинг репутации</li>
        </ol>
    </nav>

    @if ($users->isNotEmpty())
        @foreach($users as $key => $data)
           <div class="post">
            <div class="b">
                <div class="img">
                    {!! $data->getAvatar() !!}
                    {!! $data->getOnline() !!}
                </div>

                {{ ($page->offset + $key + 1) }}.

                @if ($user == $data->login)
                    <b>{!! $data->getProfile('#ff0000') !!}</b>
                @else
                    <b>{!! $data->getProfile() !!}</b>
                @endif
                (Репутация: {{ $data->rating }})<br>
                {!! $data->getStatus() !!}
            </div>

            <div class="user-list-end">
                Плюсов: {{ $data->posrating }} / Минусов: {{ $data->negrating }}<br>
                Дата регистрации: {{ dateFixed($data->created_at, 'd.m.Y') }}
            </div>
            </div>
        @endforeach

        {!! pagination($page) !!}

        <div class="form">
            <form action="/authoritylist" method="post">
                <div class="form-inline">
                    <div class="form-group{{ hasError('user') }}">
                        <input type="text" class="form-control" id="user" name="user" maxlength="20" value="{{ getInput('user', $user) }}" placeholder="Логин пользователя" required>
                    </div>

                    <button class="btns">Искать</button>
                </div>
                {!! textError('user') !!}
            </form>
        </div>

       <div class="po-centru"><span>Всего пользователей: <b>{{ $page->total }}</b></span></div>
     
    @else
        {!! showError('Пользователей еще нет!') !!}
    @endif
</div>
@stop
