@extends('layout')

@section('title')
    Рейтинг толстосумов (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Рейтинг толстосумов</h1>

   <div class="users-list-wrapp">
    @if ($users->isNotEmpty())
        @foreach($users as $key => $data)
           <div class="post">
            <div class="b">
                <div class="img">
                    {!! $data->getAvatar() !!}
                    {!! $data->getOnline() !!}
                </div>

                {{ ($page->offset + $key + 1) }}.

                @if ($user == $data->login)
                    <b>{!! $data->getProfile('#ff0000') !!}</b>
                @else
                    <b>{!! $data->getProfile() !!}</b>
                @endif
                ({{ plural($data->money, setting('moneyname')) }})<br>
                {!! $data->getStatus() !!}
            </div>

            <div class="user-list-end">
                Плюсов: {{ $data->posrating }} / Минусов: {{ $data->negrating }}<br>
                Дата регистрации: {{ dateFixed($data->created_at, 'd.m.Y') }}
            </div>
</div>
        @endforeach

        {!! pagination($page) !!}

        <div class="form">
            <form action="/ratinglists" method="post">
                <div class="form-inline">
                    <div class="form-group{{ hasError('user') }}">
                        <input type="text" class="form-control" id="user" name="user" maxlength="20" value="{{ getInput('user', $user) }}" placeholder="Логин пользователя" required>
                    </div>

                    <button class="btns">Искать</button>
                </div>
                {!! textError('user') !!}
            </form>
        </div>

       <div class="po-centru"><span>Всего пользователей: <b>{{ $page->total }}</b></span></div>
       
    @else
        {!! showError('Пользователей еще нет!') !!}
    @endif
</div>
@stop
