@extends('layout')

@section('title')
    Голосования (Стр. {{ $page->current }})
@stop

@section('content')

    <h1>Голосования</h1>
<div class="votes-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item active">Голосования</li>
        </ol>
    </nav>

<div class="main-new-link">
  @if (getUser())
        <div class="l-block">
            <a class="bt" href="/votes/create">Создать голосование</a>
        </div>
    @endif
   </div>
   
   <div class="votes-block">
    @if ($votes->isNotEmpty())
        @foreach ($votes as $vote)
           <div class="votes">
            <ul>
                <li><a href="/votes/{{ $vote['id'] }}"><span class="icon"> <i class="fa fa-chart-bar"></i></span>{{ $vote->title }}
                 <div class="votes-bottom">
                   <span>Создано: {{ dateFixed($vote->created_at) }}</span>
                   <span>Всего голосов: {{ $vote->count }}</span>
                </div>
                </a>
                 @if ($vote->topic->id)
                    <a class="f" href="/topics/{{ $vote->topic->id }}"> Тема: {{ $vote->topic->title }}</a>
                @endif
                </li>
            </ul>
           
              

               <!--<div class="news-bottom">
                   <span>Создано: {{ dateFixed($vote->created_at) }}</span>
                   <span>Всего голосов: {{ $vote->count }}</span>
                </div>-->
            </div>
        @endforeach
        </div>

        {!! pagination($page) !!}
    @else
        {!! showError('Открытых голосований еще нет!') !!}
    @endif

   <div class="post-nav-link"><a href="/votes/history"><span class="icon"><i class="fa fa-briefcase"></i> </span>Архив голосований</a></div>
    </div>
@stop
