@extends('layout')

@section('title')
    {{ $vote->title }}
@stop

@section('content')

    <h1>{{ $vote->title }}</h1>
<div class="votes-wrapp">
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/"><i class="fas fa-home"></i></a></li>
            <li class="breadcrumb-item"><a href="/votes">Голосования</a></li>
            <li class="breadcrumb-item active">{{ $vote->title }}</li>
        </ol>
    </nav>

  
  <div class="votes-block">
   <div class="votes">
    @if ($vote->topic->id)
         <a class="f" href="/topics/{{ $vote->topic->id }}">Тема: {{ $vote->topic->title }}</a>
    @endif

   <div class="view">
    @if ((getUser() && empty($vote->poll)) && empty($show))
        <form action="/votes/{{ $vote->id }}" method="post">
            <input type="hidden" name="token" value="{{ $_SESSION['token'] }}">

            @foreach($vote->answers as $answer)
                <label><input name="poll" type="radio" value="{{ $answer['id'] }}"> {{ $answer['answer'] }}</label>
            @endforeach
            
            
            <button class="btns">Голосовать</button>
           
        </form>
      

        <div class="center-text">Проголосовало: <b>{{ $vote->count }}</b></div>
        <div class="post-nav-link">
         <a href="/votes/{{ $vote->id }}?show=true"><i class="fa fa-history"></i> Результаты</a>
         </div>

   
   
    @else
        @foreach ($info['voted'] as $key => $data)
            <?php $proc = round(($data * 100) / $info['sum'], 1); ?>
            <?php $maxproc = round(($data * 100) / $info['max']); ?>

            <div class="vsego-golos"><b>{{ $key }}</b> (Голосов: {{ $data }})</div>
            {!! progressBar($maxproc, $proc.'%') !!}
        @endforeach
       </div>
       
      <div class="center-text">Проголосовало: <b>{{ $vote->count }}</b></div>

       <div class="post-nav-link">
        @if (! empty($show))
            <a href="/votes/{{ $vote->id }}"> <i class="fa fa-chart-bar"></i> К вариантам</a>
        @endif
         <a href="/votes/voters/{{ $vote->id }}"><i class="fa fa-users"></i> Проголосовавшие</a>
        </div>
    @endif
    </div>
    </div>
    </div>
@stop
