<div class="row">
    <div class="col-md-12">
        <div class="head-title">
            <div class="name">Posts Reach and Posts Impressions</div>
            <div class="desc">The number of people who saw any of your Page posts and the number of impressions that came from all of your posts.</div>
        </div>
        <div class="ajax_postsrearchchart"></div>
        <div class="foot-title">
            <span class="total_posts_reach"></span> Reach | <span class="total_posts_impressions"></span> Impressions
        </div>
    </div>
    <div class="col-md-12">
        <div class="head-title">
            <div class="name">Page Posts Reach Breakdown By Type</div>
            <div class="desc">The number of people who saw your Page posts in an Ad or Sponsored Story and the number of people who saw your Page posts in News Feed or Ticker, or on your Page's Wall.</div>
        </div>
        <div class="ajax_postsrearchpaidchart"></div>
        <div class="foot-title">
            <span class="total_posts_reach_paid"></span> Paid Reach | <span class="total_posts_reach_organic"></span> Organic Reach
        </div>
    </div>
    <div class="col-md-12">
        <div class="head-title">
            <div class="name">Page Posts Impressions Breakdown By Type</div>
            <div class="desc">The number of impressions of your Page posts in an Ad or Sponsored Story and The number of impressions of your posts in News Feed or Ticker or on your Page.</div>
        </div>
        <div class="ajax_postsimpressionspaidchart"></div>
        <div class="foot-title">
            <span class="total_posts_impressions_paid"></span> Paid Impressions | <span class="total_posts_impressions_organic"></span> Organic Impressions
        </div>
    </div>
    <div class="col-md-6">
        <div class="head-title">
            <div class="name">Engaged Users</div>
            <div class="desc">The number of people who engaged with your Page. Engagement includes any click.<br/><br/></div>
        </div>
        <div class="ajax_page_engaged_users"></div>
    </div>

    <div class="col-md-6">
        <div class="head-title">
            <div class="name">Page Consumptions</div>
            <div class="desc">The number of people who clicked on any of your content and The number of times people clicked on any of your content.</div>
        </div>
        <div class="ajax_page_consumptions"></div>
    </div>

    <div class="col-md-12">
        <div class="head-title">
            <div class="name">Page Posts Frequency</div>
            <div class="desc">The number of people who saw your Page posts, broken down by how many times people saw your posts</div>
        </div>
        <div class="ajax_page_posts_impressions_frequency_distribution"></div>
    </div>


    <div class="col-md-12 mt40">
        <div class="head-title">
            <div class="name">The Nummber Click By Type</div>
            <div class="desc">The number of people who clicked on any of your content, by type</div>
        </div>
        <div class="ajax_page_consumptions_by_consumption_type_unique"></div>
        <div class="row">
            <div class="col-sm-3 col-xs-6 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_link_clicks"></h5>
                    <span class="description-text">Link Clicks</span>
                </div>
            </div>
            <div class="col-sm-3 col-xs-6 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_photo_view"></h5>
                    <span class="description-text">Photo View</span>
                </div>
            </div>
            <div class="col-sm-3 col-xs-6 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_video_play"></h5>
                    <span class="description-text">Video Play</span>
                </div>
            </div>
            <div class="col-sm-3 col-xs-6 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_other_clicks"></h5>
                        <span class="description-text">Other Clicks</span>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-12 mt40">
        <div class="head-title">
            <div class="name">The Positive Feedback By Type</div>
            <div class="desc">The number of people who took a positive action broken down by type.</div>
        </div>
        <div class="ajax_page_positive_feedback_by_type"></div>
        <div class="row">
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_positive_like"></h5>
                    <span class="description-text">Like</span>
                </div>
            </div>
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_positive_comment"></h5>
                    <span class="description-text">Comment</span>
                </div>
            </div>
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_positive_link"></h5>
                    <span class="description-text">Link</span>
                </div>
            </div>
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_positive_answer"></h5>
                    <span class="description-text">Answer</span>
                </div>
            </div>
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_positive_claim"></h5>
                    <span class="description-text">Claim</span>
                </div>
            </div>
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_positive_rsvp"></h5>
                    <span class="description-text">RSVP</span>
                </div>
            </div>
        </div>
    </div>

	<div class="col-md-12 mt40">
        <div class="head-title">
            <div class="name">Negative Feedback By Type</div>
            <div class="desc">The number of times people took a negative action broken down by type.</div>
        </div>
		<div class="ajax_negative"></div>
        <div class="row">
            <div class="col-sm-2 col-xs-4 col-sm-offset-1 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_hide_clicks"></h5>
                    <span class="description-text">Hide Clicks</span>
                </div>
            </div>
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_hide_all_clicks"></h5>
                    <span class="description-text">Hide All Clicks</span>
                </div>
            </div>
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_report_spam_clicks"></h5>
                    <span class="description-text">Report Spam Clicks</span>
                </div>
            </div>
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_unlike_page_clicks"></h5>
                        <span class="description-text">Unlike Page Clicks</span>
                </div>
            </div>
            <div class="col-sm-2 col-xs-4 border-right">
                <div class="description-block">
                    <h5 class="description-header text-red total_xbutton_clicks"></h5>
                    <span class="description-text">Xbutton Clicks</span>
                </div>
            </div>
        </div>
	</div>
</div>

<script type="text/javascript">
	$(function(){
        var data_posts_reach               = [<?=!empty($data_posts_reach)?$data_posts_reach:""?>];
        var data_posts_impressions         = [<?=!empty($data_posts_impressions)?$data_posts_impressions:""?>];
        var data_posts_reach_paid          = [<?=!empty($data_posts_reach_paid)?$data_posts_reach_paid:""?>];
        var data_posts_reach_organic       = [<?=!empty($data_posts_reach_organic)?$data_posts_reach_organic:""?>];
        var data_posts_impressions_paid    = [<?=!empty($data_posts_impressions_paid)?$data_posts_impressions_paid:""?>];
        var data_posts_impressions_organic = [<?=!empty($data_posts_impressions_organic)?$data_posts_impressions_organic:""?>];

        var data_page_engaged_users        = [<?=!empty($data_page_engaged_users)?$data_page_engaged_users:""?>];
        var data_page_consumptions         = [<?=!empty($data_page_consumptions)?$data_page_consumptions:""?>];
        var data_page_consumptions_unique  = [<?=!empty($data_page_consumptions_unique)?$data_page_consumptions_unique:""?>];

        var data_like    = [<?=!empty($data_page_positive_feedback_by_type)?$data_page_positive_feedback_by_type['like']:""?>];
        var data_comment = [<?=!empty($data_page_positive_feedback_by_type)?$data_page_positive_feedback_by_type['comment']:""?>];
        var data_link    = [<?=!empty($data_page_positive_feedback_by_type)?$data_page_positive_feedback_by_type['link']:""?>];
        var data_answer  = [<?=!empty($data_page_positive_feedback_by_type)?$data_page_positive_feedback_by_type['answer']:""?>];
        var data_claim   = [<?=!empty($data_page_positive_feedback_by_type)?$data_page_positive_feedback_by_type['claim']:""?>];
        var data_rsvp    = [<?=!empty($data_page_positive_feedback_by_type)?$data_page_positive_feedback_by_type['rsvp']:""?>];
        
        var data_link_clicks   = [<?=!empty($data_page_consumptions_by_consumption_type_unique)?$data_page_consumptions_by_consumption_type_unique['link_clicks']:""?>];
        var data_photo_view    = [<?=!empty($data_page_consumptions_by_consumption_type_unique)?$data_page_consumptions_by_consumption_type_unique['photo_view']:""?>];
        var data_video_play    = [<?=!empty($data_page_consumptions_by_consumption_type_unique)?$data_page_consumptions_by_consumption_type_unique['video_play']:""?>];
        var data_other_clicks  = [<?=!empty($data_page_consumptions_by_consumption_type_unique)?$data_page_consumptions_by_consumption_type_unique['other_clicks']:""?>];

        var data_unlike_page_clicks = [<?=!empty($data_negative)?$data_negative['unlike_page_clicks']:""?>];
        var data_report_spam_clicks = [<?=!empty($data_negative)?$data_negative['report_spam_clicks']:""?>];
        var data_xbutton_clicks     = [<?=!empty($data_negative)?$data_negative['xbutton_clicks']:""?>];
        var data_hide_all_clicks    = [<?=!empty($data_negative)?$data_negative['hide_all_clicks']:""?>];
        var data_hide_clicks        = [<?=!empty($data_negative)?$data_negative['hide_clicks']:""?>];

        var data_page_posts_impressions_frequency_distribution = [<?=!empty($data_page_posts_impressions_frequency_distribution)?$data_page_posts_impressions_frequency_distribution:""?>];
        Analytics.Highcharts({
            element : '.ajax_page_posts_impressions_frequency_distribution',
            titlex  : 'nummber',
            titley  : '',
            colorx  : '#fff600',
            colory  : '#fff600',
            type    : 'column',
            formatterx: 'text',
            name    : 'Page Posts Frequency',
            tick    : 1,
            data    : data_page_posts_impressions_frequency_distribution
        });

        Analytics.Highcharts({
            element : '.ajax_postsrearchchart',
            titlex  : 'datetime',
            crosshairs : true,
            multi   : true,
            data    : [{
                type   : 'spline',
                color  : '#00a65a',
                name   : "Reach",
                data   : data_posts_reach
            },{
                type   : 'spline',
                color  : '#dd4b39',
                name   : "Impressions",
                data   : data_posts_impressions
            }]
        });

        Analytics.Highcharts({
            element : '.ajax_postsrearchpaidchart',
            titlex  : 'datetime',
            crosshairs : true,
            multi   : true,
            data    : [{
                type   : 'spline',
                color  : '#0066ff',
                name   : "Paid Reach",
                data   : data_posts_reach_paid
            },{
                type   : 'spline',
                color  : '#ff8a00',
                name   : "Organic Reach",
                data   : data_posts_reach_organic
            }]
        });

        Analytics.Highcharts({
            element : '.ajax_postsimpressionspaidchart',
            titlex  : 'datetime',
            crosshairs : true,
            multi   : true,
            data    : [{
                type   : 'spline',
                color  : '#333333',
                name   : "Paid Impressions",
                data   : data_posts_impressions_paid
            },{
                type   : 'spline',
                color  : '#ff006c',
                name   : "Organic Impressions",
                data   : data_posts_impressions_organic
            }]
        });

        Analytics.Highcharts({
            element : '.ajax_page_engaged_users',
            titlex  : 'datetime',
            multi   : true,
            data    : [{
                type   : 'line',
                color  : '#00a65a',
                name   : "Page Engaged Users",
                data   : data_page_engaged_users
            }]
        });

        Analytics.Highcharts({
            element : '.ajax_page_consumptions',
            titlex  : 'datetime',
            crosshairs : true,
            multi   : true,
            data    : [{
                type   : 'spline',
                name   : "Times People Clicked",
                data   : data_page_consumptions
            },{
                type   : 'spline',
                name   : "People Who Clicked",
                data   : data_page_consumptions_unique
            }]
        });


        Analytics.Highcharts({
            element : '.ajax_page_consumptions_by_consumption_type_unique',
            titlex  : 'datetime',
            crosshairs : true,
            multi   : true,
            data    : [{
                type   : 'spline',
                color  : '#F62459',
                name   : "Timeline",
                data   : data_link_clicks
            },{
                type   : 'spline',
                color  : '#D91E18',
                name   : "Photos",
                data   : data_photo_view
            },{
                type   : 'spline',
                color  : '#9A12B3',
                name   : "Photos albums",
                data   : data_video_play
            },{
                type   : 'spline',
                color  : '#2ECC71',
                name   : "Profile",
                data   : data_other_clicks
            }]
        });

        Analytics.Highcharts({
            element : '.ajax_page_positive_feedback_by_type',
            titlex  : 'datetime',
            crosshairs : true,
            multi   : true,
            data    : [{
                type   : 'spline',
                name   : "Like",
                data   : data_like
            },{
                type   : 'spline',
                name   : "Comment",
                data   : data_comment
            },{
                type   : 'spline',
                name   : "Link",
                data   : data_link
            },{
                type   : 'spline',
                name   : "Answer",
                data   : data_answer
            },{
                type   : 'spline',
                name   : "Claim",
                data   : data_claim
            },{
                type   : 'spline',
                name   : "RSVP",
                data   : data_rsvp
            }]
        });

    	Analytics.Highcharts({
            element : '.ajax_negative',
            titlex  : 'datetime',
            crosshairs : true,
            multi   : true,
            data    : [{
                type   : 'spline',
                color  : '#F62459',
                name   : "Unlike Page Clicks",
                data   : data_unlike_page_clicks
            },{
                type   : 'spline',
                color  : '#D91E18',
                name   : "Report Spam Clicks",
                data   : data_report_spam_clicks
            },{
                type   : 'spline',
                color  : '#9A12B3',
                name   : "Xbutton Clicks",
                data   : data_xbutton_clicks
            },{
                type   : 'spline',
                color  : '#2ECC71',
                name   : "Hide All Clicks",
                data   : data_hide_all_clicks
            },{
                type   : 'spline',
                color  : '#F89406',
                name   : "Hide Clicks",
                data   : data_hide_clicks
            }]
        });

        Analytics.CountValue("total_posts_reach",data_posts_reach);
        Analytics.CountValue("total_posts_impressions",data_posts_impressions);
        Analytics.CountValue("total_posts_reach_paid",data_posts_reach_paid);
        Analytics.CountValue("total_posts_reach_organic",data_posts_reach_organic);
        Analytics.CountValue("total_posts_impressions_paid",data_posts_impressions_paid);
        Analytics.CountValue("total_posts_impressions_organic",data_posts_impressions_organic);

        Analytics.CountValue("total_link_clicks",data_link_clicks);
        Analytics.CountValue("total_photo_view",data_photo_view);
        Analytics.CountValue("total_video_play",data_video_play);
        Analytics.CountValue("total_other_clicks",data_other_clicks);

        Analytics.CountValue("total_positive_like",data_like);
        Analytics.CountValue("total_positive_comment",data_comment);
        Analytics.CountValue("total_positive_link",data_link);
        Analytics.CountValue("total_positive_answer",data_answer);
        Analytics.CountValue("total_positive_claim",data_claim);
        Analytics.CountValue("total_positive_rsvp",data_rsvp);

        Analytics.CountValue("total_unlike_page_clicks", data_unlike_page_clicks);
        Analytics.CountValue("total_report_spam_clicks", data_report_spam_clicks);
        Analytics.CountValue("total_xbutton_clicks", data_xbutton_clicks);
        Analytics.CountValue("total_hide_all_clicks", data_hide_all_clicks);
        Analytics.CountValue("total_hide_clicks", data_hide_clicks);
	});
</script>