<?php

require_once ('../includes/start.php');
require_once ('../includes/functions.php');
require_once ('../includes/header.php');
include_once ('../themes/'.$config['themes'].'/verh.dat');

$minfind = 3; // Минимальное кол-во символов в слове для поиска
$maxfind = 25; // Максимальное кол-во символов в слове для поиска

$act = (isset($_GET['act'])) ? check($_GET['act']) : 'index';
$start = (isset($_GET['start'])) ? abs(intval($_GET['start'])) : 0;

show_title('Поиск по Дневнику');

switch ($act):
############################################################################################
##                                    Вывод всех сообщений                                ##
############################################################################################
case "index":
	echo'<div class="form">';
	echo'<form action="search.php?act=search" method="get">';
	echo'<input type="hidden" name="act" value="search">';

	echo'<b>Запрос:</b><br><input type="text" name="find"><br><br>';

	echo'<b>Искать:</b><br>';
	echo'<input name="where" type="radio" value="1" checked="checked"> В темах<br>';
	echo'<input name="where" type="radio" value="2"> В сообщениях<br><br>';

/*	В свободное время доработаю
	echo'<b>Тип запроса:</b><br>';
	echo'<input name="type" type="radio" value="1" checked="checked"> Или<br>';
	echo'<input name="type" type="radio" value="2"> И<br>';*/

	echo'<br><input type="submit" value="Поиск"></form></div><br>';

break;

############################################################################################
##                                          Поиск                                         ##
############################################################################################
case 'search':

	$find = (isset($_REQUEST['find'])) ? check($_REQUEST['find']) : '';
	$type = (isset($_REQUEST['type'])) ? abs(intval($_REQUEST['type'])) : 1;
	$where = (isset($_REQUEST['where'])) ? abs(intval($_REQUEST['where'])) : 1;

	if (!is_utf($find)){
		$find = win_to_utf($find);
	}

	if (utf_strlen($find) >= $minfind && utf_strlen($find) <= $maxfind) {

		$config['newtitle'] = $find.' - Результаты поиска';

	//-------------------------- Поиск в темах ----------------------------------//
	if ($where == 1){
		echo'Поиск запроса <b>&quot;'.$find.'&quot;</b> в темах<br>';

		// Индексирование всех тем на сутки
		if (@filemtime(DATADIR."datatmp/forumtopics.dat") < time() - 3600 * 24) {
			$filetopics = glob(DATADIR.'dataforum/topic*.dat');

			if (is_array($filetopics)) {
				$arrtopics = array();
				foreach ($filetopics as $topic){
					$arrtopics[] = file_get_contents($topic);
				}
				file_put_contents(DATADIR."datatmp/forumtopics.dat", $arrtopics, LOCK_EX);
			}
		}

		$filetopics = file(DATADIR."datatmp/forumtopics.dat");

		// Поиск точного совпадения
		$topics = array();
		foreach ($filetopics as $cachetopics){
			$cachedata = explode('|', $cachetopics);

			if (utf_stristr($cachedata[3], $find)){
				$topics[] = $cachetopics;
			}
		}


		$total = count($topics);
		if ($total > 0) {
			echo'Найдено совпадений: <b>'.$total.'</b><br><br>';

			if ($start < 0 || $start >= $total){$start = 0;}
			if ($total < $start + $config['forumtem']){ $end = $total; }
			else {$end = $start + $config['forumtem']; }
			for ($i = $start; $i < $end; $i++){

				$data = explode("|", $topics[$i]);

				if ($data[5] == 1) {
				} elseif($data[6] == 1) {
				} else {
				}

				$totalpost = counter_string(DATADIR.'dataforum/'.$data[1].'-'.$data[0].'.dat');

				echo'<div class="b">';
				echo'<b><a href="topic.php?fid='.$data[1].'&amp;id='.$data[0].'">'.$data[3].'</a></b> ('.$totalpost.')</div>';

				if($totalpost>0){
					$filepost = file(DATADIR.'dataforum/'.$data[1].'-'.$data[0].'.dat');
					$datapost = explode("|", end($filepost));

					$lastpage = ceil($totalpost/$config['forumpost']) * $config['forumpost'] - $config['forumpost'];

					echo'<div>Страницы: ';
					forum_navigation('topic.php?fid='.$datapost[1].'&amp;id='.$datapost[0].'&amp;', $config['forumpost'], $totalpost);

					echo'Сообщение: '.nickname($datapost[2]).' ('.date_fixed($datapost[5]).')</div>';

					} else {echo'Тема пустая! Сообщений еще нет!';}
			}

			page_strnavigation('search.php?act=search&amp;find='.$find.'&amp;type='.$type.'&amp;where='.$where.'&amp;', $config['forumtem'], $start, $total);

		} else {
			show_error('По вашему запросу ничего не найдено!');
		}
	}

	//------------------------- Поиск в сообщениях ------------------------------//
	if ($where == 2){
		echo'Поиск запроса <b>&quot;'.$find.'&quot;</b> в сообщениях<br>';

		// Индексирование всех сообщений на сутки
		if (@filemtime(DATADIR."datatmp/forumposts.dat") < time() - 3600 * 24) {
			$fileposts = glob(DATADIR.'dataforum/*-*.dat');

			if (is_array($fileposts)) {
				$arrposts = array();
				foreach ($fileposts as $post){
					$arrposts[] = file_get_contents($post);
				}
				file_put_contents(DATADIR."datatmp/forumposts.dat", $arrposts, LOCK_EX);
			}
		}

		$fileposts = file(DATADIR."datatmp/forumposts.dat");

		$posts = array();
		foreach ($fileposts as $cacheposts){
			$cachedata = explode('|', $cacheposts);

			if (utf_stristr($cachedata[3], $find)){
				$posts[] = $cacheposts;
			}
		}

		$total = count($posts);
		if ($total > 0) {
			echo'Найдено совпадений: <b>'.$total.'</b><br><br>';

			if ($start < 0 || $start >= $total){$start = 0;}
			if ($total < $start + $config['forumpost']){ $end = $total; }
			else {$end = $start + $config['forumpost']; }
			for ($i = $start; $i < $end; $i++){

				$data = explode("|", $posts[$i]);

				$topic = search_string(DATADIR."dataforum/topic".$data[1].".dat", $data[0], 0);
				if ($topic) {

					echo'<div class="b"><b><a href="topic.php?fid='.$data[1].'&amp;id='.$data[0].'">'.$topic[3].'</a></b></div>';
					echo'<div>'.bb_code($data[3]).'<br>';
					echo'Написал: <a href="/pages/anketa.php?uz='.$data[2].'">'.nickname($data[2]).'</a> '.user_online($data[2]).' ('.date_fixed($data[5]).')</div>';
				}
			}

			page_strnavigation('search.php?act=search&amp;find='.$find.'&amp;type='.$type.'&amp;where='.$where.'&amp;', $config['forumpost'], $start, $total);


		} else {
			show_error('По вашему запросу ничего не найдено!');
		}
	}

	} else {
		show_error('Ошибка! Запрос должен содержать от 3 до 50 символов!');
	}

	echo'<a href="search.php">Вернуться</a><br>';
break;

default:
redirect("search.php");
endswitch;

echo'<a href="index.php">В Дневник</a><br>';
echo'<a href="/index.php"></a><br>';

include_once ('../themes/'.$config['themes'].'/niz.dat');
?>
