<?php

//define('MOTOR_VERSION', '25.0');

$debugmode = 1;

if ($debugmode) {
    @error_reporting(E_ALL);
    @ini_set('display_errors', true);
    @ini_set('html_errors', true);
    @ini_set('error_reporting', E_ALL);
} else {
    @error_reporting(E_ALL ^ E_NOTICE);
    @ini_set('display_errors', false);
    @ini_set('html_errors', false);
    @ini_set('error_reporting', E_ALL ^ E_NOTICE);
}

//session_name('SID');
session_start();

$starttime = microtime(1);
$ip = $ip_addr = preg_replace('|[^0-9\.]|', '', $_SERVER['REMOTE_ADDR']);

if (version_compare(PHP_VERSION, '5.2.1') < 0) {
    die('<b>Ошибка! Версия PHP должна быть 5.2.1 или выше!</b>');
}

if (get_magic_quotes_gpc()) {
    $in = array(& $_GET, & $_POST, & $_COOKIE);
    while (list($k, $v) = each($in)) {
        foreach ($v as $key => $val) {
            if (!is_array($val)) {
                $in[$k][$key] = stripslashes($val);
                continue;
            }
            $in[] = & $in[$k][$key];
        }
    }
    unset ($in);
    if (!empty ($_FILES)) {
        foreach ($_FILES as $k => $v) {
            $_FILES[$k]['name'] = stripslashes((string) $v['name']);
        }
    }
}

$level = 0;
$folder_level = '';
while (!file_exists($folder_level.'in.php') && $level < 5) {
    $folder_level .= '../';
    ++$level;
}
unset($level);

define('BASEDIR', $folder_level);
define('DATADIR', BASEDIR.'local/');
define('ADMINDIR', BASEDIR.'adm/');

############################################################################################
##                                  Настройки сайта                                       ##
############################################################################################
if (!file_exists(DATADIR.'config.dat')) {
    $files = glob(DATADIR."datalocal/*.dat");
    foreach ($files as $file) {
        copy($file, DATADIR.basename($file));
    }
}

if (file_exists(DATADIR.'config.dat')){
$con_text = file_get_contents(DATADIR.'config.dat');
$con_data = explode('|',$con_text);

$config['keypass'] = $con_data[1];                  #  Ключ для шифровки/расшифровки паролей coockies
$config['themes'] = $con_data[2];                   #  Название скина/темы, посмотреть их можно в папке themes
$config['karantin'] = $con_data[3];                 #  Время карантина новичков
$config['generics'] = $con_data[5];                 #  Показывать время генерации страницы, если нет, то пишем 0
$config['onlines'] = $con_data[7];                  #  Показывать сколько человек в онлайне, если нет, то пишем 0
$config['nickname'] = $con_data[8]; 	            #  Логин суперадминистратора
$config['emails'] = $con_data[9];                   #  E-mail суперадминистратора
$config['timeclocks'] = $con_data[10];              #  Временной сдвиг серверного времени
$config['title'] = $con_data[11];                   #  Заголовок всех страниц
$config['logos'] = $con_data[12];                   #  Название, будет отображенно на каждой странице около логотипа
$config['copy'] = $con_data[13];                    #  Копирайт ,  будет отображенно внизу на каждой странице
$config['home'] = $con_data[14];                    #  Главная страница сайта
$config['logotip'] = $con_data[15];                 #  Адрес логотипа, вы можете просто заменить саму картинку в папке images
$config['ras'] = $con_data[16];                     #  Расширение страниц движка (по умолчанию mot)
$config['postnews'] = $con_data[17];                #  Новостей показывается на страницу
$config['lastnews'] = $con_data[18];                #  Cколько новостей выводить ? не надо то 0
$config['bookpost'] = $con_data[19];                #  Сообщений в гостевой показывается на страницу
$config['bookadds'] = $con_data[20];                #  Разрешать гостям писать в гостевой? Если 0, то запрещено
$config['guestsuser'] = $con_data[21];              #  Как представлять незарегистрированных посетителей
$config['maxpostbook'] = $con_data[25];             #  Какое количество  постов в гостевой сохраняется
$config['forumpost'] = $con_data[26];               #  Кол-во отображаемых сообщений на каждой странице в Дневнике
$config['forumtem'] = $con_data[27];                #  Кол-во отображаемых тем на страницу в Дневнике
$config['topforum'] = $con_data[28];                #  Oставлять последних тем
$config['floodstime'] = $con_data[29];              #  Время антифлуда между сообщениями в сек.
$config['limitsmail'] = $con_data[30];              #  Размер ящика для привата пользователей в kb
$config['userlist'] = $con_data[31];                #  Количество пользователей в Юзерлисте на страницу
$config['privatpost'] = $con_data[33];              #  Писем на страницу в привате
$config['showuser'] = $con_data[44];                #  Вывод на стр. в кто-где
$config['lastusers'] = $con_data[45];               #  Сохраняется истории в кто-где (maх 100)
$config['cookies'] = $con_data[50];                 #  Разрешить вход по кукам
$config['referer'] = $con_data[51];	                #  Сохраняется рефереров
$config['nocache'] = $con_data[52];                 #  Кэширование 0-выкл 1-вкл
$config['showlink'] = $con_data[53];                #  Выводится  ccылок если не надо то 0
$config['onlinelist'] = $con_data[54];	            #  Юзеров на страницу в онлайне
$config['smilelist'] = $con_data[55];	            #  Число смайлов на страницу
$config['submail'] = $con_data[56];                 #  Число отправки писем рассылки в пакете
$config['doslimit'] = $con_data[57];                #  Максимальное кол. обращений с одного ip в минуту
$config['maxlogdat'] = $con_data[58];               #  Сохраняется информации в лог-файле
$config['resmiles'] = $con_data[59];                #  Число смайлов в сообщении
$config['showref'] = $con_data[60];                 #  На страницу в кто -откуда
$config['gzip'] = $con_data[69];                    #  Включено сжатие страниц GZIP или выключено
$config['autoskins'] = $con_data[87];               #  Выпадающий список скинов/тем
$config['nocheck'] = $con_data[88];                 #  Расширения которые не нужно сканировать
$config['includenick'] = $con_data[89];             #  Разрешить русские ники
$config['maxpostsub'] = $con_data[99];              #  Количество подписчиков рассылки на страницу
$config['headlines'] = $con_data[100];              #  Количество вывода заголовков на страницу
$config['protectimg'] = $con_data[103];             #  Включить защитную картинку с кодом
$config['protectdef'] = $con_data[104];             #  Деформация защитной картинки
$config['themesforumcache'] = $con_data[108];       #  Кеширование популярных тем Дневника
$config['avlist'] = $con_data[116];                 #  Количество аватаров на страницу
$config['editfiles'] = $con_data[117];              #  Количество файлов в редакторе админки
$config['closedsite'] = $con_data[118];             #  Закрыть сайт по техническим причинам
$config['loglist'] = $con_data[127];                #  Просмотр логов на страницу
$config['incount'] = $con_data[74];                 #  Вид счетчика (Хосты,хиты,всего или графика)

} else {echo'<b>Ошибка! Не установлены настройки сайта!</b>'; exit;}

//------------------- Технические настройки --------------------//
$config['userprofkey'] = 100;                       #  Количество ячеек в профиле
$config['configkeys'] = 140;                        #  Всего ячеек в настройках

define('SITETIME', time() + $config['timeclocks'] * 3600); // Установка временного сдвига сайта
?>
