<?php

declare(strict_types=1);

use DI\ContainerBuilder;

$containerBuilder = new ContainerBuilder();

// Set up settings
$settings = require __DIR__ . '/settings.php';
$settings($containerBuilder);

// Set up dependencies
$dependencies = require __DIR__ . '/dependencies.php';
$dependencies($containerBuilder);

// Set up repositories
$repositories = require __DIR__ . '/repositories.php';
$repositories($containerBuilder);

/*if (false) { // Should be set to true in production
    $containerBuilder->enableCompilation(__DIR__ . '/../storage/cache');
}*/

// Build PHP-DI Container instance
return $containerBuilder->build();
