var home, work, homeButton, workButton;

// Dean Edwards/Matthias Miller/John Resig

function init() {
  // quit if this function has already been called
  if (arguments.callee.done) return;

  // flag this function so we don't do the same thing twice
  arguments.callee.done = true;

  // kill the timer
  if (_timer) clearInterval(_timer);

  // do stuff
	home = document.getElementById("home");
	work = document.getElementById("work");
	var toggle = document.getElementById("toggle");
	homeButton = toggle.childNodes[2].childNodes[0];
	workButton = toggle.childNodes[1].childNodes[0];
	homeButton.onclick = showHome;
	workButton.onclick = showWork;
	if(document.location.hash == "#work") showWork();
	else showHome();
};

/* for Mozilla/Opera9 */
if (document.addEventListener) {
  document.addEventListener("DOMContentLoaded", init, false);
}

/* for Internet Explorer */
/*@cc_on @*/
/*@if (@_win32)
  document.write("<script id=__ie_onload defer src=javascript:void(0)><\/script>");
  var script = document.getElementById("__ie_onload");
  script.onreadystatechange = function() {
    if (this.readyState == "complete") {
      init(); // call the onload handler
    }
  };
/*@end @

/* for Safari */
if (/WebKit/i.test(navigator.userAgent)) { // sniff
  var _timer = setInterval(function() {
    if (/loaded|complete/.test(document.readyState)) {
      init(); // call the onload handler
    }
  }, 10);
}

/* for other browsers */
window.onload = init;

function showHome()
{
	home.style.display = "block";
	work.style.display = "none";
	homeButton.parentNode.id = "active";
	workButton.parentNode.id = "";
}

function showWork()
{
	work.style.display = "block";
	home.style.display = "none";
	workButton.parentNode.id = "active";
	homeButton.parentNode.id = "";
}
