<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Поиск музыки</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            width: 80%;
            margin: 0 auto;
            padding: 20px;
        }
        .search-box {
            margin: 20px 0;
            text-align: center;
        }
        .search-box input {
            padding: 10px;
            font-size: 16px;
            width: 60%;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .search-box button {
            padding: 10px 15px;
            font-size: 16px;
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 5px;
        }
        .search-box button:hover {
            background-color: #45a049;
        }
        .track-list {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-around;
        }
        .track-item {
            background-color: white;
            padding: 15px;
            margin: 10px;
            width: 200px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .track-item img {
            width: 100%;
            height: auto;
            border-radius: 5px;
        }
        .track-item h4 {
            font-size: 18px;
            margin: 10px 0;
        }
        .track-item p {
            font-size: 14px;
            color: #555;
        }
        .track-item a {
            text-decoration: none;
            color: #4CAF50;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="search-box">
            <h1>Поиск музыки</h1>
            <form action="search.php" method="get">
                <input type="text" name="q" placeholder="Введите название трека или исполнителя" required>
                <button type="submit">Искать</button>
            </form>
        </div>
    </div>
</body>
</html>