<?php
/*
// Проверка наличия параметра для скачивания
if (isset($_GET['download'])) {
    $fileUrl = urldecode(base64_decode($_GET['download']));  // Ссылка на файл для скачивания
    $filename = basename($fileUrl);  // Имя файла (можно изменить, если нужно)
    sendFileThroughProxy($fileUrl, $filename);  // Вызов функции для отдачи файла
    exit;
}

// Проверяем, что поисковый запрос был отправлен
if (isset($_GET['q']) && !empty($_GET['q'])) {
    $query = urlencode($_GET['q']); // Кодируем поисковый запрос
    $url = 'https://rus.hitmotop.com/search?q=' . $query; // Формируем URL для поиска

	function getPageContent($url) {
    $ch = curl_init();
    
    // Подменяем User-Agent на браузерный (например, Chrome)
    $userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36';
    
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Отключаем SSL-проверку (если необходимо)
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3');
    curl_setopt($ch, CURLOPT_REFERER, 'https://rus.hitmotop.com');
    
    // Устанавливаем заголовок User-Agent
    curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);
    
    $content = curl_exec($ch);
    
    // Проверка на ошибки при выполнении запроса
    if(curl_errno($ch)) {
        echo 'Ошибка cURL: ' . curl_error($ch);
        curl_close($ch);
        return false;
    }
    
    curl_close($ch);
    return $content;
}


    // Получаем HTML-контент страницы
    $html = getPageContent($url);

    // Проверяем, что контент был успешно получен
    if ($html === false) {
        die('Ошибка при загрузке страницы.');
    }

    // Загружаем HTML в DOMDocument
    $dom = new DOMDocument();
    libxml_use_internal_errors(true); // Игнорируем ошибки при парсинге (если HTML не идеально валиден)
    $dom->loadHTML($html);
    libxml_clear_errors();

    // Создаем объект DOMXPath для поиска элементов
    $xpath = new DOMXPath($dom);

    // Находим все элементы <li> с классом "tracks__item"
    $nodes = $xpath->query('//li[contains(@class, "tracks__item")]');

    // Массив для хранения информации о треках
    $tracks = [];

    // Проходим по всем найденным элементам
	// Инициализируем счетчик для ограничения вывода до 5 элементов
$counter = 0;
$maxTracks = 5; // Максимальное количество треков

// Проходим по всем найденным элементам
foreach ($nodes as $node) {
    // Если количество треков достигло максимума, выходим из цикла
    if ($counter >= $maxTracks) {
        break;
    }

    // Получаем атрибут data-musmeta
    $musmetaJson = $node->getAttribute('data-musmeta');
    $musmeta = json_decode($musmetaJson, true); // Декодируем JSON

    // Извлекаем данные для трека
    $track = [
        'artist' => $musmeta['artist'] ?? 'Неизвестно',
        'title' => $musmeta['title'] ?? 'Неизвестно',
        'img' => $musmeta['img'] ?? '',
        'url' => $musmeta['url'] ?? '',
        'time' => '', // Время будет извлечено отдельно
    ];

    // Извлекаем время из дочернего элемента
    $timeNode = $xpath->query('.//div[contains(@class, "track__fulltime")]', $node);
    if ($timeNode->length > 0) {
        $track['time'] = trim($timeNode->item(0)->nodeValue);
    }

    // Добавляем трек в массив
    $tracks[] = $track;

    // Увеличиваем счетчик
    $counter++;
}
}

function sendFileThroughProxy($fileUrl, $filename) {
    // Инициализация cURL для скачивания файла
    $ch = curl_init($fileUrl);

    // Устанавливаем опции cURL
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3');
    curl_setopt($ch, CURLOPT_REFERER, 'https://rus.hitmotop.com');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*{/*};q=0.8',
        'Accept-Language: en-US,en;q=0.5'
    ]);

    // Получаем файл
    $fileData = curl_exec($ch);

    // Проверка на ошибки
    if(curl_errno($ch)) {
        echo 'Ошибка cURL: ' . curl_error($ch);
        curl_close($ch);
        return;
    }

    // Закрываем cURL
    curl_close($ch);

    // Проверяем, что файл был успешно получен
    if ($fileData === false) {
        echo 'Ошибка при скачивании файла.';
        return;
    }

    // Устанавливаем заголовки для скачивания файла
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Content-Length: ' . strlen($fileData));

    // Отдаем файл
    echo $fileData;
    exit;
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Результаты поиска</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            width: 80%;
            margin: 0 auto;
            padding: 20px;
        }
        .search-box {
            text-align: center;
            margin-bottom: 20px;
        }
        .track-list {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-around;
        }
        .track-item {
            background-color: white;
            padding: 15px;
            margin: 10px;
            width: 220px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .track-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
        }
        .track-item img {
            width: 100%;
            height: auto;
            border-radius: 5px;
            margin-bottom: 10px;
        }
        .track-item h4 {
            font-size: 18px;
            margin: 10px 0;
            color: #333;
        }
        .track-item p {
            font-size: 14px;
            color: #555;
            margin: 5px 0;
        }
        .track-item a {
            display: inline-block;
            padding: 8px 15px;
            margin: 5px 0;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            text-align: center;
            transition: background-color 0.3s ease;
        }
        .track-item a:hover {
            background-color: #45a049;
        }
        audio {
            width: 100%;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="search-box">
            <a href="index.php">Назад к поиску</a>
            <h1>Результаты поиска для "<?php echo htmlspecialchars($_GET['q']); ?>"</h1>
        </div>

        <div class="track-list">
            <?php if (!empty($tracks)): ?>
                <?php foreach ($tracks as $track): ?>
                    <div class="track-item">
                        <img src="<?php echo '?download='.base64_encode(urlencode($track['img'])); ?>" alt="Cover">
                        <h4><?php echo htmlspecialchars($track['title']); ?></h4>
                        <p>Исполнитель: <?php echo htmlspecialchars($track['artist']); ?></p>
                        <p>Время: <?php echo htmlspecialchars($track['time']); ?></p>
                        <a href="<?php echo '?download='.base64_encode(urlencode($track['url'])); ?>" target="_blank">Скачать</a>
                        <audio controls>
                            <source src="<?php echo '?download='.base64_encode(urlencode($track['url'])); ?>" type="audio/mp3">
                            Ваш браузер не поддерживает элемент audio.
                        </audio>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p>Нет результатов для вашего запроса.</p>
            <?php endif; ?>
        </div>
		
		<div class="search-box">
            <h1>Все найденные файлы выложены в сети интернет и имеют свободный доступ к ним. Данный сайт не хранит файлы!</h1>
        </div>
    </div>
</body>
</html>
*/

function getPageContent($url) {
    $ch = curl_init();
    $userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36';
    
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);
    curl_setopt($ch, CURLOPT_REFERER, 'https://rus.hitmotop.com');
    
    $content = curl_exec($ch);
    
    if(curl_errno($ch)) {
        error_log('Ошибка cURL: ' . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    curl_close($ch);
    return $content;
}

function sendFileThroughProxy($fileUrl, $filename) {
    $allowedDomains = ['rus.hitmotop.com'];
    $parsedUrl = parse_url($fileUrl);
    if (!in_array($parsedUrl['host'], $allowedDomains)) {
        die('Недопустимый домен.');
    }

    $ch = curl_init($fileUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3');
    curl_setopt($ch, CURLOPT_REFERER, 'https://rus.hitmotop.com');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        'Accept-Language: en-US,en;q=0.5'
    ]);

    $fileData = curl_exec($ch);

    if(curl_errno($ch)) {
        error_log('Ошибка cURL: ' . curl_error($ch));
        curl_close($ch);
        return;
    }

    curl_close($ch);

    if ($fileData === false) {
        die('Ошибка при скачивании файла.');
    }

    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mimeType = $finfo->buffer($fileData);
    if (!in_array($mimeType, ['audio/mpeg', 'audio/mp3'])) {
        die('Недопустимый тип файла.');
    }

    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Content-Length: ' . strlen($fileData));

    echo $fileData;
    exit;
}

if (isset($_GET['download'])) {
    $fileUrl = urldecode(base64_decode($_GET['download']));
    $filename = basename($fileUrl);
    sendFileThroughProxy($fileUrl, $filename);
    exit;
}

if (isset($_GET['q']) && !empty($_GET['q'])) {
    $query = urlencode($_GET['q']);
    $url = 'https://rus.hitmotop.com/search?q=' . $query;

    $html = getPageContent($url);

    if ($html === false) {
        die('Ошибка при загрузке страницы.');
    }

    $dom = new DOMDocument();
    libxml_use_internal_errors(true);
    $dom->loadHTML($html);
    libxml_clear_errors();

    $xpath = new DOMXPath($dom);
    $nodes = $xpath->query('//li[contains(@class, "tracks__item")]');

    $tracks = [];
    $counter = 0;
    $maxTracks = 5;

    foreach ($nodes as $node) {
        if ($counter >= $maxTracks) {
            break;
        }

        $musmetaJson = $node->getAttribute('data-musmeta');
        $musmeta = json_decode($musmetaJson, true);

        $track = [
            'artist' => $musmeta['artist'] ?? 'Неизвестно',
            'title' => $musmeta['title'] ?? 'Неизвестно',
            'img' => $musmeta['img'] ?? '',
            'url' => $musmeta['url'] ?? '',
            'time' => '',
        ];

        $timeNode = $xpath->query('.//div[contains(@class, "track__fulltime")]', $node);
        if ($timeNode->length > 0) {
            $track['time'] = trim($timeNode->item(0)->nodeValue);
        }

        $tracks[] = $track;
        $counter++;
    }
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Результаты поиска</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            width: 80%;
            margin: 0 auto;
            padding: 20px;
        }
        .search-box {
            text-align: center;
            margin-bottom: 20px;
        }
        .track-list {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-around;
        }
        .track-item {
            background-color: white;
            padding: 15px;
            margin: 10px;
            width: 220px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .track-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
        }
        .track-item img {
            width: 100%;
            height: auto;
            border-radius: 5px;
            margin-bottom: 10px;
        }
        .track-item h4 {
            font-size: 18px;
            margin: 10px 0;
            color: #333;
        }
        .track-item p {
            font-size: 14px;
            color: #555;
            margin: 5px 0;
        }
        .track-item a {
            display: inline-block;
            padding: 8px 15px;
            margin: 5px 0;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            text-align: center;
            transition: background-color 0.3s ease;
        }
        .track-item a:hover {
            background-color: #45a049;
        }
        audio {
            width: 100%;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="search-box">
            <a href="index.php">Назад к поиску</a>
            <h1>Результаты поиска для "<?php echo htmlspecialchars($_GET['q']); ?>"</h1>
        </div>

        <div class="track-list">
            <?php if (!empty($tracks)): ?>
                <?php foreach ($tracks as $track): ?>
                    <div class="track-item">
                        <img src="<?php echo htmlspecialchars($track['img']); ?>" alt="Cover">
                        <h4><?php echo htmlspecialchars($track['title']); ?></h4>
                        <p>Исполнитель: <?php echo htmlspecialchars($track['artist']); ?></p>
                        <p>Время: <?php echo htmlspecialchars($track['time']); ?></p>
                        <a href="<?php echo htmlspecialchars('?download='.base64_encode(urlencode($track['url']))); ?>" target="_blank">Скачать</a>
                        <audio controls>
                            <source src="<?php echo htmlspecialchars('?download='.base64_encode(urlencode($track['url']))); ?>" type="audio/mp3">
                            Ваш браузер не поддерживает элемент audio.
                        </audio>
                    </div>
                <?php endforeach; ?>
				
				<div class="search-box">
					<h1>Все найденные файлы выложены в сети интернет и имеют свободный доступ к ним. Данный сайт не хранит файлы!</h1>
				</div>
            <?php else: ?>
                <p>Нет результатов для вашего запроса.</p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
