<?php
// Включение отображения ошибок для отладки (убрать на продакшене)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Проверка, была ли сессия уже запущена
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

// Проверка авторизации
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

global $pdo;
$user_id = $_SESSION['user_id'];
$target_user_id = isset($_GET['user_id']) && is_numeric($_GET['user_id']) ? (int)$_GET['user_id'] : null;

if (!$target_user_id) {
    header('Location: user_list.php');
    exit;
}

// Получаем данные собеседника
$stmt = $pdo->prepare("SELECT id, login, avatar FROM users WHERE id = ?");
$stmt->execute([$target_user_id]);
$target_user = $stmt->fetch();

if (!$target_user) {
    header('Location: user_list.php');
    exit;
}

// Обновляем статус всех непрочитанных сообщений от этого пользователя как прочитанные
$stmt = $pdo->prepare("UPDATE messages SET is_read = TRUE WHERE receiver_id = ? AND sender_id = ? AND is_read = FALSE");
$stmt->execute([$user_id, $target_user_id]);

// Получаем сообщения между текущим пользователем и собеседником
$stmt = $pdo->prepare("SELECT m.id, m.sender_id, m.message, m.created_at, m.is_read, u.login, u.avatar 
                       FROM messages m 
                       JOIN users u ON u.id = m.sender_id 
                       WHERE (m.sender_id = ? AND m.receiver_id = ?) 
                       OR (m.sender_id = ? AND m.receiver_id = ?) 
                       ORDER BY m.created_at ASC");
$stmt->execute([$user_id, $target_user_id, $target_user_id, $user_id]);
$messages = $stmt->fetchAll();

// Обработка отправки нового сообщения
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['message'])) {
    $message = trim($_POST['message']);
    if (!empty($message)) {
        $stmt = $pdo->prepare("INSERT INTO messages (sender_id, receiver_id, message, created_at, is_read) VALUES (?, ?, ?, NOW(), FALSE)");
        $stmt->execute([$user_id, $target_user_id, $message]);
    }
    header('Location: chat.php?user_id=' . $target_user_id);
    exit;
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="assets/css/style.css">
    <title>Чат с <?php echo htmlspecialchars($target_user['login']); ?> — AstralForge</title>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <?php if (isset($_SESSION['user_id'])): ?>
                <div class="navbar-user">
                    <a href="profile.php" class="navbar-avatar-link">
                        <?php 
                        $current_user = $pdo->prepare("SELECT avatar, login FROM users WHERE id = ?");
                        $current_user->execute([$_SESSION['user_id']]);
                        $current_user_data = $current_user->fetch();
                        ?>
                        <?php if (empty($current_user_data['avatar'])): ?>
                            <span class="default-avatar navbar-avatar">?</span>
                        <?php else: ?>
                            <img src="<?php echo htmlspecialchars($current_user_data['avatar']); ?>" alt="Ваш аватар" class="navbar-avatar" onerror="this.replaceWith(document.createElement('span').classList.add('default-avatar', 'navbar-avatar').textContent='?');">
                        <?php endif; ?>
                    </a>
                    <a href="profile.php" class="navbar-username"><?php echo htmlspecialchars($current_user_data['login']); ?></a>
                </div>
                <div class="navbar-links">
                    <a href="index.php">Главная</a>
                    <a href="user_list.php">Пользователи</a>
                    <a href="messages.php">
                        <span class="message-icon"></span>
                    </a>
                    <?php if (isset($_SESSION['is_admin']) && $_SESSION['is_admin']) echo '<a href="admin/index.php">Админ-панель</a>'; ?>
                    <a href="logout.php">Выход</a>
                </div>
            <?php endif; ?>
        </div>
    </nav>

    <div class="container">
        <h1>Чат с <?php echo htmlspecialchars($target_user['login']); ?></h1>
        <div class="chat-container">
            <div class="chat-messages">
                <?php foreach ($messages as $message): ?>
                    <div class="message <?php echo $message['sender_id'] === $user_id ? 'message-sent' : 'message-received'; ?>">
                        <?php if ($message['sender_id'] !== $user_id): ?>
                            <?php if (empty($message['avatar'])): ?>
                                <span class="default-avatar message-avatar">?</span>
                            <?php else: ?>
                                <img src="<?php echo htmlspecialchars($message['avatar']); ?>" alt="<?php echo htmlspecialchars($message['login']); ?>" class="message-avatar" onerror="this.replaceWith(document.createElement('span').classList.add('default-avatar', 'message-avatar').textContent='?');">
                            <?php endif; ?>
                        <?php endif; ?>
                        <div class="message-content">
                            <p class="message-text"><?php echo htmlspecialchars($message['message']); ?></p>
                            <p class="message-time"><?php echo htmlspecialchars(date('H:i d.m.Y', strtotime($message['created_at']))); ?>
                            <?php if ($message['sender_id'] !== $user_id && !$message['is_read']): ?>
                                <span class="message-unread">Новое</span>
                            <?php endif; ?>
                            </p>
                        </div>
                        <?php if ($message['sender_id'] === $user_id): ?>
                            <?php if (empty($current_user_data['avatar'])): ?>
                                <span class="default-avatar message-avatar">?</span>
                            <?php else: ?>
                                <img src="<?php echo htmlspecialchars($current_user_data['avatar']); ?>" alt="<?php echo htmlspecialchars($current_user_data['login']); ?>" class="message-avatar" onerror="this.replaceWith(document.createElement('span').classList.add('default-avatar', 'message-avatar').textContent='?');">
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
            <form method="POST" action="chat.php?user_id=<?php echo htmlspecialchars($target_user_id); ?>" class="chat-form">
                <textarea name="message" placeholder="Введите сообщение..." required></textarea>
                <button type="submit">Отправить</button>
            </form>
        </div>
    </div>
</body>
</html>