<?php
// Включение отображения ошибок для отладки (убрать на продакшене)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Проверка, была ли сессия уже запущена
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

// Проверка авторизации
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

global $pdo;
$user_id = $_SESSION['user_id'];

// Параметры пагинации
$per_page = 20; // Максимум 20 пользователей на страницу
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $per_page;

// Получаем параметр поиска из GET
$search_query = isset($_GET['search']) ? trim($_GET['search']) : '';

// Подготавливаем SQL-запрос для получения общего количества пользователей
$count_sql = "SELECT COUNT(*) FROM users WHERE id != ? AND login LIKE ?";
$count_stmt = $pdo->prepare($count_sql);
$count_stmt->execute([$user_id, "%" . $search_query . "%"]);
$total_users = $count_stmt->fetchColumn();
$total_pages = ceil($total_users / $per_page);

// Подготавливаем SQL-запрос для получения пользователей с пагинацией
$sql = "SELECT id, login, avatar FROM users WHERE id != ? AND login LIKE ? LIMIT ? OFFSET ?";
$stmt = $pdo->prepare($sql);
$search_like = "%" . $search_query . "%";
$stmt->execute([$user_id, $search_like, $per_page, $offset]);
$users = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="assets/css/style.css">
    <title>Список пользователей — AstralForge</title>
    <style>
        .user-avatar, .default-avatar {
            width: 25px;
            height: 25px;
            object-fit: cover;
            border-radius: 50%;
            border: 2px solid #fff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);
        }

        .user-avatar:hover, .default-avatar:hover {
            transform: scale(1.1);
        }

        .default-avatar {
            background: linear-gradient(45deg, #ecf0f1, #bdc3c7);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
            color: #666;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <?php if (isset($_SESSION['user_id'])): ?>
                <div class="navbar-user">
                    <a href="profile.php" class="navbar-avatar-link">
                        <?php 
                        $current_user = $pdo->prepare("SELECT avatar, login FROM users WHERE id = ?");
                        $current_user->execute([$_SESSION['user_id']]);
                        $current_user_data = $current_user->fetch();
                        ?>
                        <?php if (empty($current_user_data['avatar'])): ?>
                            <span class="default-avatar navbar-avatar">?</span>
                        <?php else: ?>
                            <img src="<?php echo htmlspecialchars($current_user_data['avatar']); ?>" alt="Ваш аватар" class="navbar-avatar" onerror="this.replaceWith(document.createElement('span').classList.add('default-avatar', 'navbar-avatar').textContent='?');">
                        <?php endif; ?>
                    </a>
                    <a href="profile.php" class="navbar-username"><?php echo htmlspecialchars($current_user_data['login']); ?></a>
                </div>
                <div class="navbar-links">
                    <a href="index.php">Главная</a>
                    <a href="messages.php">
                        <span class="message-icon"></span>
                    </a>
                    <?php if (isset($_SESSION['is_admin']) && $_SESSION['is_admin']) echo '<a href="admin/index.php">Админ-панель</a>'; ?>
                    <a href="logout.php">Выход</a>
                </div>
            <?php endif; ?>
        </div>
    </nav>

    <div class="container">
        <h1>Список пользователей</h1>
        <div class="search-container">
            <form method="GET" action="user_list.php" class="search-form">
                <input type="text" name="search" placeholder="Поиск по логину..." class="search-input" value="<?php echo htmlspecialchars($search_query); ?>">
                <button type="submit" class="search-button">Поиск</button>
            </form>
            <?php if ($search_query): ?>
                <p class="search-results">Результаты поиска для: "<?php echo htmlspecialchars($search_query); ?>"</p>
            <?php endif; ?>
        </div>
        <div class="users-list vertical">
            <?php if (count($users) > 0): ?>
                <?php foreach ($users as $user): ?>
                    <div class="user-card">
                        <a href="user_profile.php?id=<?php echo htmlspecialchars($user['id']); ?>" class="user-link">
                            <?php if (empty($user['avatar'])): ?>
                                <span class="default-avatar">?</span>
                            <?php else: ?>
                                <img src="<?php echo htmlspecialchars($user['avatar']); ?>" alt="<?php echo htmlspecialchars($user['login']); ?>" class="user-avatar" onerror="this.replaceWith(document.createElement('span').classList.add('default-avatar').textContent='?');">
                            <?php endif; ?>
                            <p><?php echo htmlspecialchars($user['login']); ?></p>
                        </a>
                        <a href="chat.php?user_id=<?php echo htmlspecialchars($user['id']); ?>">
                            <span class="user-message-icon"></span>
                        </a>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="no-results">Пользователи не найдены.</p>
            <?php endif; ?>
        </div>
        <?php if ($total_pages > 1): ?>
            <div class="pagination">
                <?php if ($page > 1): ?>
                    <a href="?page=<?php echo $page - 1; ?><?php echo $search_query ? '&search=' . urlencode($search_query) : ''; ?>" class="pagination-button">Предыдущая</a>
                <?php endif; ?>
                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <a href="?page=<?php echo $i; ?><?php echo $search_query ? '&search=' . urlencode($search_query) : ''; ?>" class="pagination-number<?php echo $i === $page ? ' active' : ''; ?>">
                        <?php echo $i; ?>
                    </a>
                <?php endfor; ?>
                <?php if ($page < $total_pages): ?>
                    <a href="?page=<?php echo $page + 1; ?><?php echo $search_query ? '&search=' . urlencode($search_query) : ''; ?>" class="pagination-button">Следующая</a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>