<?php
// Включение отображения ошибок для отладки (убрать на продакшене)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Проверка, была ли сессия уже запущена
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

// Проверка авторизации
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

global $pdo;
$user_id = $_SESSION['user_id'];

// Получаем ID профиля из GET-параметра
$profile_user_id = isset($_GET['id']) && is_numeric($_GET['id']) ? (int)$_GET['id'] : null;

if (!$profile_user_id) {
    die("Профиль не найден.");
}

// Получаем данные пользователя для профиля (все поля, кроме password)
$stmt = $pdo->prepare("SELECT id, login, avatar, name, city, website, about FROM users WHERE id = ?");
$stmt->execute([$profile_user_id]);
$profile_user = $stmt->fetch();

// Отладка: Выводим данные для проверки (убрать на продакшене)
error_log("Данные профиля для user_id = $profile_user_id: " . print_r($profile_user, true));

if (!$profile_user) {
    die("Профиль не найден.");
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="assets/css/style.css">
    <title>Профиль <?php echo htmlspecialchars($profile_user['login']); ?> — AstralForge</title>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <?php if (isset($_SESSION['user_id'])): ?>
                <div class="navbar-user">
                    <a href="profile.php" class="navbar-avatar-link">
                        <?php 
                        $current_user = $pdo->prepare("SELECT avatar, login FROM users WHERE id = ?");
                        $current_user->execute([$_SESSION['user_id']]);
                        $current_user_data = $current_user->fetch();
                        ?>
                        <?php if (empty($current_user_data['avatar'])): ?>
                            <span class="default-avatar navbar-avatar">?</span>
                        <?php else: ?>
                            <img src="<?php echo htmlspecialchars($current_user_data['avatar']); ?>" alt="Ваш аватар" class="navbar-avatar" onerror="this.replaceWith(document.createElement('span').classList.add('default-avatar', 'navbar-avatar').textContent='?');">
                        <?php endif; ?>
                    </a>
                    <a href="profile.php" class="navbar-username"><?php echo htmlspecialchars($current_user_data['login']); ?></a>
                </div>
                <div class="navbar-links">
                    <a href="index.php">Главная</a>
                    <a href="user_list.php">Список пользователей</a>
                    <a href="messages.php">
                        <span class="message-icon"></span>
                    </a>
                    <?php if (isset($_SESSION['is_admin']) && $_SESSION['is_admin']) echo '<a href="admin/index.php">Админ-панель</a>'; ?>
                    <a href="logout.php">Выход</a>
                </div>
            <?php endif; ?>
        </div>
    </nav>

    <div class="container">
        <h1 class="profile-title">Профиль <?php echo htmlspecialchars($profile_user['login']); ?></h1>
        <div class="profile-section">
            <div class="profile-header">
                <?php if (empty($profile_user['avatar'])): ?>
                    <span class="default-avatar user-avatar" style="width: 150px; height: 150px;">?</span>
                <?php else: ?>
                    <img src="<?php echo htmlspecialchars($profile_user['avatar']); ?>" alt="<?php echo htmlspecialchars($profile_user['login']); ?>" class="user-avatar" style="width: 150px; height: 150px;" onerror="this.replaceWith(document.createElement('span').classList.add('default-avatar', 'user-avatar').textContent='?');">
                <?php endif; ?>

                <?php if ($user_id !== $profile_user_id): ?>
                    <a href="chat.php?user_id=<?php echo htmlspecialchars($profile_user_id); ?>" class="chat-button">Начать переписку</a>
                <?php endif; ?>
            </div>
            <div class="profile-info">
                <div class="profile-details">
                    <label class="info-label">Логин:</label>
                    <p class="info-value"><?php echo htmlspecialchars($profile_user['login']); ?></p>
                    <?php if (!empty($profile_user['name'])): ?>
                        <label class="info-label">Имя:</label>
                        <p class="info-value"><?php echo htmlspecialchars($profile_user['name']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($profile_user['city'])): ?>
                        <label class="info-label">Город:</label>
                        <p class="info-value"><?php echo htmlspecialchars($profile_user['city']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($profile_user['website'])): ?>
                        <label class="info-label">Веб-сайт:</label>
                        <p class="info-value"><a href="<?php echo htmlspecialchars($profile_user['website']); ?>" target="_blank" class="info-link"><?php echo htmlspecialchars($profile_user['website']); ?></a></p>
                    <?php endif; ?>
                    <?php if (!empty($profile_user['about'])): ?>
                        <label class="info-label">О себе:</label>
                        <p class="info-value info-about"><?php echo htmlspecialchars($profile_user['about']); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <a href="user_list.php" class="back-link">Назад к списку пользователей</a>
    </div>
</body>
</html>