<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class CreateCounters31Table extends Migration
{
    /**
     * Migrate Up.
     */
    public function up(): void
    {
        if (! Schema::hasTable('counters31')) {
            Schema::create('counters31', function (Blueprint $table) {
                $table->increments('id');
                $table->dateTime('period');
                $table->integer('hosts');
                $table->integer('hits');

                $table->unique('period');
            });
        }
    }

    /**
     * Migrate Down.
     */
    public function down(): void
    {
        Schema::dropIfExists('counters31');
    }
}
