<?php

namespace App\Http\Middleware;

use App\Models\Log;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminLogger
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        return $next($request);
    }

    /**
     * Handle tasks after the response has been sent to the browser.
     */
    public function terminate(Request $request, Response $response): void
    {
        $user = getUser();

        if ($user) {
            Log::query()->create([
                'user_id'    => $user->id,
                'request'    => utfSubstr($request->getRequestUri(), 0, 250),
                'referer'    => utfSubstr($request->header('referer'), 0, 250),
                'ip'         => getIp(),
                'brow'       => getBrowser(),
                'created_at' => SITETIME,
            ]);
        }
    }
}
