<?php
/*
 ┌───────────────────────────────────────────────────────────┐
 │                          ATTENTION                        │
 ├───────────────────────────────────────────────────────────┤
 │                                                           │
 │ This file is automatically generated.                     │
 │ All changes made will be lost when updating the library.  │
 │                                                           │
 │                                                           │
 ├───────────────────────────────────────────────────────────┤
 │                          ВНИМАНИЕ                         │
 ├───────────────────────────────────────────────────────────┤
 │                                                           │
 │ Этот файл сгенерирован автоматически.                     │
 │ Все внесённые изменения будут потеряны при обновлении.    │
 │                                                           │
 │                                                           │
 └───────────────────────────────────────────────────────────┘
 */

declare(strict_types=1);

namespace App\Commands\Migration;

use Hleb\Base\Task;
use Hleb\Static\DB;
use Hleb\Static\Settings;
use Phphleb\Migration\Src\MigrateException;
use Phphleb\Migration\Src\Migration;

class Create extends Task
{
    /**
     * Create a new migration.
     *
     * Создание новой миграции.
     *
     * @param string $name
     * @return int
     */
    protected function run(string $name): int
    {
        try {
            $dir = Settings::getPath('@global/migrations');
            $file = (new Migration(DB::getNewInstance(), 'migrations', $dir, true))->create($name);
        } catch (MigrateException $e) {
            echo PHP_EOL . 'ERROR: ' . $e->getMessage() . PHP_EOL;

            return self::ERROR_CODE;
        }
        echo PHP_EOL . $file . PHP_EOL;

        return self::SUCCESS_CODE;
    }
}
