<?php
/*
 ┌───────────────────────────────────────────────────────────┐
 │                          ATTENTION                        │
 ├───────────────────────────────────────────────────────────┤
 │                                                           │
 │ This file is automatically generated.                     │
 │ All changes made will be lost when updating the library.  │
 │                                                           │
 │                                                           │
 ├───────────────────────────────────────────────────────────┤
 │                          ВНИМАНИЕ                         │
 ├───────────────────────────────────────────────────────────┤
 │                                                           │
 │ Этот файл сгенерирован автоматически.                     │
 │ Все внесённые изменения будут потеряны при обновлении.    │
 │                                                           │
 │                                                           │
 └───────────────────────────────────────────────────────────┘
 */

declare(strict_types=1);

namespace App\Commands\Migration;

use Hleb\Base\Task;
use Hleb\Static\DB;
use Hleb\Static\Settings;
use Phphleb\Migration\Src\MigrateException;
use Phphleb\Migration\Src\Migration;
use Throwable;

class Rollback extends Task
{
    /**
     * Undo migrations.
     *
     * Откат миграций.
     *
     * @param string|int $steps - how many steps to roll back.
     *                          - на какое количество шагов сделать откат.
     *
     * @param string|null $notify - the --no-notify value disables notifications.
     *                            - значение --no-notify отключает оповещения.
     * @return int
     * @throws Throwable
     */
    protected function run(string|int $steps = 1, ?string $notify = null): int
    {
        if ($notify !== null && $notify !== '--no-notify') {
            throw new MigrateException('The value may be absent or match --no-notify');
        }
        if ($steps === 'all') {
            $steps = 0;
        } else {
            $steps = (int)$steps;
            if ($steps < 1) {
                throw new \ErrorException('Argument cannot be less than one!');
            }
        }

        try {
            $migrations = (new Migration(
                DB::getNewInstance(),
                'migrations',
                Settings::getPath('@global/migrations'),
                $notify === null,
            ))->rollback($steps);
            if ($migrations) {
                echo PHP_EOL . ' |◄ ' . implode(PHP_EOL . ' |◄ ', $migrations) . PHP_EOL;
            }
        } catch (MigrateException $e) {
            echo PHP_EOL . 'ERROR: ' . $e->getMessage() . PHP_EOL;

            return self::ERROR_CODE;
        }
        return self::SUCCESS_CODE;
    }
}
