<?php if (!empty($data['comments'])) : ?>
  <div class="box">
    <h2 class="lowercase text-2xl">
      <?= Html::numWord($item['post_comments_count'], __('app.num_comment'), true); ?>
    </h2>

    <?php
    function internalRender($container, $nodes, $item, $level = 0, $type = 'comment')
    {
      foreach ($nodes as  $node) :
        $level =  $level > 1 ? 1 : $level;
        $indent =  $level == 0 ? '0_0' : $level;
    ?>

        <?php if ($node['comment_is_deleted'] == 1 && !$container->user()->admin()) continue; ?>
        <?php if ($node['comment_published'] == 0 && $node['comment_user_id'] != $container->user()->id() && !$container->user()->admin()) continue; ?>

        <div class="block-comment<?php if ($node['comment_is_deleted'] == 1) : ?> m5 bg-red-200<?php endif; ?>">

          <?php if ($node['comment_lo']) : ?>
            <div title="<?= __('app.best_answer'); ?>" class="red right text-2xl p5">✓</div>
          <?php endif; ?>

          <ol class="list-none">
            <li class="comment">
              <a class="anchor-top" id="comment_<?= $node['comment_id']; ?>"></a>
              <div class="comment comment-body comment_level-left-<?= $indent; ?>" id="comment_<?= $node['comment_id']; ?>">

                <div class="user-info mb10">
                  <a href="<?= url('profile', ['login' => $node['login']]); ?>">
                    <?= Img::avatar($node['avatar'], $node['login'], 'img-sm mr5', 'small'); ?>
                    <span class="nickname<?php if (Html::loginColor($node['created_at'])) : ?> new<?php endif; ?>">
                      <?= $node['login']; ?>
                    </span>
                  </a>
                  <span class="lowercase"><?= langDate($node['comment_date']); ?></span>
                  <?php if ($node['comment_published'] == 0 && $container->user()->admin()) : ?>
                    <span class="ml15 red lowercase"><?= __('app.audits'); ?></span>
                  <?php endif; ?>

                  <?= insert('/content/comments/menu', ['item' => $item, 'comment' => $node, 'type' => 'qa', 'level' => $indent]); ?>

                </div>
                <div class="comment-text<?php if ($level == 1) : ?> text-sm<?php endif; ?>">
                  <?= markdown($node['comment_content'], 'text'); ?>
                </div>
                <div class="comment-footer justify-between">
                  <div class="flex gap">
                    <?php if ($type != 'qa') : ?>
                      <?= Html::votes($node, 'comment'); ?>
                    <?php endif; ?>

                    <?php if ($container->access()->limitTl(config('trust-levels', 'tl_add_comm_qa'))) : ?>
                      <?php if ($item['post_closed'] == 0 ?? $item['post_is_deleted'] == 0 || $container->user()->admin()) : ?>
                        <a data-id="<?= $node['comment_id']; ?>" data-type="addcomment" class="activ-form gray-600"><?= __('app.reply'); ?></a>
                      <?php endif; ?>
                    <?php endif; ?>
                  </div>
                </div>
                <?php if ($indent == '0_0') : ?><div class="mt5 mb5 br-bottom"></div><?php endif; ?>
                <?php if ($level == 1) : ?><div class="br-dotted"></div><?php endif; ?>

                <div id="el_addentry<?= $node['comment_id']; ?>" class="none"></div>
              </div>
            </li>
          </ol>
        </div>

        <?php if (isset($node['children'])) {
          internalRender($container, $node['children'], $item, $level + 1, 'qa');
        } ?>

    <?php endforeach;
    }
    echo internalRender($container, $data['comments'], $item);
    ?>

  </div>
<?php else : ?>
  <?php if ($item['post_closed'] != 1) : ?>
    <?= insert('/_block/no-content', ['type' => 'small', 'text' => __('app.no_comments'), 'icon' => 'info']); ?>
  <?php endif; ?>
<?php endif; ?>

<?php if ($data['is_answer']) : ?>
  <?= insert('/_block/no-content', ['type' => 'small', 'text' => __('app.you_answered'), 'icon' => 'info']); ?>
<?php else : ?>
  <?php if ($container->user()->active()) : ?>
    <?php if ($item['post_type'] == 'question' && $item['post_draft'] == 0 && $item['post_closed'] == 0) : ?>

      <form class="mb15 mt20" action="<?= url('add.comment', method: 'post'); ?>" accept-charset="UTF-8" method="post">
        <?= $container->csrf()->field(); ?>
        <?= insert('/_block/form/editor/notoolbar-img', [
          'height'  => '170px',
          'id'      => $item['post_id'],
          'type'    => 'comment',
        ]); ?>

        <div class="clear mt5">
          <input type="hidden" name="post_id" value="<?= $item['post_id']; ?>">
          <input type="hidden" name="comment_id" value="0">
          <?= Html::sumbit(__('app.reply')); ?>
        </div>
      </form>

    <?php endif; ?>
  <?php endif; ?>
<?php endif;  ?>

<?php if ($item['post_closed'] == 1) :
  echo insert('/_block/no-content', ['type' => 'small', 'text' => __('app.question_closed'), 'icon' => 'lock']);
endif; ?>