<?php

namespace Akh\Typograf\Tests\Rule\Punctuation;

use Akh\Typograf\Rule\AbstractRule;
use Akh\Typograf\Rule\Punctuation\Hellip;
use Akh\Typograf\Tests\Rule\RuleTestCase;

/**
 * @internal
 */
class HellipTest extends RuleTestCase
{
    public function getRule(): AbstractRule
    {
        return new Hellip();
    }

    /**
     * @return string[][]
     */
    public function dataProvider(): array
    {
        return [
            [
                "Дубровский молчал...\nДубровский молчал...",
                "Дубровский молчал&hellip;\nДубровский молчал&hellip;",
            ],
            [
                '<p>Дубровский молчал...</p>',
                '<p>Дубровский молчал&hellip;</p>',
            ],
            [
                'Дубровский молчал... Вдруг он поднял голову, глаза его засверкали, он топнул ногою, оттолкнул секретаря...',
                'Дубровский молчал&hellip; Вдруг он поднял голову, глаза его засверкали, он топнул ногою, оттолкнул секретаря&hellip;',
            ],
            [
                '...Ва... ва... ва... ваше превосходительство, — шептал Попов (А. К. Толстой).',
                '&hellip;Ва&hellip; ва&hellip; ва&hellip; ваше превосходительство, — шептал Попов (А. К. Толстой).',
            ],
            [
                'Маркс писал, что «язык... есть практическое, существующее и для других людей и лишь тем самым существующее также и для меня самого, действительное сознание».',
                'Маркс писал, что «язык&hellip; есть практическое, существующее и для других людей и лишь тем самым существующее также и для меня самого, действительное сознание».',
            ],
            [
                '..',
                '..',
            ],
            [
                '...',
                '&hellip;',
            ],
        ];
    }
}
