<?php

/*declare(strict_types=1);*/

namespace Hleb;

use Hleb\Constructor\Attributes\NotFinal;

/**
 * 400 error template.
 * This response means that the server does not understand the request due to invalid syntax.
 * (!) Returns the standard error formatting by the framework, to change the format
 * you need to create your own class inherited from Hleb\HttpException.
 *
 * Шаблон ошибки 400.
 * Этот ответ означает, что сервер не понимает запрос из-за неверного синтаксиса.
 * (!) Возвращает стандартное оформление ошибки фреймворком,для изменения формата
 * необходимо создать собственный класс, унаследованный от Hleb\HttpException.
 */
#[NotFinal]
class Http400BadRequestException extends HttpException
{
    #[NotFinal]
    public function __construct(string $message = 'Bad Request')
    {
        $this->initException(400, $message);

        parent::__construct($message);
    }
}
