 ## "Muller" is the strict Electronic Postman (PHP Mailer)

[![HLEB1](https://img.shields.io/badge/HLEB-1-olive)](https://github.com/phphleb/hleb) [![HLEB2](https://img.shields.io/badge/HLEB-2-darkcyan)](https://github.com/phphleb/hleb) ![PHP](https://img.shields.io/badge/PHP-7-blue) ![PHP](https://img.shields.io/badge/PHP-8-blue) [![License: MIT](https://img.shields.io/badge/License-MIT%20(Free)-brightgreen.svg)](https://github.com/phphleb/hleb/blob/master/LICENSE)


The `Muller` is not included in the original configuration of the framework [HLEB2](https://github.com/phphleb/hleb), so it must be copied to the folder with the vendor/phphleb  libraries from the [github.com/phphleb/muller](https://github.com/phphleb/muller)  repository or installed using Composer:

```bash
$ composer require phphleb/muller
```

Standard email sending via PHP function `mail(...)`. Used to confirm the registration of the framework, so SMTP is not supported.

```php
// Include or autoload
include '<vendor directory>/phphleb/muller/Src/DefaultMail.php';
include '<vendor directory>/phphleb/muller/Src/Errors.php';
include '<vendor directory>/phphleb/muller/StandardMail.php';

$mail = new \Phphleb\Muller\StandardMail(true); // Allow sending to multiple destinations

$mail->setNameFrom('User Name');
$mail->setAddressFrom('mailbox@main-site.com');
$mail->setParameters('-fmailbox@main-site.com');
$mail->setTitle('Verification letter');

$mail->setDebug(true);
$mail->setDebugPath('<storage directory>/logs');
$mail->saveOnlyToFile(false);
$mail->saveFileIntoDirectory('<storage directory>/logs');

$mail->setTo('test-address-1@example-site.ru');
$mail->setTo('test-address-2@example-site.ru', 'Recipient 2');
$mail->setToMultiple(['test-address-3@example-site.ru' => 'Recipient 3', 'test-address-4@example-site.ru' => 'Recipient 4']);

$mail->setContent('
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    </head>
    <body style="margin: 0; padding: 0; background-color: #E1D2C1; color: #000000">
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr>
                <td> 
                    Test letter text.
                </td>
            </tr>
        </table>
    </body>
</html>
');
$mail->send();

var_dump($mail->getErrors());

```
