@if ($paginator->hasPages())
    <nav>
        <ul class="pagination">
            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <li class="page-item disabled" aria-disabled="true">
                    <span class="page-link">@lang('main.previous')</span>
                </li>
            @else
                <li class="page-item">
                    <a class="page-link" href="{{ preg_replace('/(\?|\&)page=[1]$/', '', $paginator->previousPageUrl()) }}" rel="prev">@lang('main.previous')</a>
                </li>
            @endif

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <li class="page-item">
                    <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next">@lang('main.next')</a>
                </li>
            @else
                <li class="page-item disabled" aria-disabled="true">
                    <span class="page-link">@lang('main.next')</span>
                </li>
            @endif
        </ul>
    </nav>
@endif
