<?
/**
*      HTTP 1.1
*/
class HttpClient
{
  /**
  * @var string  - ( )
  */
  var $sProxyAddress = NULL;

  /**
  * @var integer  - ( )
  */
  var $iProxyPort = NULL;

  /**
  * @var array   -   HTTP
  */
  var $aRequestHeaders;

  /**
  * @var array   -   HTTP
  */
  var $aResponseHeaders = array();

  /**
  * @var boolean   .       ZLIB
  */
  var $bCanCompress = false;

  /**
  * 
  */
  function wkHttpClient()
  {
    $this->aRequestHeaders = array(
       'User-Agent'  => 'Mozilla/4.0 (compatible; MSIE 4.01; Windows PHClient)'
      ,'Pragma'  => 'no-cache'
      ,'Expires'  => 'Mon, 26 Jul 1997 05:00:00 GMT'
      ,'Connection'  => 'Keep-Alive'
    );
  }
  
  /**
  *   ,   .
  * @param array $aHeaders [in]  
  * @return integer true
  */
  function SetHeaders($aHeaders)
  {
    $this->aRequestHeaders = array_merge($this->aRequestHeaders, $aHeaders);
    return true;
  }
  
  /**
  *   Basic- HTTP
  * @param string $sUser     [in] username
  * @param string $sPassword [in] password
  * @return integer true
  */
  function SetAuthParams($sUser, $sPassword)
  {
    $tmp = base64_encode("$sUser:$sPassword");
    $this->SetHeaders(array('Authorization' => 'Basic '.$tmp)); 
    return true;
  }
  
  /**
  *   Proxy
  * @param string $sAddress [in]  -
  * @param integer $iPort   [in]  -
  * @return integer true
  */
  function SetProxy($sAddress, $iPort = 8080)
  {
    $this->sProxyAddress = $sAddress; 
    $this->iProxyPort    = $iPort; 
    return true;
  }
  
  /**
  *   Proxy-
  * @param string $sUser     [in] username
  * @param string $sPassword [in] password
  * @return integer true
  */
  function SetProxyAuthParams($sUser, $sPassword)
  {
    $tmp = base64_encode("$sUser:$sPassword");
    $this->SetHeaders(array('Proxy-Authorization' => 'Basic '.$tmp)); 
    return true;
  }
  
  /**
  *    HTTP 1.1 GET
  * 
  * @global class  $wk_logger
  * @param string $sHost      [in]   
  * @param string $sUrl       [in]      (. '/webkarta/disp_js?qwe=3')
  * @param string $iPort      [in]  ,  
  * @return mixed http response string on succeed or wkError   
  */
  function Get($sHost, $sUrl, $iPort = 80)
  {
    $req_str = "GET /$sUrl HTTP/1.0\r\n"
      ."Host: $sHost\r\n";
      
    if (is_array($this->aRequestHeaders)){
      foreach($this->aRequestHeaders as $k => $v)
      {
        $req_str .= "$k: $v\r\n";
      }
    }

    //  ,  
    $bCompress = (boolean)extension_loaded('zlib') && $this->bCanCompress;
    if ($bCompress)
    {
      $req_str .= "Accept-Encoding: gzip,deflate\r\n";
    } 
  
    $req_str .= "\r\n";  

    //  
    $sock_errno  = 0;
    $sock_errstr = '';
 
    // ,     
    if (empty($this->sProxyAddress))
    {
      $h = $sHost;
      $p = $iPort;
    } 
    else
    {
      $h = $this->sProxyAddress;
      $p = $this->iProxyPort;
    }

    $sock = @fsockopen($h, $p, $sock_errno, $sock_errstr, 30);
    if (FALSE === $sock) 
      return false;

    //   HTTP
    $res = fwrite($sock, $req_str);
    if (strlen($req_str) != $res)
      return false;
    
    //    HTTP
    $bEndOfHeader = false;

    while (!feof($sock) && !$bEndOfHeader)
    {
      $s = fgets($sock, 1024);
      $this->aResponseHeaders[] = $s; //todo split by :
  
      // Get Content Length
      $param = stristr($s, 'Content-length: ');
      if (is_string($param))
      {
        $content_length = (integer)substr($s, strlen('Content-length: '));
      }
      
      // Get Compression Method
      $param = stristr($s, 'Content-encoding: ');
      if (is_string($param))
      {
        $compress_method = trim( substr($s, strlen('Content-encoding: ')));
      }
      
      //    
      if ("\r\n" == $s) $bEndOfHeader = true;
    }
  
    //  
    $res = '';
    while (!feof($sock))
    {
      $tmp = fread($sock, 128);
      $res .= $tmp;
    }  
  
    //  
    fclose($sock);
  
    //    
    if (isset($compress_method))
    {
      switch ($compress_method)
      {
        case 'gzip' :
          $res = gzuncompress($res);
          break;
  
        case 'deflate' :
          $res = gzinflate($res);
          break;
        default:
          return 1;        
      }
    }
    return $res;
  }
}

?>