<?php
/*
*    playfon.ru version 5.1 (30.05.2006)
*/
if (!defined('LOCAL_TMP_DIR')) 
	define ('LOCAL_TMP_DIR', 'tmp/');
if (!defined('REMOTE_TMP_DIR')) 
	define ('REMOTE_TMP_DIR', 'tmp/');
if (!defined('LOCAL_FILE_REFRESHTIME')) 
	define ('LOCAL_FILE_REFRESHTIME', 86400);

if (!defined('REGION')) 
	define ('GAME_SERVER_NAME', 'wwwg.playfon.ru');
elseif (REGION == 'kz')
	define ('GAME_SERVER_NAME', 'wwwg.kz.playfon.ru');
else 
	define ('GAME_SERVER_NAME', 'wwwg.playfon.'.REGION);

require_once ('common_functions.php');

if (!class_exists('HttpClient'))
        include ('http_client.inc.php');
		

$aImgArray = array();

/**
* @return string            .
* @param sResourceURL string - url ,      /mygames.php?level=1&subluvel=3
* @param iResourceID int -   ,    PlayFon.ru
* @param $sExcludeGenres string -      . 
*                                 !!!      . : '1_12'
*/
function PlayFonGames($sResourceURL, $iResourceId, $sExcludeGenres = ''){
  $sRequest = 'ph_durl='.urlencode($sResourceURL);
  $sRequest .= '&ph_did='.((int) $iResourceId);

  if (!empty($sExcludeGenres)) $sRequest .= '&ph_exclude_genres='.urlencode($sExcludeGenres);

	if (is_array($_GET)){
	  foreach($_GET as $key=>$val){
	    if ('ph_'==substr($key, 0, 3))
	    {
	      $sRequest .= '&'.$key.'='.$val;
	    }
	  }
	}
    $Soc = new HttpClient();
    $sContent = $Soc->Get(GAME_SERVER_NAME, 'dealer_g.php?'.$sRequest);
    return $sContent;
}
/**
*     
* @return string            .
* @param sResourceURL string - url ,      /mygames.php?level=1&subluvel=3
* @param iResourceID int -   ,    playfon.ru
* @param iLimit int -      (  4)
* @param bShowPreview -     
* @param bShowCodes -      
* @param $sExcludeGenres string -      . 
*                                 !!!      . : '1_12'
*
*/

function PlayFonTopGames($sResourceURL, $iResourceId, $iLimit = 4, $bShowPreview = true, $bShowCodes = true, $sExcludeGenres = ''){
  global $_GET, $imgCount;
  
  $local_top_file = LOCAL_TMP_DIR.sGetRegion().'top_games.tmp';
  $life_time = time() - @filemtime($local_top_file);
  if ((file_exists($local_top_file)) && filesize($local_top_file) && ($life_time<LOCAL_FILE_REFRESHTIME)){
	$fp = fopen($local_top_file, 'r');
	if (filesize($local_top_file) >0){
	  $text = fread($fp, filesize($local_top_file));
	}else{
	 $text = '<span class="localfilesizeisnull">Waiting for data</span>';
	}
	fclose($fp);
	if (strlen($text) > 10) return $text;
  }
  $sRequest = 'ph_durl='.urlencode($sResourceURL);
  $sRequest .= '&ph_did='.((int) $iResourceId);
  $sRequest .= '&ph_limit='.((int) $iLimit);
  if (!empty($sExcludeGenres)) $sRequest .= '&ph_exclude_genres='.urlencode($sExcludeGenres);

  $sRequest .= '&ph_show='.(($bShowCodes)?1:0);
  $sRequest .= '&ph_pic='.(($bShowPreview)?1:0);

  foreach($_GET as $key=>$val){
    if ('ph_'==substr($key, 0, 3))
    {
      $sRequest .= '&'.$key.'='.$val;
    }
  }

    $Soc = new HttpClient();
    $sContent = $Soc->Get(GAME_SERVER_NAME, 'top_g.php?'.$sRequest);
	
	
	if (strlen($sContent) < 30) {
		//   
		@touch($local_top_file);
	    return $sContent;
	}

    $sContent = preg_replace('/src="([^"]+)"/e', "SaveAndReplaceImages('\\1', 'jt')", $sContent);
	
	if (strlen($sContent) < 30) {
		//   
		@touch($local_top_file);
	    return $sContent;
	}

	$fp = @fopen($local_top_file, 'w');
	if ($fp){
		fwrite($fp, $sContent);
		fclose($fp);
	}
    return $sContent;
}

/**
*    
* @return string            .
* @param sResourceURL string - url ,      /mygames.php?level=1&subluvel=3
* @param iResourceID int -   ,    playfon.ru
* @param iLimit int -      (  4)
* @param bShowPreview -     
* @param bShowCodes -      
* @param $sExcludeGenres string -      . 
*                                 !!!      . : '1_12'
*
*/

function PlayFonNewGames($sResourceURL, $iResourceId, $iLimit = 4, $bShowPreview = true, $bShowCodes = true, $sExcludeGenres = ''){
  $local_top_file = LOCAL_TMP_DIR.sGetRegion().'new_games.tmp';
  $life_time = time() - @filemtime($local_top_file);
  if ((file_exists($local_top_file)) && filesize($local_top_file) && ($life_time<LOCAL_FILE_REFRESHTIME)){
	$fp = fopen($local_top_file, 'r');
	if (filesize($local_top_file) >0){
  $text = fread($fp, filesize($local_top_file));
}else{
 $text = '<span class="localfilesizeisnull">Waiting for data</span>';
}
	fclose($fp);
	if (strlen($text) > 10) return $text;
  }
  $sRequest = 'ph_durl='.urlencode($sResourceURL);
  $sRequest .= '&ph_did='.((int) $iResourceId);
  $sRequest .= '&ph_limit='.((int) $iLimit);
  if (!empty($sExcludeGenres)) $sRequest .= '&ph_exclude_genres='.urlencode($sExcludeGenres);

  $sRequest .= '&ph_show='.(($bShowCodes)?1:0);
  $sRequest .= '&ph_pic='.(($bShowPreview)?1:0);


  foreach($_GET as $key=>$val){
    if ('ph_'==substr($key, 0, 3))
    {
      $sRequest .= '&'.$key.'='.$val;
    }
  }

    $Soc = new HttpClient();
    $sContent = $Soc->Get(GAME_SERVER_NAME, 'new_g.php?'.$sRequest);
	
	
	if (strlen($sContent) < 30) {
		//   
		@touch($local_top_file);
	    return $sContent;
	}

    $sContent = preg_replace('/src="([^"]+)"/e', "SaveAndReplaceImages('\\1', 'jn')", $sContent);

	$fp = @fopen($local_top_file, 'w');
	if ($fp){
		fwrite($fp, $sContent);
		fclose($fp);
	}
    return $sContent;
}

?>