<?php
#-----------------------------------------------------#
#          ********* ROTORCMS *********               #
#              Made by  :  VANTUZ                     #
#               E-mail  :  visavi.net@mail.ru         #
#                 Site  :  http://pizdec.ru           #
#             WAP-Site  :  http://visavi.net          #
#                  ICQ  :  36-44-66                   #
#  Вы не имеете право вносить изменения в код скрипта #
#        для его дальнейшего распространения          #
#-----------------------------------------------------#	
require_once ('../includes/start.php');
require_once ('../includes/functions.php');
require_once ('../includes/header.php');
include_once ('../themes/' . $config['themes'] . '/index.php');

$config['blogpost'] = 10;
$config['blogexprated'] = 72;
$config['blogexpread'] = 72;
$config['bloggroup'] = 10;
$config['blogcomm'] = 10;
$config['maxblogcomm'] = 300;

if (isset($_GET['act'])) {
    $act = check($_GET['act']);
} else {
    $act = 'index';
} 
if (isset($_GET['cid'])) {
    $cid = abs(intval($_GET['cid']));
} else {
    $cid = 0;
} 
if (isset($_GET['id'])) {
    $id = abs(intval($_GET['id']));
} else {
    $id = 0;
} 
if (isset($_GET['start'])) {
    $start = abs(intval($_GET['start']));
} else {
    $start = 0;
} 
if (empty($_GET['uz'])) {
    $uz = check($log);
} else {
    $uz = check($_GET['uz']);
} 

show_title('site.png', 'Блоги');
$config['newtitle'] = 'Блоги';

switch ($act):
# ###########################################################################################
# #                                    Главная страница                                    ##
# ###########################################################################################
case 'index':

    $queryblog = DB :: $dbh -> query("SELECT * FROM `catsblog` WHERE `cats_id`=? LIMIT 1;", array($cid));
    $cats = $queryblog -> fetch();

    if (!empty($cats)) {
        $config['newtitle'] = $cats['cats_name'];

        echo '<a href="#down"><img src="../images/img/downs.gif" alt="Вниз" /></a> <a href="index.php?' . SID . '">Блоги</a> / <a href="blog.php?act=new&amp;cid=' . $cid . '&amp;' . SID . '">Написать</a><br /><br />';

        echo '<img src="../images/img/open_dir.gif" alt="image" /> <b>' . $cats['cats_name'] . '</b> (Статей: ' . $cats['cats_count'] . ')';

        if (is_admin(array(101, 102, 103, 105))) {
            echo ' (<a href="' . ADMINDIR . 'blog.php?act=blog&amp;cid=' . $cid . '&amp;start=' . $start . '&amp;' . SID . '">Управление</a>)';
        } 
        echo '<hr />';

        $total = DB :: $dbh -> querySingle("SELECT count(*) FROM `blogs` WHERE `blogs_cats_id`=?;", array($cid));

        if ($total > 0) {
            if ($start >= $total) {
                $start = 0;
            } 

            $queryblog = DB :: $dbh -> query("SELECT * FROM `blogs` WHERE `blogs_cats_id`=? ORDER BY `blogs_time` DESC LIMIT " . $start . ", " . $config['blogpost'] . ";", array($cid));

            while ($data = $queryblog -> fetch()) {
                if ($data['blogs_rating'] > 0) {
                    $data['blogs_rating'] = '<span style="color:#00aa00">+' . $data['blogs_rating'] . '</span>';
                } 
                if ($data['blogs_rating'] < 0) {
                    $data['blogs_rating'] = '<span style="color:#ff0000">' . $data['blogs_rating'] . '</span>';
                } 

                echo '<div class="b"><img src="../images/img/edit.gif" alt="image" /> ';
                echo '<b><a href="blog.php?act=view&amp;id=' . $data['blogs_id'] . '&amp;' . SID . '">' . $data['blogs_title'] . '</a></b> (' . $data['blogs_rating'] . ')';
                echo '</div>';

                echo '<div>Автор: <a href="../pages/anketa.php?uz=' . $data['blogs_user'] . '&amp;' . SID . '">' . nickname($data['blogs_user']) . '</a> (' . date_fixed($data['blogs_time']) . ')<br />';
                echo 'Просмотров: ' . $data['blogs_read'] . '<br />';
                echo '<a href="blog.php?act=comments&amp;id=' . $data['blogs_id'] . '&amp;' . SID . '">Комментарии</a> (' . $data['blogs_comments'] . ')<br />';
                echo '</div>';
            } 

            page_strnavigation('blog.php?cid=' . $cid . '&amp;', $config['blogpost'], $start, $total);

            echo 'Всего статей: <b>' . $total . '</b><br /><br />';
        } else {
            show_error('Статей еще нет, будь первым!');
        } 
    } else {
        show_error('Ошибка! Данного раздела не существует!');
    } 

    echo '<a href="#up"><img src="../images/img/ups.gif" alt="up" /></a> ';
    echo '<a href="top.php?' . SID . '">Топ статей</a> / ';
    echo '<a href="tags.php?' . SID . '">Облако тегов</a> / ';
    echo '<a href="search.php?' . SID . '">Поиск</a> / ';
    echo '<a href="blog.php?act=blogs&amp;' . SID . '">Все статьи</a> / ';
    echo '<a href="blog.php?act=new&amp;cid=' . $cid . '&amp;' . SID . '">Написать</a><br />';
    break;
# ###########################################################################################
# #                                   Просмотр статьи                                      ##
# ###########################################################################################
case 'view':

    $queryblog = DB :: $dbh -> query("SELECT `blogs`.*, `catsblog`.`cats_id`, `catsblog`.`cats_name` FROM `blogs` LEFT JOIN `catsblog` ON `blogs`.`blogs_cats_id`=`catsblog`.`cats_id` WHERE `blogs_id`=? LIMIT 1;", array($id));
    $blogs = $queryblog -> fetch();

    if (!empty($blogs)) {
        $config['newtitle'] = $blogs['blogs_title'];
        $config['keywords'] = $blogs['blogs_tags'];
        $config['description'] = strip_str($blogs['blogs_text']);

        if ($blogs['blogs_rating'] > 0) {
            $blogs['blogs_rating'] = '<span style="color:#00aa00">+' . $blogs['blogs_rating'] . '</span>';
        } 
        if ($blogs['blogs_rating'] < 0) {
            $blogs['blogs_rating'] = '<span style="color:#ff0000">' . $blogs['blogs_rating'] . '</span>';
        } 

        echo '<a href="#down"><img src="../images/img/downs.gif" alt="Вниз" /></a> <a href="index.php?' . SID . '">Блоги</a> / <a href="blog.php?cid=' . $blogs['cats_id'] . '&amp;' . SID . '">' . $blogs['cats_name'] . '</a> / <a href="print.php?id=' . $id . '&amp;' . SID . '">Скачать</a> / <a href="rss.php?id=' . $id . '&amp;' . SID . '">RSS-лента</a>';

        if ($blogs['blogs_user'] == $log) {
            echo ' / <a href="blog.php?act=editblog&amp;id=' . $id . '&amp;' . SID . '">Изменить</a>';
        } 
        echo '<br /><br />';

        echo '<img src="../images/img/themes.gif" alt="Статья" /> <b>' . $blogs['blogs_title'] . '</b> (Оценка: ' . $blogs['blogs_rating'] . ')';

        if (is_admin(array(101, 102, 103, 105))) {
            echo ' (<a href="' . ADMINDIR . 'blog.php?act=editblog&amp;id=' . $id . '&amp;cid=' . $blogs['cats_id'] . '&amp;' . SID . '">Редактировать</a>)';
        } 

        echo '<hr />'; 
        // --------------
        $queryreads = DB :: $dbh -> querySingle("SELECT `read_ip` FROM `readblog` WHERE `read_blog`=? AND `read_ip`=? LIMIT 1;", array($id, $ip));

        if (empty($queryreads)) {
            $expiresread = SITETIME + 3600 * $config['blogexpread'];
            DB :: $dbh -> query("DELETE FROM `readblog` WHERE `read_time`<?;", array(SITETIME));
            DB :: $dbh -> query("INSERT INTO `readblog` (`read_blog`, `read_ip`, `read_time`) VALUES (?, ?, ?);", array($id, $ip, $expiresread));
            DB :: $dbh -> query("UPDATE `blogs` SET `blogs_read`=`blogs_read`+1 WHERE `blogs_id`=?;", array($id));
        } 
        // --------------
        echo bb_code($blogs['blogs_text']) . '<br /><br />';

        echo 'Автор статьи: <a href="../pages/anketa.php?uz=' . $blogs['blogs_user'] . '&amp;' . SID . '">' . nickname($blogs['blogs_user']) . '</a> (' . date_fixed($blogs['blogs_time']) . ')<br />';

        echo '<img src="../images/img/tag.gif" alt="Метки" /> ';

        $tags = preg_split('/[\s]*[,][\s]*/', $blogs['blogs_tags']);

        $i = 0;
        foreach($tags as $value) {
            if (empty($i)) {
                $comma = '';
            } else {
                $comma = ', ';
            } 
            echo $comma . '<a href="tags.php?act=search&amp;tags=' . safe_encode($value) . '&amp;' . SID . '">' . $value . '</a>';
            ++$i;
        } 

        echo '<hr />';

        echo 'Рейтинг: <a href="blog.php?act=vote&amp;id=' . $id . '&amp;vote=down&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '"><img src="../images/img/thumb-down.gif" alt="Минус" /></a> <big><b>' . $blogs['blogs_rating'] . '</b></big> <a href="blog.php?act=vote&amp;id=' . $id . '&amp;vote=up&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '"><img src="../images/img/thumb-up.gif" alt="Плюс" /></a><br />';
        echo '<img src="../images/img/eye.gif" alt="Просмотры" /> Просмотров: ' . $blogs['blogs_read'] . '<br />';
        echo '<img src="../images/img/balloon.gif" alt="Комментарии" /> <a href="blog.php?act=comments&amp;id=' . $id . '&amp;' . SID . '">Комментарии</a> (' . $blogs['blogs_comments'] . ')<br /><br />';
    } else {
        show_error('Ошибка! Данной статьи не существует!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="index.php?' . SID . '">К блогам</a><br />';
    break;
# ###########################################################################################
# #                            Подготовка к редактированию статьи                          ##
# ###########################################################################################
case 'editblog':

    if (is_user()) {
        $queryblog = DB :: $dbh -> query("SELECT * FROM `blogs` WHERE `blogs_id`=? LIMIT 1;", array($id));
        $blogs = $queryblog -> fetch();

        if (!empty($blogs)) {
            if ($blogs['blogs_user'] == $log) {
                $blogs['blogs_text'] = nosmiles($blogs['blogs_text']);
                $blogs['blogs_text'] = yes_br($blogs['blogs_text']);

                echo '<b><big>Редактирование</big></b><br /><br />';

                echo '<div class="form" id="form">';
                echo '<form action="blog.php?act=changeblog&amp;id=' . $id . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" name="form" method="post">';

                echo 'Заголовок:<br />';
                echo '<input type="text" name="title" size="50" maxlength="50" value="' . $blogs['blogs_title'] . '" /><br />';
                echo 'Текст:<br />';
                echo '<textarea cols="25" rows="15" name="text">' . $blogs['blogs_text'] . '</textarea><br />';

                if (!empty($udata['users_bbpanel'])) {
                    quickpaste('text');
                    quickcode();
                    quicksmiles();
                } 

                echo 'Метки:<br />';
                echo '<input type="text" name="tags" size="50" maxlength="100" value="' . $blogs['blogs_tags'] . '" /><br />';

                echo '<input type="submit" value="Изменить" /></form></div><br />';
            } else {
                show_error('Ошибка! Изменение невозможно, вы не автор данной статьи!');
            } 
        } else {
            show_error('Ошибка! Данной статьи не существует!');
        } 
    } else {
        show_login('Вы не авторизованы, чтобы редактировать татьи, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=view&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    echo '<img src="../images/img/reload.gif" alt="image" /> <a href="index.php?' . SID . '">Категории</a><br />';
    break;
# ###########################################################################################
# #                                  Редактирование статьи                                ##
# ###########################################################################################
case 'changeblog':

    $uid = check($_GET['uid']);
    $title = check($_POST['title']);
    $text = check($_POST['text']);
    $tags = check($_POST['tags']);

    if (is_user()) {
        if ($uid == $_SESSION['token']) {
            if (utf_strlen($title) >= 5 && utf_strlen($title) <= 50) {
                if (utf_strlen($text) >= 100 && utf_strlen($text) <= 50000) {
                    if (utf_strlen($tags) >= 2 && utf_strlen($tags) <= 50) {
                        $queryblog = DB :: $dbh -> query("SELECT * FROM `blogs` WHERE `blogs_id`=? LIMIT 1;", array($id));
                        $blogs = $queryblog -> fetch();

                        if (!empty($blogs)) {
                            if ($blogs['blogs_user'] == $log) {
                                $text = no_br($text);
                                $text = smiles($text);

                                DB :: $dbh -> query("UPDATE `blogs` SET `blogs_title`=?, `blogs_text`=?, `blogs_tags`=? WHERE `blogs_id`=?;", array($title, $text, $tags, $id));

                                $_SESSION['note'] = 'Статья успешно отредактирована!';
                                header ("Location: blog.php?act=view&id=$id&" . SID);
                                exit;
                            } else {
                                show_error('Ошибка! Изменение невозможно, вы не автор данной статьи!');
                            } 
                        } else {
                            show_error('Ошибка! Данной статьи не существует!');
                        } 
                    } else {
                        show_error('Ошибка! Слишком длинные или короткие метки статьи (от 2 до 50 символов)!');
                    } 
                } else {
                    show_error('Ошибка! Слишком длинный или короткий текст статьи (от 100 до 50000 символов)!');
                } 
            } else {
                show_error('Ошибка! Слишком длинный или короткий заголовок (от 5 до 50 символов)!');
            } 
        } else {
            show_error('Ошибка! Неверный идентификатор сессии, повторите действие!');
        } 
    } else {
        show_login('Вы не авторизованы, чтобы редактировать статьи, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=editblog&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    echo '<img src="../images/img/reload.gif" alt="image" /> <a href="blog.php?act=view&amp;id=' . $id . '&amp;' . SID . '">К статье</a><br />';
    break;
# ###########################################################################################
# #                                Просмотр по категориям                                  ##
# ###########################################################################################
case 'blogs':

    $config['newtitle'] = 'Статьи пользователей';

    $total = DB :: $dbh -> querySingle("select COUNT(DISTINCT `blogs_user`) from `blogs`");

    if ($total > 0) {
        if ($start >= $total) {
            $start = 0;
        } 

        $queryblogs = DB :: $dbh -> query("SELECT COUNT(*) AS cnt, `blogs_user` FROM `blogs` GROUP BY `blogs_user` ORDER BY cnt DESC LIMIT " . $start . ", " . $config['bloggroup'] . ";");

        while ($data = $queryblogs -> fetch()) {
            echo '<img src="../images/img/edit.gif" alt="image" /> ';
            echo '<b><a href="active.php?act=blogs&amp;uz=' . $data['blogs_user'] . '&amp;' . SID . '">' . nickname($data['blogs_user']) . '</a></b> (' . $data['cnt'] . ')<br />';
        } 

        page_strnavigation('blog.php?act=blogs&amp;', $config['bloggroup'], $start, $total);

        echo 'Всего пользователей: <b>' . $total . '</b><br /><br />';
    } else {
        show_error('Статей еще нет!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="index.php?' . SID . '">К блогам</a><br />';
    break;
# ###########################################################################################
# #                                   Создание статьи                                      ##
# ###########################################################################################
case 'new':

    $config['newtitle'] = 'Публикация новой статьи';

    if (is_user()) {
        $queryblog = DB :: $dbh -> query("SELECT `cats_id`, `cats_name` FROM `catsblog` ORDER BY `cats_order` ASC;");
        $blogs = $queryblog -> fetchAll();

        if (count($blogs) > 0) {
            echo '<div class="form" id="form">';
            echo '<form action="blog.php?act=addblog&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" name="form" method="post">';

            echo 'Категория*:<br />';
            echo '<select name="cid">';
            echo '<option value="0">Выберите категорию</option>';

            foreach ($blogs as $key => $data) {
                $selected = ($cid == $data['cats_id']) ? ' selected="selected"' : '';
                echo '<option value="' . $data['cats_id'] . '"' . $selected . '>' . $data['cats_name'] . '</option>';
            } 

            echo '</select><br />';

            echo 'Заголовок:<br />';
            echo '<input type="text" name="title" size="50" maxlength="50" /><br />';
            echo 'Текст:<br />';
            echo '<textarea cols="25" rows="10" name="text"></textarea><br />';

            if (!empty($udata['users_bbpanel'])) {
                quickpaste('text');
                quickcode();
                quicksmiles();
            } 

            echo 'Метки:<br />';
            echo '<input type="text" name="tags" size="50" maxlength="100" /><br />';

            echo '<input value="Опубликовать" type="submit" /></form></div><br />';

            echo 'Метки статьи должны быть от 2 до 20 символов с общей длиной не более 50 символов <br /><br />';
        } else {
            show_error('Категории блогов еще не созданы!');
        } 
    } else {
        show_login('Вы не авторизованы, для создания новой статьи, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="index.php?' . SID . '">К блогам</a><br />';
    break;
# ###########################################################################################
# #                                  Публикация скрипта                                    ##
# ###########################################################################################
case 'addblog':

    $config['newtitle'] = 'Публикация новой статьи';

    $uid = check($_GET['uid']);
    $cid = abs(intval($_POST['cid']));
    $title = check($_POST['title']);
    $text = check($_POST['text']);
    $tags = check($_POST['tags']);

    if (is_user()) {
        if ($uid == $_SESSION['token']) {
            if (!empty($cid)) {
                if (utf_strlen($title) >= 5 && utf_strlen($title) <= 50) {
                    if (utf_strlen($text) >= 100 && utf_strlen($text) <= 50000) {
                        if (utf_strlen($tags) >= 2 && utf_strlen($tags) <= 50) {
                            $blogs = DB :: $dbh -> querySingle("SELECT `cats_id` FROM `catsblog` WHERE `cats_id`=? LIMIT 1;", array($cid));
                            if (!empty($blogs)) {
                                if (is_quarantine($log)) {
                                    if (is_flood($log)) {
                                        $text = no_br($text);
                                        $text = antimat($text);
                                        $text = smiles($text);

                                        DB :: $dbh -> query("INSERT INTO `blogs` (`blogs_cats_id`, `blogs_user`, `blogs_title`, `blogs_text`, `blogs_tags`, `blogs_time`) VALUES (?, ?, ?, ?, ?, ?);", array($cid, $log, $title, $text, $tags, SITETIME));
                                        $lastid = DB :: $dbh -> lastInsertId();

                                        DB :: $dbh -> query("UPDATE `catsblog` SET `cats_count`=`cats_count`+1 WHERE `cats_id`=?;", array($cid));

                                        $_SESSION['note'] = 'Статья успешно опубликована!';
                                        header ("Location: blog.php?act=view&id=$lastid&" . SID);
                                        exit;
                                    } else {
                                        show_error('Антифлуд! Вы слишком часто добавляете статьи!');
                                    } 
                                } else {
                                    show_error('Карантин! Вы не можете добавлять статьи в течении ' . round($config['karantin'] / 3600) . ' часов!');
                                } 
                            } else {
                                show_error('Ошибка! Выбранный вами раздел не существует!');
                            } 
                        } else {
                            show_error('Ошибка! Слишком длинные или короткие метки статьи (от 2 до 50 символов)!');
                        } 
                    } else {
                        show_error('Ошибка! Слишком длинный или короткий текст статьи (от 100 до 50000 символов)!');
                    } 
                } else {
                    show_error('Ошибка! Слишком длинный или короткий заголовок (от 5 до 50 символов)!');
                } 
            } else {
                show_error('Ошибка! Вы не выбрали категорию для добавления статьи!');
            } 
        } else {
            show_error('Ошибка! Неверный идентификатор сессии, повторите действие!');
        } 
    } else {
        show_login('Вы не авторизованы, для создания новой статьи, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=new&amp;cid=' . $cid . '&amp;' . SID . '">Вернуться</a><br />';
    break;
# ###########################################################################################
# #                                       Оценка статьи                                    ##
# ###########################################################################################
case 'vote':

    $uid = check($_GET['uid']);
    $vote = check($_GET['vote']);

    if (is_user()) {
        if ($uid == $_SESSION['token']) {
            if ($vote == 'up' || $vote == 'down') {
                if ($vote == 'up') {
                    $score = 1;
                } else {
                    $score = -1;
                } 

                $queryblog = DB :: $dbh -> query("SELECT * FROM `blogs` WHERE `blogs_id`=? LIMIT 1;", array($id));
                $blogs = $queryblog -> fetch();

                if (!empty($blogs)) {
                    if ($log != $blogs['blogs_user']) {
                        $queryrated = DB :: $dbh -> querySingle("SELECT `rated_id` FROM `ratedblog` WHERE `rated_blog`=? AND `rated_user`=? LIMIT 1;", array($id, $log));

                        if (empty($queryrated)) {
                            $expiresrated = SITETIME + 3600 * $config['blogexprated'];

                            DB :: $dbh -> query("DELETE FROM `ratedblog` WHERE `rated_time`<?;", array(SITETIME));
                            DB :: $dbh -> query("INSERT INTO `ratedblog` (`rated_blog`, `rated_user`, `rated_time`) VALUES (?, ?, ?);", array($id, $log, $expiresrated));
                            DB :: $dbh -> query("UPDATE `blogs` SET `blogs_rating`=`blogs_rating`+? WHERE `blogs_id`=?", array($score, $id));

                            echo '<b>Спасибо! Ваша оценка принята!</b><br />';
                            echo 'Рейтинг статьи: ' . ($blogs['blogs_rating'] + $score) . '<br /><br />';
                        } else {
                            show_error('Ошибка! Вы уже оценивали данную статью!');
                        } 
                    } else {
                        show_error('Ошибка! Нельзя голосовать за свою статью!');
                    } 
                } else {
                    show_error('Ошибка! Данной статьи не существует!');
                } 
            } else {
                show_error('Ошибка! Необходимо проголосовать за или против статьи!');
            } 
        } else {
            show_error('Ошибка! Неверный идентификатор сессии, повторите действие!');
        } 
    } else {
        show_login('Вы не авторизованы, для голосования за статьи, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=view&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    break;
# ###########################################################################################
# #                                      Комментарии                                       ##
# ###########################################################################################
case 'comments':

    $queryblog = DB :: $dbh -> query("SELECT * FROM `blogs` WHERE `blogs_id`=? LIMIT 1;", array($id));
    $blogs = $queryblog -> fetch();

    if (!empty($blogs)) {
        $config['newtitle'] = 'Комментарии - ' . $blogs['blogs_title'];

        echo '<img src="../images/img/edit.gif" alt="Статья" /> <b><a href="blog.php?act=view&amp;id=' . $id . '&amp;' . SID . '">' . $blogs['blogs_title'] . '</a></b><br /><br />';

        echo '<a href="#down"><img src="../images/img/downs.gif" alt="Вниз" /></a> ';
        echo '<a href="blog.php?act=comments&amp;id=' . $id . '&amp;rand=' . mt_rand(100, 999) . '&amp;' . SID . '">Обновить</a> / <a href="rss.php?id=' . $id . '&amp;' . SID . '">RSS-лента</a><hr />';

        $total = DB :: $dbh -> querySingle("SELECT count(*) FROM `commblog` WHERE `commblog_blog`=?;", array($id));

        if ($total > 0) {
            if ($start >= $total) {
                $start = 0;
            } 

            $is_admin = is_admin(array(101, 102, 103, 105));
            if ($is_admin) {
                echo '<form action="blog.php?act=del&amp;id=' . $id . '&amp;start=' . $start . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" method="post">';
            } 

            $querycomm = DB :: $dbh -> query("SELECT * FROM `commblog` WHERE `commblog_blog`=? ORDER BY `commblog_time` DESC LIMIT " . $start . ", " . $config['blogcomm'] . ";", array($id));

            while ($data = $querycomm -> fetch()) {
                echo '<div class="b">';
                echo '<div class="img">';

                if ($is_admin) {
                    echo '<input type="checkbox" name="del[]" value="' . $data['commblog_id'] . '" /> ';
                } 

                echo user_avatars($data['commblog_author']) . '</div>';

                echo '<b><a href="../pages/anketa.php?uz=' . $data['commblog_author'] . '&amp;' . SID . '">' . nickname($data['commblog_author']) . '</a></b>';
                echo ' <small>(' . date_fixed($data['commblog_time']) . ')</small><br />';
                echo user_title($data['commblog_author']) . ' ' . user_online($data['commblog_author']) . '</div>';

                if (!empty($log) && $log != $data['commblog_author']) {
                    echo '<div class="right">';
                    echo '<a href="blog.php?act=reply&amp;id=' . $id . '&amp;pid=' . $data['commblog_id'] . '&amp;start=' . $start . '&amp;' . SID . '">Отв</a> / ';
                    echo '<a href="blog.php?act=quote&amp;id=' . $id . '&amp;pid=' . $data['commblog_id'] . '&amp;start=' . $start . '&amp;' . SID . '">Цит</a> / ';
                    echo '<a href="blog.php?act=spam&amp;id=' . $id . '&amp;pid=' . $data['commblog_id'] . '&amp;start=' . $start . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" onclick="return confirm(\'Вы подтверждаете факт спама?\')">Спам</a></div>';
                } 

                if ($log == $data['commblog_author'] && $data['commblog_time'] + 600 > SITETIME) {
                    echo '<div class="right"><a href="blog.php?act=edit&amp;id=' . $id . '&amp;pid=' . $data['commblog_id'] . '&amp;start=' . $start . '&amp;' . SID . '">Редактировать</a></div>';
                } 

                echo '<div>' . bb_code($data['commblog_text']) . '<br />';
                echo '<span class="data">(' . $data['commblog_brow'] . ', ' . $data['commblog_ip'] . ')</span></div>';
            } 

            if ($is_admin) {
                echo '<br /><input type="submit" value="Удалить выбранное" /></form>';
            } 

            page_strnavigation('blog.php?act=comments&amp;id=' . $id . '&amp;', $config['blogcomm'], $start, $total);
        } else {
            show_error('Комментариев еще нет!');
        } 

        if (is_user()) {
            echo '<div class="form">';
            echo '<form action="blog.php?act=add&amp;id=' . $id . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" name="form" method="post">';
            echo '<b>Сообщение:</b><br />';
            echo '<textarea cols="25" rows="3" name="msg"></textarea><br />';

            if (!empty($udata['users_bbpanel'])) {
                quickpaste('msg');
                quickcode();
                quicksmiles();
            } 

            echo '<input type="submit" value="Написать" /></form></div><br />';

            echo '<a href="#up"><img src="../images/img/ups.gif" alt="image" /></a> ';
            echo '<a href="../pages/pravila.php?' . SID . '">Правила</a> / ';
            echo '<a href="../pages/smiles.php?' . SID . '">Смайлы</a> / ';
            echo '<a href="../pages/tegi.php?' . SID . '">Теги</a><br /><br />';
        } else {
            show_login('Вы не авторизованы, чтобы добавить сообщение, необходимо');
        } 
    } else {
        show_error('Ошибка! Данной статьи не существует!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=view&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    echo '<img src="../images/img/edit.gif" alt="image" /> <a href="index.php?' . SID . '">К блогам</a><br />';
    break;
# ###########################################################################################
# #                                Добавление комментариев                                 ##
# ###########################################################################################
case "add":

    $uid = check($_GET['uid']);
    $id = abs(intval($_GET['id']));
    $msg = check($_POST['msg']);

    if (is_user()) {
        if ($uid == $_SESSION['token']) {
            if (utf_strlen($msg) >= 5 && utf_strlen($msg) < 1000) {
                $queryblog = DB :: $dbh -> querySingle("SELECT `blogs_cats_id` FROM `blogs` WHERE `blogs_id`=? LIMIT 1;", array($id));

                if (!empty($queryblog)) {
                    if (is_quarantine($log)) {
                        if (is_flood($log)) {
                            $msg = no_br($msg);
                            $msg = antimat($msg);
                            $msg = smiles($msg);

                            DB :: $dbh -> query("INSERT INTO `commblog` (`commblog_cats`, `commblog_blog`, `commblog_text`, `commblog_author`, `commblog_time`, `commblog_ip`, `commblog_brow`) VALUES (?, ?, ?, ?, ?, ?, ?);", array($queryblog, $id, $msg, $log, SITETIME, $ip, $brow));

                            DB :: $dbh -> query("DELETE FROM `commblog` WHERE `commblog_blog`=? AND `commblog_time` < (SELECT MIN(`commblog_time`) FROM (SELECT `commblog_time` FROM `commblog` WHERE `commblog_blog`=? ORDER BY `commblog_time` DESC LIMIT " . $config['maxblogcomm'] . ") AS del);", array($id, $id));

                            DB :: $dbh -> query("UPDATE `blogs` SET `blogs_comments`=`blogs_comments`+1 WHERE `blogs_id`=?;", array($id));
                            DB :: $dbh -> query("UPDATE `users` SET `users_allcomments`=`users_allcomments`+1, `users_point`=`users_point`+1, `users_money`=`users_money`+5 WHERE `users_login`=?", array($log));

                            $_SESSION['note'] = 'Сообщение успешно добавлено!';
                            header ("Location: blog.php?act=comments&id=$id&" . SID);
                            exit;
                        } else {
                            show_error('Антифлуд! Разрешается отправлять сообщения раз в ' . flood_period() . ' секунд!');
                        } 
                    } else {
                        show_error('Карантин! Вы не можете писать в течении ' . round($config['karantin'] / 3600) . ' часов!');
                    } 
                } else {
                    show_error('Ошибка! Данной статьи не существует!');
                } 
            } else {
                show_error('Ошибка! Слишком длинное или короткое сообщение!');
            } 
        } else {
            show_error('Ошибка! Неверный идентификатор сессии, повторите действие!');
        } 
    } else {
        show_login('Вы не авторизованы, чтобы добавить сообщение, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=comments&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    break;
# ###########################################################################################
# #                                    Жалоба на спам                                      ##
# ###########################################################################################
case "spam":

    $uid = check($_GET['uid']);
    $pid = abs(intval($_GET['pid']));

    if (is_user()) {
        if ($uid == $_SESSION['token']) {
            $queryblog = DB :: $dbh -> query("SELECT * FROM `commblog` WHERE `commblog_id`=? LIMIT 1;", array($pid));
            $data = $queryblog -> fetch();

            if (!empty($data)) {
                $queryspam = DB :: $dbh -> querySingle("SELECT `spam_id` FROM `spam` WHERE `spam_key`=? AND `spam_idnum`=? LIMIT 1;", array(6, $pid));

                if (empty($queryspam)) {
                    if (is_flood($log)) {
                        DB :: $dbh -> query("INSERT INTO `spam` (`spam_key`, `spam_idnum`, `spam_user`, `spam_login`, `spam_text`, `spam_time`, `spam_addtime`, `spam_link`) VALUES (?, ?, ?, ?, ?, ?, ?, ?);", array(6, $data['commblog_id'], $log, $data['commblog_author'], $data['commblog_text'], $data['commblog_time'], SITETIME, $config['home'] . '/blog/blog.php?act=comments&amp;id=' . $id . '&amp;start=' . $start));

                        $_SESSION['note'] = 'Жалоба успешно отправлена!';
                        header ("Location: blog.php?act=comments&id=$id&start=$start&" . SID);
                        exit;
                    } else {
                        show_error('Антифлуд! Разрешается жаловаться на спам не чаще чем раз в ' . flood_period() . ' секунд!');
                    } 
                } else {
                    show_error('Ошибка! Жалоба на данное сообщение уже отправлена!');
                } 
            } else {
                show_error('Ошибка! Выбранное вами сообщение для жалобы не существует!');
            } 
        } else {
            show_error('Ошибка! Неверный идентификатор сессии, повторите действие!');
        } 
    } else {
        show_login('Вы не авторизованы, чтобы подать жалобу, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=comments&amp;id=' . $id . '&amp;start=' . $start . '&amp;' . SID . '">Вернуться</a><br />';
    break;
# ###########################################################################################
# #                                   Ответ на сообщение                                   ##
# ###########################################################################################
case "reply":

    $id = abs(intval($_GET['id']));
    $pid = abs(intval($_GET['pid']));

    echo '<b><big>Ответ на сообщение</big></b><br /><br />';

    if (is_user()) {
        $queryblog = DB :: $dbh -> query("SELECT * FROM `commblog` WHERE `commblog_id`=? LIMIT 1;", array($pid));
        $post = $queryblog -> fetch();

        if (!empty($post)) {
            echo '<div class="b"><img src="../images/img/edit.gif" alt="image" /> <b><a href="../pages/anketa.php?uz=' . $post['commblog_author'] . '&amp;' . SID . '">' . nickname($post['commblog_author']) . '</a></b> ' . user_title($post['commblog_author']) . ' ' . user_online($post['commblog_author']) . ' <small>(' . date_fixed($post['commblog_time']) . ')</small></div>';
            echo '<div>Сообщение: ' . bb_code($post['commblog_text']) . '</div><hr />';

            echo '<div class="form" id="form">';
            echo '<form action="blog.php?act=add&amp;id=' . $id . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" name="form" method="post">';
            echo 'Сообщение:<br />';
            echo '<textarea cols="25" rows="5" name="msg">[b]' . nickname($post['commblog_author']) . '[/b], </textarea><br />';

            if (!empty($udata['users_bbpanel'])) {
                quickpaste('msg');
                quickcode();
                quicksmiles();
            } 

            echo '<input type="submit" value="Ответить" /></form></div><br />';
        } else {
            show_error('Ошибка! Выбранное вами сообщение для ответа не существует!');
        } 
    } else {
        show_login('Вы не авторизованы, чтобы отвечать на сообщения, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=comments&amp;id=' . $id . '&amp;start=' . $start . '&amp;' . SID . '">Вернуться</a><br />';
    break;
# ###########################################################################################
# #                                   Цитирование сообщения                                ##
# ###########################################################################################
case "quote":

    $pid = abs(intval($_GET['pid']));

    echo '<b><big>Цитирование</big></b><br /><br />';
    if (is_user()) {
        $queryblog = DB :: $dbh -> query("SELECT * FROM `commblog` WHERE `commblog_id`=? LIMIT 1;", array($pid));
        $post = $queryblog -> fetch();

        if (!empty($post)) {
            $post['commblog_text'] = nosmiles($post['commblog_text']);
            $post['commblog_text'] = preg_replace('|\[q\](.*?)\[/q\](<br />)?|', '', $post['commblog_text']);
            $post['commblog_text'] = str_replace('<br />', "\r\n", $post['commblog_text']);

            echo '<div class="form" id="form">';
            echo '<form action="blog.php?act=add&amp;id=' . $id . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" name="form" method="post">';
            echo 'Сообщение:<br />';
            echo '<textarea cols="25" rows="5" name="msg">[q][b]' . nickname($post['commblog_author']) . '[/b] (' . date_fixed($post['commblog_time']) . ')' . "\r\n" . $post['commblog_text'] . '[/q]' . "\r\n" . '</textarea><br />';

            if (!empty($udata['users_bbpanel'])) {
                quickpaste('msg');
                quickcode();
                quicksmiles();
            } 

            echo '<input type="submit" value="Цитировать" /></form></div><br />';
        } else {
            show_error('Ошибка! Выбранное вами сообщение для цитирования не существует!');
        } 
    } else {
        show_login('Вы не авторизованы, чтобы цитировать сообщения, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=comments&amp;id=' . $id . '&amp;start=' . $start . '&amp;' . SID . '">Вернуться</a><br />';
    break;
# ###########################################################################################
# #                                Подготовка к редактированию                             ##
# ###########################################################################################
case "edit":

    $config['newtitle'] = 'Редактирование сообщения';

    $pid = abs(intval($_GET['pid']));

    if (is_user()) {
        $querypost = DB :: $dbh -> query("SELECT * FROM `commblog` WHERE `commblog_id`=? AND `commblog_author`=? LIMIT 1;", array($pid, $log));
        $post = $querypost -> fetch();

        if (!empty($post)) {
            if ($post['commblog_time'] + 600 > SITETIME) {
                $post['commblog_text'] = nosmiles($post['commblog_text']);
                $post['commblog_text'] = yes_br($post['commblog_text']);

                echo '<img src="../images/img/edit.gif" alt="image" /> <b>' . nickname($post['commblog_author']) . '</b> <small>(' . date_fixed($post['commblog_time']) . ')</small><br /><br />';

                echo '<div class="form" id="form">';
                echo '<form action="blog.php?act=editpost&amp;id=' . $post['commblog_blog'] . '&amp;pid=' . $pid . '&amp;start=' . $start . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" name="form" method="post">';
                echo 'Редактирование сообщения:<br />';
                echo '<textarea cols="25" rows="5" name="msg" id="msg">' . $post['commblog_text'] . '</textarea><br />';

                if (!empty($udata['users_bbpanel'])) {
                    quickpaste('msg');
                    quickcode();
                    quicksmiles();
                } 

                echo '<input type="submit" value="Редактировать" /></form></div><br />';
            } else {
                show_error('Ошибка! Редактирование невозможно, прошло более 10 минут!!');
            } 
        } else {
            show_error('Ошибка! Сообщение удалено или вы не автор этого сообщения!');
        } 
    } else {
        show_login('Вы не авторизованы, чтобы редактировать сообщения, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=comments&amp;id=' . $id . '&amp;start=' . $start . '&amp;' . SID . '">Вернуться</a><br />';
    break;
# ###########################################################################################
# #                                    Редактирование сообщения                            ##
# ###########################################################################################
case "editpost":

    $uid = check($_GET['uid']);
    $pid = abs(intval($_GET['pid']));
    $msg = check($_POST['msg']);

    if (is_user()) {
        if ($uid == $_SESSION['token']) {
            if (utf_strlen($msg) >= 5 && utf_strlen($msg) < 1000) {
                $querypost = DB :: $dbh -> query("SELECT * FROM `commblog` WHERE `commblog_id`=? AND `commblog_author`=? LIMIT 1;", array($pid, $log));
                $post = $querypost -> fetch();

                if (!empty($post)) {
                    if ($post['commblog_time'] + 600 > SITETIME) {
                        $msg = no_br($msg);
                        $msg = antimat($msg);
                        $msg = smiles($msg);

                        DB :: $dbh -> query("UPDATE `commblog` SET `commblog_text`=? WHERE `commblog_id`=?", array($msg, $pid));

                        $_SESSION['note'] = 'Сообщение успешно отредактировано!';
                        header ("Location: blog.php?act=comments&id=$id&start=$start&" . SID);
                        exit;
                    } else {
                        show_error('Ошибка! Редактирование невозможно, прошло более 10 минут!!');
                    } 
                } else {
                    show_error('Ошибка! Сообщение удалено или вы не автор этого сообщения!');
                } 
            } else {
                show_error('Ошибка! Слишком длинное или короткое сообщение!');
            } 
        } else {
            show_error('Ошибка! Неверный идентификатор сессии, повторите действие!');
        } 
    } else {
        show_login('Вы не авторизованы, чтобы редактировать сообщения, необходимо');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=edit&amp;id=' . $id . '&amp;pid=' . $pid . '&amp;start=' . $start . '&amp;' . SID . '">Вернуться</a><br />';
    break;
# ###########################################################################################
# #                                 Удаление комментариев                                  ##
# ###########################################################################################
case "del":

    $uid = check($_GET['uid']);
    if (isset($_POST['del'])) {
        $del = intar($_POST['del']);
    } else {
        $del = 0;
    } 

    if (is_admin(array(101, 102, 103, 105))) {
        if ($uid == $_SESSION['token']) {
            if (!empty($del)) {
                $del = implode(',', $del);

                $delcomments = DB :: $dbh -> exec("DELETE FROM `commblog` WHERE `commblog_id` IN (" . $del . ") AND `commblog_blog`=" . $id . ";");
                DB :: $dbh -> query("UPDATE `blogs` SET `blogs_comments`=`blogs_comments`-? WHERE `blogs_id`=?;", array($delcomments, $id));

                $_SESSION['note'] = 'Выбранные комментарии успешно удалены!';
                header ("Location: blog.php?act=comments&id=$id&start=$start&" . SID);
                exit;
            } else {
                show_error('Ошибка! Отстутствуют выбранные комментарии для удаления!');
            } 
        } else {
            show_error('Ошибка! Неверный идентификатор сессии, повторите действие!');
        } 
    } else {
        show_error('Ошибка! Удалять комментарии могут только модераторы!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="blog.php?act=comments&amp;id=' . $id . '&amp;start=' . $start . '&amp;' . SID . '">Вернуться</a><br />';
    break;

default:
    header("location: blog.php?" . SID);
    endswitch;

    echo '<img src="../images/img/homepage.gif" alt="image" /> <a href="../index.php?' . SID . '">На главную</a>';

    include_once ("../themes/" . $config['themes'] . "/foot.php");

    ?>