<?php
#-----------------------------------------------------#
#          ********* ROTORCMS *********               #
#              Made by  :  VANTUZ                     #
#               E-mail  :  visavi.net@mail.ru         #
#                 Site  :  http://pizdec.ru           #
#             WAP-Site  :  http://visavi.net          #
#                  ICQ  :  36-44-66                   #
#  Вы не имеете право вносить изменения в код скрипта #
#        для его дальнейшего распространения          #
#-----------------------------------------------------#	
if (!defined('BASEDIR')) {
    header("Location:../index.php");
    exit;
} 
// --------------------------- Функция перевода секунд во время -----------------------------//
function maketime($string) {
    if ($string < 3600) {
        $string = sprintf("%02d:%02d", (int)($string / 60) % 60, $string % 60);
    } else {
        $string = sprintf("%02d:%02d:%02d", (int)($string / 3600) % 24, (int)($string / 60) % 60, $string % 60);
    } 
    return $string;
} 
// --------------------------- Функция перевода секунд в дни -----------------------------//
function makestime($string) {
    $day = floor($string / 86400);
    $hours = floor(($string / 3600) - $day * 24);
    $min = floor(($string - $hours * 3600 - $day * 86400) / 60);
    $sec = $string - ($min * 60 + $hours * 3600 + $day * 86400);

    return sprintf("%01d дн. %02d:%02d:%02d", $day, $hours, $min, $sec);
} 
// --------------------------- Функция временного сдвига -----------------------------//
function date_fixed($timestamp, $format = "d.m.y / H:i") {
    global $config;

    if (!is_numeric($timestamp)) {
        $timestamp = SITETIME;
    } 
    $shift = $config['timeclocks'] * 3600;
    $datestamp = date($format, $timestamp + $shift);

    $today = date("d.m.y", SITETIME + $shift);
    $yesterday = date("d.m.y", strtotime("-1 day") + $shift);

    $datestamp = str_replace($today, 'Сегодня', $datestamp);
    $datestamp = str_replace($yesterday, 'Вчера', $datestamp);

    $search = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
    $replace = array('Января', 'Февраля', 'Марта', 'Апреля', 'Мая', 'Июня', 'Июля', 'Августа', 'Сентября', 'Октября', 'Ноября', 'Декабря');
    $datestamp = str_replace($search, $replace, $datestamp);

    return $datestamp;
} 
// ------------------- Функция полного удаления юзера --------------------//
function delete_users($uz) {
    $userpic = DB :: $dbh -> querySingle("SELECT `users_picture` FROM `users` WHERE `users_login`=? LIMIT 1;", array($uz));

    if (file_exists(BASEDIR . "gallery/avatаrs/$uz.gif")) {
        unlink (BASEDIR . "gallery/avatаrs/$uz.gif");
    } 
    if (!empty($userpic) && file_exists(BASEDIR . "gallery/photos/$userpic")) {
        unlink (BASEDIR . "gallery/photos/$userpic");
    } 

    DB :: $dbh -> query("DELETE FROM `inbox` WHERE `inbox_user`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `outbox` WHERE `outbox_author`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `trash` WHERE `trash_user`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `contact` WHERE `contact_user`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `ignore` WHERE `ignore_user`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `users` WHERE `users_login`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `bank` WHERE `bank_user`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `lotusers` WHERE `lot_user`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `rating` WHERE `rating_user`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `visit` WHERE `visit_user`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `wall` WHERE `wall_user`=?;", array($uz));
    DB :: $dbh -> query("DELETE FROM `notebook` WHERE `note_user`=?;", array($uz));
    delete_album($uz);
} 
// ------------------- Функция удаления фотоальбома юзера --------------------//
function delete_album($uz) {
    $querydel = DB :: $dbh -> query("SELECT `photo_id`, `photo_link` FROM `photo` WHERE `photo_user`=?;", array($uz));
    $arr_photo = $querydel -> fetchAll();

    if (count($arr_photo) > 0) {
        foreach ($arr_photo as $delete) {
            DB :: $dbh -> query("DELETE FROM `photo` WHERE `photo_id`=? LIMIT 1;", array($delete['photo_id']));
            DB :: $dbh -> query("DELETE FROM `commphoto` WHERE `commphoto_gid`=?;", array($delete['photo_id']));
            if (file_exists(BASEDIR . 'gallery/pictures/' . $delete['photo_link'])) {
                unlink(BASEDIR . 'gallery/pictures/' . $delete['photo_link']);
            } 
        } 
    } 
} 
// --------------- Функция правильного окончания для денег -------------------//
function moneys($string) {
    $string = (int)$string;

    $str1 = abs($string) % 100;
    $str2 = $string % 10;

    if ($str1 > 10 && $str1 < 20) return $string . ' рублей';
    if ($str2 > 1 && $str2 < 5) return $string . ' рубля';
    if ($str2 == 1) return $string . ' рубль';

    return $string . ' рублей';
} 
// --------------- Функция правильного окончания для актива -------------------//
function points($string) {
    $string = (int)$string;

    $str1 = abs($string) % 100;
    $str2 = $string % 10;

    if ($str1 > 10 && $str1 < 20) return $string . ' баллов';
    if ($str2 > 1 && $str2 < 5) return $string . ' балла';
    if ($str2 == 1) return $string . ' балл';

    return $string . ' баллов';
} 
// ------------------ Функция подсветки кода -------------------------//
function highlight_code($code) {
    $code = nosmiles($code);
    $code = strtr($code, array('&lt;' => '<', '&gt;' => '>', '&amp;' => '&', '&quot;' => '"', '&#36;' => '$', '&#37;' => '%', '&#39;' => "'", '&#92;' => '\\', '&#94;' => '^', '&#96;' => '`', '&#124;' => '|', '<br />' => "\r\n"));

    $code = highlight_string($code, true);
    $code = strtr($code, array("\r\n" => '<br />', '$' => '&#36;', "'" => '&#39;', '%' => '&#37;', '\\' => '&#92;', '`' => '&#96;', '^' => '&#94;', '|' => '&#124;'));

    $code = '<div class="d">' . $code . '</div>';
    return $code;
} 
// ----------------------- Функция скрытого текста ------------------------//
function hidden_text($msg) {
    if (is_user()) {
        $text = '<div class="hide"><b>Скрытый текст:</b> ' . $msg . '</div>';
    } else {
        $text = '<div class="hide"><b>Скрытый текст.</b> Для просмотра необходимо авторизоваться!</div>';
    } 

    return $text;
} 
// ------------------ Вспомогательная функция для bb-кода --------------------//
function url_replace($m) {
    global $config;

    if (!isset($m[3])) {
        $target = (strpos($m[1], $config['home']) === false) ? ' target="_blank"' : '';
        return '<a href="' . $m[1] . '"' . $target . '>' . $m[2] . '</a>';
    } else {
        $target = (strpos($m[3], $config['home']) === false) ? ' target="_blank"' : '';
        return '<a href="' . $m[3] . '"' . $target . '>' . $m[3] . '</a>';
    } 
} 
// ------------------ Функция вставки BB-кода --------------------//
function bb_code($msg) {
    $msg = preg_replace('#\[code\](.*?)\[/code\]#ie', 'highlight_code("\1")', $msg);
    $msg = preg_replace('#\[hide\](.*?)\[/hide\]#ie', 'hidden_text("\1")', $msg);
    $msg = preg_replace('#\[big\](.*?)\[/big\]#si', '<big>\1</big>', $msg);
    $msg = preg_replace('#\[b\](.*?)\[/b\]#si', '<b>\1</b>', $msg);
    $msg = preg_replace('#\[i\](.*?)\[/i\]#si', '<i>\1</i>', $msg);
    $msg = preg_replace('#\[u\](.*?)\[/u\]#si', '<u>\1</u>', $msg);
    $msg = preg_replace('#\[small\](.*?)\[/small\]#si', '<small>\1</small>', $msg);
    $msg = preg_replace('#\[red\](.*?)\[/red\]#si', '<span style="color:#ff0000">\1</span>', $msg);
    $msg = preg_replace('#\[green\](.*?)\[/green\]#si', '<span style="color:#00cc00">\1</span>', $msg);
    $msg = preg_replace('#\[blue\](.*?)\[/blue\]#si', '<span style="color:#0000ff">\1</span>', $msg);
    $msg = preg_replace('#\[q\](.*?)\[/q\]#si', '<div class="q">\1</div>', $msg);
    $msg = preg_replace('#\[del\](.*?)\[/del\]#si', '<del>\1</del>', $msg);
    $msg = preg_replace_callback('~\\[url=(http://.+?)\\](.+?)\\[/url\\]|(http://(www.)?[0-9a-z\.\-]+\.[0-9a-z]{2,6}[0-9a-zA-Z/\?\.\-\~&;_=%:#]*)~', 'url_replace', $msg);
    return $msg;
} 
// ------------------ Функция перекодировки из UTF в WIN --------------------//
function utf_to_win($str) {
    if (function_exists('mb_convert_encoding')) return mb_convert_encoding($str, 'windows-1251', 'utf-8');
    if (function_exists('iconv')) return iconv('utf-8', 'windows-1251', $str);

    $utf8win1251 = array("А" => "\xC0", "Б" => "\xC1", "В" => "\xC2", "Г" => "\xC3", "Д" => "\xC4", "Е" => "\xC5", "Ё" => "\xA8", "Ж" => "\xC6", "З" => "\xC7", "И" => "\xC8", "Й" => "\xC9", "К" => "\xCA", "Л" => "\xCB", "М" => "\xCC",
        "Н" => "\xCD", "О" => "\xCE", "П" => "\xCF", "Р" => "\xD0", "С" => "\xD1", "Т" => "\xD2", "У" => "\xD3", "Ф" => "\xD4", "Х" => "\xD5", "Ц" => "\xD6", "Ч" => "\xD7", "Ш" => "\xD8", "Щ" => "\xD9", "Ъ" => "\xDA",
        "Ы" => "\xDB", "Ь" => "\xDC", "Э" => "\xDD", "Ю" => "\xDE", "Я" => "\xDF", "а" => "\xE0", "б" => "\xE1", "в" => "\xE2", "г" => "\xE3", "д" => "\xE4", "е" => "\xE5", "ё" => "\xB8", "ж" => "\xE6", "з" => "\xE7",
        "и" => "\xE8", "й" => "\xE9", "к" => "\xEA", "л" => "\xEB", "м" => "\xEC", "н" => "\xED", "о" => "\xEE", "п" => "\xEF", "р" => "\xF0", "с" => "\xF1", "т" => "\xF2", "у" => "\xF3", "ф" => "\xF4", "х" => "\xF5",
        "ц" => "\xF6", "ч" => "\xF7", "ш" => "\xF8", "щ" => "\xF9", "ъ" => "\xFA", "ы" => "\xFB", "ь" => "\xFC", "э" => "\xFD", "ю" => "\xFE", "я" => "\xFF");

    return strtr($str, $utf8win1251);
} 
// ------------------ Функция перекодировки из WIN в UTF --------------------//
function win_to_utf($str) {
    if (function_exists('mb_convert_encoding')) return mb_convert_encoding($str, 'utf-8', 'windows-1251');
    if (function_exists('iconv')) return iconv('windows-1251', 'utf-8', $str);

    $win1251utf8 = array("\xC0" => "А", "\xC1" => "Б", "\xC2" => "В", "\xC3" => "Г", "\xC4" => "Д", "\xC5" => "Е", "\xA8" => "Ё", "\xC6" => "Ж", "\xC7" => "З", "\xC8" => "И", "\xC9" => "Й", "\xCA" => "К", "\xCB" => "Л", "\xCC" => "М",
        "\xCD" => "Н", "\xCE" => "О", "\xCF" => "П", "\xD0" => "Р", "\xD1" => "С", "\xD2" => "Т", "\xD3" => "У", "\xD4" => "Ф", "\xD5" => "Х", "\xD6" => "Ц", "\xD7" => "Ч", "\xD8" => "Ш", "\xD9" => "Щ", "\xDA" => "Ъ",
        "\xDB" => "Ы", "\xDC" => "Ь", "\xDD" => "Э", "\xDE" => "Ю", "\xDF" => "Я", "\xE0" => "а", "\xE1" => "б", "\xE2" => "в", "\xE3" => "г", "\xE4" => "д", "\xE5" => "е", "\xB8" => "ё", "\xE6" => "ж", "\xE7" => "з",
        "\xE8" => "и", "\xE9" => "й", "\xEA" => "к", "\xEB" => "л", "\xEC" => "м", "\xED" => "н", "\xEE" => "о", "\xEF" => "п", "\xF0" => "р", "\xF1" => "с", "\xF2" => "т", "\xF3" => "у", "\xF4" => "ф", "\xF5" => "х",
        "\xF6" => "ц", "\xF7" => "ч", "\xF8" => "ш", "\xF9" => "щ", "\xFA" => "ъ", "\xFB" => "ы", "\xFC" => "ь", "\xFD" => "э", "\xFE" => "ю", "\xFF" => "я");

    return strtr($str, $win1251utf8);
} 
// ------------------ Функция преобразования в нижний регистр для UTF ------------------//
function rus_utf_tolower($str) {
    if (function_exists('mb_strtolower')) return mb_strtolower($str, 'utf-8');

    $arraytolower = array('А' => 'а', 'Б' => 'б', 'В' => 'в', 'Г' => 'г', 'Д' => 'д', 'Е' => 'е', 'Ё' => 'ё', 'Ж' => 'ж', 'З' => 'з', 'И' => 'и', 'Й' => 'й', 'К' => 'к', 'Л' => 'л', 'М' => 'м', 'Н' => 'н', 'О' => 'о', 'П' => 'п', 'Р' => 'р', 'С' => 'с', 'Т' => 'т', 'У' => 'у', 'Ф' => 'ф', 'Х' => 'х', 'Ц' => 'ц', 'Ч' => 'ч', 'Ш' => 'ш', 'Щ' => 'щ', 'Ь' => 'ь', 'Ъ' => 'ъ', 'Ы' => 'ы', 'Э' => 'э', 'Ю' => 'ю', 'Я' => 'я',
        'A' => 'a', 'B' => 'b', 'C' => 'c', 'D' => 'd', 'E' => 'e', 'I' => 'i', 'F' => 'f', 'G' => 'g', 'H' => 'h', 'J' => 'j', 'K' => 'k', 'L' => 'l', 'M' => 'm', 'N' => 'n', 'O' => 'o', 'P' => 'p', 'Q' => 'q', 'R' => 'r', 'S' => 's', 'T' => 't', 'U' => 'u', 'V' => 'v', 'W' => 'w', 'X' => 'x', 'Y' => 'y', 'Z' => 'z');

    return strtr($str, $arraytolower);
} 
// ----------------------- Функция экранирования основных знаков --------------------------//
function check($msg) {
    if (is_array($msg)) {
        foreach($msg as $key => $val) {
            $msg[$key] = check($val);
        } 
    } else {
        $msg = htmlspecialchars($msg);
        $search = array('|', '\'', '$', '\\', '^', '%', '`', "\0", "\x00", "\x1A", "‮⁄⁪⁫⁬∩");
        $replace = array('&#124;', '&#39;', '&#36;', '&#92;', '&#94;', '&#37;', '&#96;', '', '', '', '');

        $msg = str_replace($search, $replace, $msg);
        $msg = stripslashes(trim($msg));
    } 

    return $msg;
} 
// ------------------ Функция определения браузера --------------------//
function GetUserAgent() {
    $agent = check($_SERVER['HTTP_USER_AGENT']);

    if (stripos($agent, 'Avant Browser') !== false) {
        return 'Avant Browser';
    } elseif (stripos($agent, 'Acoo Browser') !== false) {
        return 'Acoo Browser';
    } elseif (stripos($agent, 'MyIE2') !== false) {
        return 'MyIE2';
    } elseif (preg_match('|Iron/([0-9a-z\.]*)|i', $agent, $pocket)) {
        return 'SRWare Iron ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('|Chrome/([0-9a-z\.]*)|i', $agent, $pocket)) {
        return 'Chrome ' . subtok($pocket[1], '.', 0, 3);
    } elseif (preg_match('#(Maxthon|NetCaptor)( [0-9a-z\.]*)?#i', $agent, $pocket)) {
        return $pocket[1] . $pocket[2];
    } elseif (stripos($agent, 'Safari') !== false && preg_match('|Version/([0-9]{1,2}.[0-9]{1,2})|i', $agent, $pocket)) {
        return 'Safari ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('#(NetFront|K-Meleon|Netscape|Galeon|Epiphany|Konqueror|Safari|Opera Mini)/([0-9a-z\.]*)#i', $agent, $pocket)) {
        return $pocket[1] . ' ' . subtok($pocket[2], '.', 0, 2);
    } elseif (stripos($agent, 'Opera') !== false && preg_match('|Version/([0-9]{1,2}.[0-9]{1,2})|i', $agent, $pocket)) {
        return 'Opera ' . $pocket[1];
    } elseif (preg_match('|Opera[/ ]([0-9a-z\.]*)|i', $agent, $pocket)) {
        return 'Opera ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('|Orca/([ 0-9a-z\.]*)|i', $agent, $pocket)) {
        return 'Orca ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('#(SeaMonkey|Firefox|GranParadiso|Minefield|Shiretoko)/([0-9a-z\.]*)#i', $agent, $pocket)) {
        return $pocket[1] . ' ' . subtok($pocket[2], '.', 0, 3);
    } elseif (preg_match('|rv:([0-9a-z\.]*)|i', $agent, $pocket) && strpos($agent, 'Mozilla/') !== false) {
        return 'Mozilla ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('|Lynx/([0-9a-z\.]*)|i', $agent, $pocket)) {
        return 'Lynx ' . subtok($pocket[1], '.', 0, 2);
    } elseif (preg_match('|MSIE ([0-9a-z\.]*)|i', $agent, $pocket)) {
        return 'IE ' . subtok($pocket[1], '.', 0, 2);
    } else {
        $agent = preg_replace('|http://|i', '', $agent);
        $agent = strtok($agent, '( ');
        $agent = substr($agent, 0, 22);
        $agent = subtok($agent, '.', 0, 2);

        if (!empty($agent)) {
            return $agent;
        } 

        return 'Unknown';
    } 
} 
// ----------------------- Функция обрезки строки с условием -------------------------//
function subtok($string, $chr, $pos, $len = null) {
    return implode($chr, array_slice(explode($chr, $string), $pos, $len));
} 
// ----------------------- Функция вырезания переноса строки -------------------------//
function no_br($msg) {
    $msg = nl2br($msg);
    $msg = preg_replace('|[\r\n]+|si', '', $msg);
    return $msg;
} 
// ----------------------- Функция добавления переноса строки -------------------------//
function yes_br($msg) {
    $msg = preg_replace('|<br */?>|i', "\r\n", $msg);
    return $msg;
} 
// ------------------------ Функция замены и вывода смайлов --------------------------//
function smiles($str) {
    global $config;

    $querysmiles = DB :: $dbh -> query("SELECT `smiles_name`, `smiles_code` FROM `smiles` WHERE `smiles_cats`=? ORDER BY LENGTH(`smiles_code`) DESC;", array(1));
    $arrsmiles = $querysmiles -> fetchAll();

    $count = 0;
    foreach($arrsmiles as $val) {
        $str = preg_replace('|' . preg_quote($val['smiles_code']) . '|', '<img src="' . BASEDIR . 'images/smiles/' . $val['smiles_name'] . '" alt="smile" /> ', $str, $config['resmiles'] - $count, $cnt);
        $count += $cnt;
        if ($count >= $config['resmiles']) {
            break;
        } 
    } 

    if (is_admin(array(101, 102, 103, 105))) {
        $querysmiles = DB :: $dbh -> query("SELECT `smiles_name`, `smiles_code` FROM `smiles` WHERE `smiles_cats`=? ORDER BY LENGTH(`smiles_code`) DESC;", array(2));
        $arrsmiles = $querysmiles -> fetchAll();

        foreach($arrsmiles as $val) {
            $str = str_replace($val['smiles_code'], '<img src="' . BASEDIR . 'images/smiles2/' . $val['smiles_name'] . '" alt="smile" /> ', $str);
        } 
    } 

    return $str;
} 
// --------------- Функция обратной замены смайлов -------------------//
function nosmiles($string) {
    $string = preg_replace('|<img src="\.\./images/smiles/(.*?)\.gif" alt="smile" /> |', ':$1', $string);
    $string = preg_replace('|<img src="\.\./images/smiles2/(.*?)\.gif" alt="smile" /> |', ':$1', $string);
    return $string;
} 
// --------------- Функция правильного вывода веса файла -------------------//
function formatsize($file_size) {
    if ($file_size >= 1048576000) {
        $file_size = round(($file_size / 1073741824), 2) . " Gb";
    } elseif ($file_size >= 1024000) {
        $file_size = round(($file_size / 1048576), 2) . " Mb";
    } elseif ($file_size >= 1000) {
        $file_size = round(($file_size / 1024), 2) . " Kb";
    } else {
        $file_size = round($file_size) . " byte";
    } 
    return $file_size;
} 
// --------------- Функция форматированного вывода размера файла -------------------//
function read_file($file) {
    if (file_exists($file)) {
        return formatsize(filesize($file));
    } else {
        return 0;
    } 
} 
// --------------- Функция подсчета веса директории -------------------//
function read_dir($dir) {
    if (empty($allsize)) {
        $allsize = 0;
    } 

    if ($path = opendir($dir)) {
        while ($file_name = readdir($path)) {
            if (($file_name !== '.') && ($file_name !== '..')) {
                if (is_dir($dir . "/" . $file_name)) {
                    $allsize += read_dir($dir . "/" . $file_name);
                } else {
                    $allsize += filesize($dir . "/" . $file_name);
                } 
            } 
        } 
        closedir ($path);
    } 
    return $allsize;
} 
// --------------- Функция правильного вывода времени -------------------//
function formattime($file_time) {
    if ($file_time >= 86400) {
        $file_time = 'суток: ' . round((($file_time / 60) / 60) / 24, 1);
    } elseif ($file_time >= 3600) {
        $file_time = 'часов:  ' . round(($file_time / 60) / 60, 1);
    } elseif ($file_time >= 60) {
        $file_time = 'минут: ' . round($file_time / 60);
    } else {
        $file_time = 'секунд:  ' . round($file_time);
    } 
    return $file_time;
} 
// ------------------ Функция антимата --------------------//
function antimat($str) {
    $querymat = DB :: $dbh -> query("SELECT `mat_string` FROM `antimat` ORDER BY LENGTH(`mat_string`) DESC;");
    $arrmat = $querymat -> fetchAll();

    if (count($arrmat) > 0) {
        foreach($arrmat as $val) {
            $str = preg_replace('|' . preg_quote($val['mat_string']) . '|iu', '***', $str);
        } 
    } 

    return $str;
} 
// ------------------ Функция правильного должности юзера --------------------//
function user_status($level) {
    switch ($level) {
    case '101': $status = 'Суперадмин';
        break;
    case '102': $status = 'Админ';
        break;
    case '103': $status = 'Старший модер';
        break;
    case '105': $status = 'Модератор';
        break;
    default: $status = 'Пользователь';
    } 
    return $status;
} 
// ---------- Функция определение статуса юзера ---------//
function user_title($login) {
    static $arrstat;

    if (empty($arrstat)) {
        if (filemtime(DATADIR . "temp/status.dat") < time()-3600) {
            $querylevel = DB :: $dbh -> query("SELECT `users`.`users_login`, `users`.`users_status`, `status`.`status_name`, `status`.`status_color`
FROM `users`, `status` WHERE `users`.`users_point` BETWEEN `status`.`status_topoint` AND `status`.`status_point`;");

            $allstat = array();

            while ($row = $querylevel -> fetch()) {
                if (!empty($row['users_status'])) {
                    $allstat[$row['users_login']] = '<span style="color:#ff0000">' . $row['users_status'] . '</span>';
                    continue;
                } 

                if (!empty($row['status_color'])) {
                    $allstat[$row['users_login']] = '<span style="color:' . $row['status_color'] . '">' . $row['status_name'] . '</span>';
                    continue;
                } 

                $allstat[$row['users_login']] = $row['status_name'];
            } 

            file_put_contents(DATADIR . "temp/status.dat", serialize($allstat), LOCK_EX);
        } 

        $arrstat = unserialize(file_get_contents(DATADIR . "temp/status.dat"));
    } 

    if (isset($arrstat[$login])) {
        $status = $arrstat[$login];
    } else {
        $status = 'Дух';
    } 

    return $status;
} 
// ------------------ Функция выводящая картинку в загрузках --------------------//
function raiting_vote($str) {
    if (empty($str)) {
        $str = '<img src="../images/img/rating0.gif" alt="0" />';
    } 
    if ($str > '0' && $str <= '0.5') {
        $str = '<img src="' . BASEDIR . 'images/img/rating1.gif" alt="0.5" />';
    } 
    if ($str > '0.5' && $str <= '1') {
        $str = '<img src="' . BASEDIR . 'images/img/rating2.gif" alt="1" />';
    } 
    if ($str > '1' && $str <= '1.5') {
        $str = '<img src="' . BASEDIR . 'images/img/rating3.gif" alt="1.5" />';
    } 
    if ($str > '1.5' && $str <= '2') {
        $str = '<img src="' . BASEDIR . 'images/img/rating4.gif" alt="2" />';
    } 
    if ($str > '2' && $str <= '2.5') {
        $str = '<img src="' . BASEDIR . 'images/img/rating5.gif" alt="2.5" />';
    } 
    if ($str > '2.5' && $str <= '3') {
        $str = '<img src="' . BASEDIR . 'images/img/rating6.gif" alt="3" />';
    } 
    if ($str > '3' && $str <= '3.5') {
        $str = '<img src="' . BASEDIR . 'images/img/rating7.gif" alt="3.5" />';
    } 
    if ($str > '3.5' && $str <= '4') {
        $str = '<img src="' . BASEDIR . 'images/img/rating8.gif" alt="4" />';
    } 
    if ($str > '4' && $str <= '4.5') {
        $str = '<img src="' . BASEDIR . 'images/img/rating9.gif" alt="4.5" />';
    } 
    if ($str > '4.5' && $str <= '5') {
        $str = '<img src="' . BASEDIR . 'images/img/rating10.gif" alt="5" />';
    } 
    return $str;
} 
// --------------- Функция русского ника -------------------//
function nickname($login) {
    static $arrnick;

    if (empty($arrnick)) {
        if (filemtime(DATADIR . "temp/nickname.dat") < time()-1800) {
            save_nickname();
        } 

        $arrnick = unserialize(file_get_contents(DATADIR . "temp/nickname.dat"));
    } 

    if (isset($arrnick[$login])) {
        $login = $arrnick[$login];
    } 

    return $login;
} 
// --------------- Функция кэширования настроек -------------------//
function save_setting() {
    $queryset = DB :: $dbh -> query("SELECT `setting_name`, `setting_value` FROM `setting`;");
    $config = $queryset -> fetchAssoc();
    file_put_contents(DATADIR . "temp/setting.dat", serialize($config), LOCK_EX);
} 
// --------------- Функция кэширования навигации -------------------//
function save_navigation() {
    $querynav = DB :: $dbh -> query("SELECT `nav_url`, `nav_title` FROM `navigation` ORDER BY `nav_order` ASC;");
    $arrnav = $querynav -> fetchAll();
    file_put_contents(DATADIR . "temp/navigation.dat", serialize($arrnav), LOCK_EX);
} 
// --------------- Функция кэширования аватаров -------------------//
function save_avatar() {
    $queryavat = DB :: $dbh -> query("SELECT `users_login`, `users_avatar` FROM `users`;");
    $allavat = $queryavat -> fetchAssoc();
    file_put_contents(DATADIR . "temp/avatar.dat", serialize($allavat), LOCK_EX);
} 
// --------------- Функция кэширования ников -------------------//
function save_nickname() {
    $querynick = DB :: $dbh -> query("SELECT `users_login`, `users_nickname` FROM `users` WHERE `users_nickname`<>?;", array(''));
    $allnick = $querynick -> fetchAssoc();
    file_put_contents(DATADIR . "temp/nickname.dat", serialize($allnick), LOCK_EX);
} 
// ------------------------- Функция карантина ------------------------------//
function is_quarantine($log) {
    global $config;

    if (!empty($config['karantin'])) {
        $queryuser = DB :: $dbh -> querySingle("SELECT `users_joined` FROM users WHERE `users_login`=? LIMIT 1;", array($log));

        if ($queryuser + $config['karantin'] > SITETIME) {
            return false;
        } 
    } 
    return true;
} 
// ------------------------- Функция времени антифлуда ------------------------------//
function flood_period() {
    global $config, $udata;

    $period = $config['floodstime'];

    if ($udata['users_point'] >= 500) {
        $period = round($config['floodstime'] / 2);
    } 
    if ($udata['users_point'] >= 1000) {
        $period = round($config['floodstime'] / 3);
    } 
    if ($udata['users_point'] >= 5000) {
        $period = round($config['floodstime'] / 6);
    } 
    if (is_admin(array(101, 102, 103, 105))) {
        $period = 0;
    } 

    return $period;
} 
// ------------------------- Функция антифлуда ------------------------------//
function is_flood($log, $period = "") {
    global $php_self;

    if (empty($period)) {
        $period = flood_period();
    } 
    if (empty($period)) {
        return true;
    } 

    DB :: $dbh -> query("DELETE FROM `flood` WHERE `flood_time`<?;", array(SITETIME));

    $queryflood = DB :: $dbh -> querySingle("SELECT `flood_id` FROM `flood` WHERE `flood_user`=? AND `flood_page`=? LIMIT 1;", array($log, $php_self));

    if (empty($queryflood)) {
        DB :: $dbh -> query("INSERT INTO `flood` (`flood_user`, `flood_page`, `flood_time`) VALUES (?, ?, ?);", array($log, $php_self, SITETIME + $period));

        return true;
    } else {
        return false;
    } 
} 
// ------------------ Функция для обработки base64 --------------------//
function safe_encode($string) {
    $data = base64_encode($string);
    $data = str_replace(array('+', '/', '='), array('_', '-', ''), $data);
    return $data;
} 

function safe_decode($string) {
    $string = str_replace(array('_', '-'), array('+', '/'), $string);
    $data = base64_decode($string);
    return $data;
} 
// ------------------ Функция шифрования по ключу --------------------//
function xoft_encode($string, $key) {
    $result = "";
    for($i = 1; $i <= strlen($string); $i++) {
        $char = substr($string, $i-1, 1);
        $keychar = substr($key, ($i % strlen($key)) - 1, 1);
        $char = chr(ord($char) + ord($keychar));
        $result .= $char;
    } 
    return safe_encode($result);
} 
// ------------------ Функция расшифровки по ключу --------------------//
function xoft_decode($string, $key) {
    $string = safe_decode($string);
    $result = "";
    for($i = 1; $i <= strlen($string); $i++) {
        $char = substr($string, $i - 1, 1);
        $keychar = substr($key, ($i % strlen($key)) - 1, 1);
        $char = chr(ord($char) - ord($keychar));
        $result .= $char;
    } 
    return $result;
} 
// ------------------ Функция генерирования паролей --------------------//
function generate_password($length = "") {
    if (empty($length)) {
        $length = mt_rand(10, 12);
    } 
    $salt = str_split('aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ0123456789');

    $makepass = "";
    for ($i = 0; $i < $length; $i++) {
        $makepass .= $salt[array_rand($salt)];
    } 
    return $makepass;
} 
// ------------------ Функция для читаемого вывода массива --------------------//
function text_dump($var, $level = 0) {
    if (is_array($var)) $type = "array[" . count($var) . "]";
    else if (is_object($var)) $type = "object";
    else $type = "";
    if ($type) {
        echo $type . '<br />';
        for(Reset($var), $level++; list($k, $v) = each($var);) {
            if (is_array($v) && $k === "GLOBALS") continue;
            for($i = 0; $i < $level * 3; $i++) echo ' ';
            echo '<b>' . htmlspecialchars($k) . '</b> => ', text_dump($v, $level);
        } 
    } else echo '"', htmlspecialchars($var), '"<br />';
} 

function dump($var) {
    if ((is_array($var) || is_object($var)) && count($var)) {
        echo '<pre>', text_dump($var), '</pre>';
    } else {
        echo '<tt>', text_dump($var), '</tt>';
    } 
} 
// --------------- Функция листинга всех файлов и папок ---------------//
function scan_check($dirname) {
    global $arr, $config;

    if (empty($arr['files'])) {
        $arr['files'] = array();
    } 
    if (empty($arr['totalfiles'])) {
        $arr['totalfiles'] = 0;
    } 
    if (empty($arr['totaldirs'])) {
        $arr['totaldirs'] = 0;
    } 

    $no_check = explode(',', $config['nocheck']);

    $dirs = array_diff(scandir($dirname), array(".", ".."));

    foreach ($dirs as $file) {
        if (is_file($dirname . '/' . $file)) {
            $ext = strtolower(substr($file, strrpos($file, '.') + 1));

            if (!in_array($ext, $no_check)) {
                $arr['files'][] = $dirname . '/' . $file . ' - ' . date_fixed(filemtime($dirname . '/' . $file), 'j.m.Y / H:i') . ' - ' . read_file($dirname . '/' . $file);
                $arr['totalfiles']++;
            } 
        } 

        if (is_dir($dirname . '/' . $file)) {
            $arr['files'][] = $dirname . '/' . $file;
            $arr['totaldirs']++;
            scan_check($dirname . '/' . $file);
        } 
    } 

    return $arr;
} 
// --------------- Функция вывода календаря---------------//
function makeCal ($month, $year) {
    $wday = date("w", mktime(0, 0, 0, $month, 1, $year));
    if ($wday == 0) {
        $wday = 7;
    } 
    $n = - ($wday-2);
    $cal = array();
    for ($y = 0; $y < 6; $y++) {
        $row = array();
        $notEmpty = false;
        for ($x = 0; $x < 7; $x++, $n++) {
            if (checkdate($month, $n, $year)) {
                $row[] = $n;
                $notEmpty = true;
            } else {
                $row[] = "";
            } 
        } 
        if (!$notEmpty) break;
        $cal[] = $row;
    } 
    return $cal;
} 
// --------------- Функция подсчета рекламных ссылок ---------------//
function user_advert($login) {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `reklama` WHERE `rek_user`=?;", array($login));
} 
// --------------- Функция подсчета денег у юзера ---------------//
function user_money($login) {
    $queryuser = DB :: $dbh -> querySingle("SELECT `users_money` FROM `users` WHERE `users_login`=? LIMIT 1;", array($login));
    if (!empty($queryuser)) {
        $user_sum = $queryuser;
    } else {
        $user_sum = 0;
    } 

    $querybank = DB :: $dbh -> querySingle("SELECT `bank_sum` FROM `bank` WHERE `bank_user`=? LIMIT 1;", array($login));
    if (!empty($querybank)) {
        $bank_sum = $querybank;
    } else {
        $bank_sum = 0;
    } 

    return $user_sum . '/' . $bank_sum;
} 
// --------------- Функция подсчета денег в банке ---------------//
function user_bankmoney($login) {
    $querybank = DB :: $dbh -> querySingle("SELECT `bank_sum` FROM `bank` WHERE `bank_user`=? LIMIT 1;", array($login));
    if (!empty($querybank)) {
        $bank_sum = $querybank;
    } else {
        $bank_sum = 0;
    } 

    return $bank_sum;
} 
// --------------- Функция подсчета писем у юзера ---------------//
function user_mail($login) {
    $all_privat = DB :: $dbh -> querySingle("SELECT count(*) FROM `inbox` WHERE `inbox_user`=?;", array($login));
    $new_privat = DB :: $dbh -> querySingle("SELECT `users_newprivat` FROM `users` WHERE `users_login`=? LIMIT 1;", array($login));

    return $new_privat . '/' . $all_privat;
} 
// --------------- Функция вывода аватара пользователя ---------------//
function user_avatars($login) {
    global $config;
    static $arravat;

    if ($login == $config['guestsuser']) {
        return '<img src="' . BASEDIR . 'images/avatars/guest.gif" alt="" /> ';
    } 

    if (empty($arravat)) {
        if (filemtime(DATADIR . "temp/avatar.dat") < time()-3600) {
            save_avatar();
        } 

        $arravat = unserialize(file_get_contents(DATADIR . "temp/avatar.dat"));
    } 

    if (isset($arravat[$login]) && file_exists(BASEDIR . $arravat[$login])) {
        return '<img src="' . BASEDIR . $arravat[$login] . '" alt="" /> ';
    } 

    return '<img src="' . BASEDIR . 'images/avatars/noavatar.gif" alt="" /> ';
} 
// --------------- Функция подсчета карт в игре ---------------//
function cards_score($str) {
    if ($str > 32) return 11;
    if ($str > 20) return (int)(($str-1) / 4)-3;
    return (int)(($str-1) / 4) + 6;
} 
// --------------- Функция подсчета очков в игре ---------------//
function cards_points($str) {
    $str = (int)$str;

    $str1 = abs($str) % 100;
    $str2 = $str % 10;

    if ($str1 == 21) return $str . ' <b>очко!!!</b>';
    if ($str1 > 10 && $str1 < 20) return $str . ' очков';
    if ($str2 > 1 && $str2 < 5) return $str . ' очка';
    if ($str2 == 1) return $str . ' очко';

    return $str . ' очков';
} 
// --------------- Функция подсчета человек в контакт-листе ---------------//
function user_kontakt($login) {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `contact` WHERE `contact_user`=?;", array($login));
} 
// --------------- Функция подсчета человек в игнор-листе ---------------//
function user_ignore($login) {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `ignore` WHERE `ignore_user`=?;", array($login));
} 
// ------------------ Функция подсчета пользователей онлайн -----------------//
function stats_online() {
    if (filemtime(DATADIR . "temp/online.dat") < time()-10) {
        $queryonline = DB :: $dbh -> query("SELECT count(*) FROM `online` WHERE `online_user`<>? UNION ALL SELECT count(*) FROM `online`;", array(''));
        $online = $queryonline -> fetchAll(PDO :: FETCH_COLUMN);

        file_put_contents(DATADIR . "temp/online.dat", serialize($online), LOCK_EX);
    } 

    return unserialize(file_get_contents(DATADIR . "temp/online.dat"));
} 
// ------------------ Функция подсчета посещений -----------------//
function stats_counter() {
    if (filemtime(DATADIR . "temp/counter.dat") < time()-10) {
        $querycount = DB :: $dbh -> query("SELECT * FROM `counter`;");
        $counts = $querycount -> fetch();

        file_put_contents(DATADIR . "temp/counter.dat", serialize($counts), LOCK_EX);
    } 

    return unserialize(file_get_contents(DATADIR . "temp/counter.dat"));
} 
// --------------- Функция вывода количества зарегистрированных ---------------//
function stats_users() {
    if (filemtime(DATADIR . "temp/statusers.dat") < time()-3600) {
        $total = DB :: $dbh -> querySingle("SELECT count(*) FROM `users`;");
        $new = DB :: $dbh -> querySingle("SELECT count(*) FROM `users` WHERE `users_joined`>UNIX_TIMESTAMP(CURDATE());");

        if (empty($new)) {
            $stat = $total;
        } else {
            $stat = $total . '/+' . $new;
        } 

        file_put_contents(DATADIR . "temp/statusers.dat", $stat, LOCK_EX);
    } 

    return file_get_contents(DATADIR . "temp/statusers.dat");
} 
// --------------- Функция вывода количества админов и модеров --------------------//
function stats_admins() {
    if (filemtime(DATADIR . "temp/statadmins.dat") < time()-1800) {
        $stat = DB :: $dbh -> querySingle("SELECT count(*) FROM `users` WHERE `users_level`>=? AND `users_level`<=?;", array(101, 105));

        file_put_contents(DATADIR . "temp/statadmins.dat", $stat, LOCK_EX);
    } 

    return file_get_contents(DATADIR . "temp/statadmins.dat");
} 
// --------------- Функция вывода количества жалоб --------------------//
function stats_spam() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `spam`;");
} 
// --------------- Функция вывода количества забаненных --------------------//
function stats_banned() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `users` WHERE `users_ban`=? AND `users_timeban`>?;", array(1, SITETIME));
} 
// ------------ Функция вывода количества ожидающих регистрации -----------//
function stats_reglist() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `users` WHERE `users_confirmreg`>?;", array(0));
} 
// --------------- Функция вывода количества забаненных IP --------------------//
function stats_ipbanned() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `ban`;");
} 
// --------------- Функция вывода количества фотографий --------------------//
function stats_gallery() {
    if (filemtime(DATADIR . "temp/statgallery.dat") < time()-900) {
        $total = DB :: $dbh -> querySingle("SELECT count(*) FROM `photo`;");
        $totalnew = DB :: $dbh -> querySingle("SELECT count(*) FROM `photo` WHERE `photo_time`>?;", array(SITETIME-86400 * 3));

        if (empty($totalnew)) {
            $stat = $total;
        } else {
            $stat = $total . '/+' . $totalnew;
        } 

        file_put_contents(DATADIR . "temp/statgallery.dat", $stat, LOCK_EX);
    } 

    return file_get_contents(DATADIR . "temp/statgallery.dat");
} 
// --------------- Функция вывода количества новостей--------------------//
function stats_allnews() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `news`;");
} 
// ---------- Функция вывода количества запрещенных логинов ------------//
function stats_blacklogin() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `blacklogin`;");
} 
// ------------ Функция вывода количества запрещенных e-mail------------//
function stats_blackmail() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `blackmail`;");
} 
// --------------- Функция вывода количества заголовков ----------------//
function stats_headlines() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `headers`;");
} 
// --------------- Функция вывода количества заголовков ----------------//
function stats_navigation() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `navigation`;");
} 
// --------------- Функция вывода количества заголовков ----------------//
function stats_antimat() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `antimat`;");
} 
// ----------- Функция вывода даты последнего сканирования -------------//
function stats_checker() {
    if (file_exists(DATADIR . "temp/checker.dat")) {
        return date_fixed(filemtime(DATADIR . "temp/checker.dat"), "j.m.y");
    } else {
        return 0;
    } 
} 
// --------------- Функция вывода количества рекламы ----------------//
function stats_advert() {
    return DB :: $dbh -> querySingle("SELECT count(*) FROM `reklama`;");
} 
// ----------------- Функция определения местонахождения -----------------//
function user_position($url) {
    $position = 'Не определено';

    $queryhead = DB :: $dbh -> querySingle("SELECT `head_title` FROM `headers` WHERE `head_url`=? LIMIT 1;", array($url));
    if (!empty($queryhead)) {
        $position = '<a href="' . BASEDIR . $url . '?' . SID . '">' . $queryhead . '</a>';
    } 

    return $position;
} 
// --------------- Функция автоустановки прав доступа ---------------//
function chmode ($path = ".") {
    if ($handle = opendir ($path)) {
        while (false !== ($file = readdir($handle))) {
            if ($file != "." && $file != "..") {
                $file_path = $path . "/" . $file;

                if (is_dir ($file_path)) {
                    $old = umask(0);
                    chmod ($file_path, 0777);
                    umask($old);

                    chmode ($file_path);
                } else {
                    chmod ($file_path, 0666);
                } 
            } 
        } 

        closedir($handle);
    } 
} 
function mc($str) {
    global $config;
    if (empty($config['rotorlicense'])) {
        return preg_replace('#</body>#i',
            '<div style="text-align:center"><a href="http://' . str_rot13('ivfniv.arg') . '">' . str_rot13('Cbjrerq ol EbgbePZF') . '</a></div></body>',
            $str, 1);
    } else {
        return $str;
    } 
} 
// --------------- Функция определение онлайн-статуса ---------------//
function user_online($login) {
    static $arrvisit;

    $statwho = '<span style="color:#ff0000">[Off]</span>';

    if (empty($arrvisit)) {
        if (filemtime(DATADIR . "temp/visit.dat") < time()-10) {
            $queryvisit = DB :: $dbh -> query("SELECT `visit_user` FROM `visit` WHERE `visit_nowtime`>?;", array(SITETIME-600));
            $allvisits = $queryvisit -> fetchAll(PDO :: FETCH_COLUMN);
            file_put_contents(DATADIR . "temp/visit.dat", serialize($allvisits), LOCK_EX);
        } 

        $arrvisit = unserialize(file_get_contents(DATADIR . "temp/visit.dat"));
    } 

    if (in_array($login, $arrvisit)) {
        $statwho = '<span style="color:#00cc00">[On]</span>';
    } 

    return $statwho;
} 
// --------------- Функция вывода пользователей онлайн ---------------//
function allonline() {
    if (filemtime(DATADIR . "temp/allonline.dat") < time()-180) {
        $queryvisit = DB :: $dbh -> query("SELECT `visit_user` FROM `visit` WHERE `visit_nowtime`>? ORDER BY `visit_nowtime` DESC;", array(SITETIME-600));
        $allvisits = $queryvisit -> fetchAll(PDO :: FETCH_COLUMN);
        file_put_contents(DATADIR . "temp/allonline.dat", serialize($allvisits), LOCK_EX);
    } 

    return unserialize(file_get_contents(DATADIR . "temp/allonline.dat"));
} 
// ------------------ Функция определение последнего посещения ----------------//
function user_visit($login) {
    $visit = '(Оффлайн)';

    $queryvisit = DB :: $dbh -> querySingle("SELECT `visit_nowtime` FROM `visit` WHERE `visit_user`=? LIMIT 1;", array($login));
    if (!empty($queryvisit)) {
        if ($queryvisit > SITETIME-600) {
            $visit = '(Сейчас на сайте)';
        } else {
            $visit = '(Последний визит: ' . date_fixed($queryvisit) . ')';
        } 
    } 

    return $visit;
} 
// --------------- Функции сжатия страниц ---------------//
function compress_output_gzip($output) {
    return gzencode($output, 5);
} 

function compress_output_deflate($output) {
    return gzdeflate($output, 5);
} 
// ---------- Функция обработки строк данных и ссылок ---------//
function check_string($string) {
    $string = strtolower($string);
    $string = str_replace(array('http://www.', 'http://wap.', 'http://', 'https://'), '', $string);
    $string = strtok($string, '/?');
    return $string;
} 
// ---------- Аналог функции substr для UTF-8 ---------//
function utf_substr($str, $offset, $length = null) {
    if (function_exists('mb_substr')) return mb_substr($str, $offset, $length, 'utf-8');
    if (function_exists('iconv_substr')) return iconv_substr($str, $offset, $length, 'utf-8');

    $str = utf_to_win($str);
    $str = substr($str, $offset, $length);
    return win_to_utf($str);
} 
// ---------------------- Аналог функции strlen для UTF-8 -----------------------//
function utf_strlen($str) {
    if (function_exists('mb_strlen')) return mb_strlen($str, 'utf-8');
    if (function_exists('iconv_strlen')) return iconv_strlen($str, 'utf-8');
    if (function_exists('utf8_decode')) return strlen(utf8_decode($str));
    return strlen(utf_to_win($str));
} 
// ---------- Аналог функции wordwrap для UTF-8 ---------//
function utf_wordwrap($str, $width = 75, $break = ' ', $cut = 1) {
    $str = utf_to_win($str);
    $str = wordwrap($str, $width, $break, $cut);
    return win_to_utf($str);
} 
// ----------------------- Функция определения кодировки ------------------------//
function is_utf($str) {
    $c = 0;
    $b = 0;
    $bits = 0;
    $len = strlen($str);
    for($i = 0; $i < $len; $i++) {
        $c = ord($str[$i]);
        if ($c > 128) {
            if (($c >= 254)) return false;
            elseif ($c >= 252) $bits = 6;
            elseif ($c >= 248) $bits = 5;
            elseif ($c >= 240) $bits = 4;
            elseif ($c >= 224) $bits = 3;
            elseif ($c >= 192) $bits = 2;
            else return false;
            if (($i + $bits) > $len) return false;
            while ($bits > 1) {
                $i++;
                $b = ord($str[$i]);
                if ($b < 128 || $b > 191) return false;
                $bits--;
            } 
        } 
    } 
    return true;
} 
// ----------------------- Функция отправки письма по e-mail ------------------------//
function addmail($usermail, $subject, $msg, $mail = "", $name = "") {
    global $config;

    if ($mail == "") {
        $mail = $config['emails'];
        $name = $config['nickname'];
    } 

    $subject = utf_to_win($subject);
    $msg = utf_to_win($msg);
    $name = utf_to_win($name);

    $subject = convert_cyr_string($subject, 'w', 'k');
    $msg = convert_cyr_string($msg, 'w', 'k');
    $name = convert_cyr_string($name, 'w', 'k');

    $subject = '=?KOI8-R?B?' . base64_encode($subject) . '?=';

    $adds = "From: " . $name . " <" . $mail . ">\n";
    $adds .= "X-sender: " . $name . " <" . $mail . ">\n";
    $adds .= "Content-Type: text/plain; charset=koi8-r\n";
    $adds .= "MIME-Version: 1.0\n";
    $adds .= "Content-Transfer-Encoding: 8bit\n";
    $adds .= "X-Mailer: PHP v." . phpversion();

    return mail($usermail, $subject, $msg, $adds);
} 
// ----------------------- Постраничная навигация (Переходы) ------------------------//
function page_jumpnavigation($link, $posts, $start, $total) {
    /**
     * echo '<hr />'; 
     * if ($start != 0) {echo '<a href="'.$link.'start='.($start - $posts).'&amp;'.SID.'">&lt;-Назад</a> ';}else{echo '&lt;-Назад';}
     * echo ' | '; 
     * if ($total > $start + $posts) {echo '<a href="'.$link.'start='.($start + $posts).'&amp;'.SID.'">Далее-&gt;</a>';}else{echo 'Далее-&gt;';}
     */

} 
// ----------------------- Постраничная навигация (Страницы) ------------------------//
function page_strnavigation($link, $posts, $start, $total, $koll = 4) {
    if ($total > 0) {
        echo '<hr /><div class="nav">Страницы: ';
        if ($start != 0) {
            echo '<a href="' . $link . 'start=' . ($start - $posts) . '&amp;' . SID . '" title="Назад">&laquo;</a> ';
        } 

        $ba = ceil($total / $posts);
        $ba2 = $ba * $posts - $posts;

        $min = $start - $posts * ($koll - 1);
        $max = $start + $posts * $koll;

        if ($min < $total && $min > 0) {
            if ($min - $posts > 0) {
                echo '<a href="' . $link . 'start=0&amp;' . SID . '">1</a> ... ';
            } else {
                echo '<a href="' . $link . 'start=0&amp;' . SID . '">1</a> ';
            } 
        } 

        for($i = $min; $i < $max;) {
            if ($i < $total && $i >= 0) {
                $ii = floor(1 + $i / $posts);

                if ($start == $i) {
                    echo ' <span class="navcurrent">' . $ii . '</span> ';
                } else {
                    echo ' <a href="' . $link . 'start=' . $i . '&amp;' . SID . '">' . $ii . '</a> ';
                } 
            } 

            $i += $posts;
        } 

        if ($max < $total) {
            if ($max + $posts < $total) {
                echo ' ... <a href="' . $link . 'start=' . $ba2 . '&amp;' . SID . '">' . $ba . '</a>';
            } else {
                echo ' <a href="' . $link . 'start=' . $ba2 . '&amp;' . SID . '">' . $ba . '</a>';
            } 
        } 

        if ($total > $start + $posts) {
            echo ' <a href="' . $link . 'start=' . ($start + $posts) . '&amp;' . SID . '" title="Вперед">&raquo;</a>';
        } 

        echo '</div><br />';
    } 
} 
// ----------------------- Вывод страниц в форуме ------------------------//
function forum_navigation($link, $posts, $total) {
    if ($total > 0) {
        $ba = ceil($total / $posts);
        $ba2 = $ba * $posts - $posts;
        $max = $posts * 5;

        for($i = 0; $i < $max;) {
            if ($i < $total && $i >= 0) {
                $ii = floor(1 + $i / $posts);
                echo ' <a href="' . $link . 'start=' . $i . '&amp;' . SID . '">' . $ii . '</a> ';
            } 

            $i += $posts;
        } 

        if ($max < $total) {
            if ($max + $posts < $total) {
                echo ' ... <a href="' . $link . 'start=' . $ba2 . '&amp;' . SID . '">' . $ba . '</a>';
            } else {
                echo ' <a href="' . $link . 'start=' . $ba2 . '&amp;' . SID . '">' . $ba . '</a>';
            } 
        } 

        echo '<br />';
    } 
} 
// --------------------- Функция вывода статистики блогов ------------------------//
function stats_blog() {
    if (filemtime(DATADIR . "temp/statblog.dat") < time()-900) {
        $totalblog = DB :: $dbh -> querySingle("SELECT SUM(`cats_count`) FROM `catsblog`;");
        $totalnew = DB :: $dbh -> querySingle("SELECT count(*) FROM `blogs` WHERE `blogs_time`>?;", array(SITETIME-86400 * 3));

        if (empty($totalnew)) {
            $stat = (int)$totalblog;
        } else {
            $stat = $totalblog . '/+' . $totalnew;
        } 

        file_put_contents(DATADIR . "temp/statblog.dat", $stat, LOCK_EX);
    } 

    return file_get_contents(DATADIR . "temp/statblog.dat");
} 
// --------------------- Функция вывода статистики форума ------------------------//
function stats_forum() {
    if (filemtime(DATADIR . "temp/statforum.dat") < time()-600) {
        $queryforum = DB :: $dbh -> query("SELECT SUM(`forums_topics`) FROM `forums` UNION ALL SELECT SUM(`forums_posts`) FROM `forums`;");
        $total = $queryforum -> fetchAll(PDO :: FETCH_COLUMN);

        file_put_contents(DATADIR . "temp/statforum.dat", (int)$total[0] . '/' . (int)$total[1], LOCK_EX);
    } 

    return file_get_contents(DATADIR . "temp/statforum.dat");
} 
// --------------------- Функция вывода статистики гостевой ------------------------//
function stats_guest() {
    if (filemtime(DATADIR . "temp/statguest.dat") < time()-600) {
        global $config;
        $total = DB :: $dbh -> querySingle("SELECT count(*) FROM `guest`;");

        if ($total > ($config['maxpostbook']-10)) {
            $stat = DB :: $dbh -> querySingle("SELECT MAX(`guest_id`) FROM `guest`;");
        } else {
            $stat = $total;
        } 

        file_put_contents(DATADIR . "temp/statguest.dat", (int)$stat, LOCK_EX);
    } 

    return file_get_contents(DATADIR . "temp/statguest.dat");
} 
// -------------------- Функция вывода статистики админ-чата -----------------------//
function stats_chat() {
    global $config;

    $total = DB :: $dbh -> querySingle("SELECT count(*) FROM `chat`;");

    if ($total > ($config['chatpost']-10)) {
        return DB :: $dbh -> querySingle("SELECT MAX(`chat_id`) FROM `chat`;");
    } else {
        return $total;
    } 
} 
// --------------------- Функция вывода статистики загрузок ------------------------//
function stats_load() {
    if (filemtime(DATADIR . "temp/statload.dat") < time()-900) {
        $totalloads = DB :: $dbh -> querySingle("SELECT SUM(`cats_count`) FROM `cats`;");
        $totalnew = DB :: $dbh -> querySingle("SELECT count(*) FROM `downs` WHERE `downs_time`>?;", array(SITETIME-86400 * 5));

        if (empty($totalnew)) {
            $stat = $totalloads;
        } else {
            $stat = $totalloads . '/+' . $totalnew;
        } 
        file_put_contents(DATADIR . "temp/statload.dat", $stat, LOCK_EX);
    } 

    return file_get_contents(DATADIR . "temp/statload.dat");
} 
// --------------------- Функция шифровки Email-адреса ------------------------//
function crypt_mail($mail) {
    $output = "";
    $strlen = strlen($mail);
    for ($i = 0; $i < $strlen; $i++) {
        $output .= '&#' . ord($mail[$i]) . ';';
    } 
    return $output;
} 
// ------------------- Функция обработки массива (int) --------------------//
function intar($string) {
    if (is_array($string)) {
        $newstring = array_map('intval', $string);
    } else {
        $newstring = (int)$string;
    } 

    return $newstring;
} 
// ------------------- Функция подсчета голосований --------------------//
function stats_votes() {
    if (filemtime(DATADIR . "temp/statvote.dat") < time()-900) {
        $totalvote = DB :: $dbh -> query("SELECT count(*) AS `count`, SUM(`vote_count`) AS `sum` FROM `vote` WHERE `vote_closed`=?;", array(0));
        $data = $totalvote -> fetch();

        if (empty($data['sum'])) {
            $data['sum'] = 0;
        } 

        file_put_contents(DATADIR . "temp/statvote.dat", $data['count'] . '/' . $data['sum'], LOCK_EX);
    } 

    return file_get_contents(DATADIR . "temp/statvote.dat");
} 
// ------------------- Функция показа даты последней новости --------------------//
function stats_news() {
    if (filemtime(DATADIR . "temp/statnews.dat") < time()-900) {
        $stat = 0;

        $querynews = DB :: $dbh -> query("SELECT `news_time` FROM `news` ORDER BY `news_id` DESC LIMIT 1;");
        $data = $querynews -> fetch();

        if ($data > 0) {
            $stat = date_fixed($data['news_time'], "d.m.y");
            if ($stat == 'Сегодня') {
                $stat = '<span style="color:#ff0000">Сегодня</span>';
            } 
        } 

        file_put_contents(DATADIR . "temp/statnews.dat", $stat, LOCK_EX);
    } 

    return file_get_contents(DATADIR . "temp/statnews.dat");
} 
// ------------------- Функция вывода последних новостей --------------------//
function last_news() {
    global $config;

    if ($config['lastnews'] > 0) {
        $total = DB :: $dbh -> querySingle("SELECT count(*) FROM `news`;");

        if ($total > 0) {
            $querynews = DB :: $dbh -> query("SELECT * FROM `news` ORDER BY `news_id` DESC LIMIT " . $config['lastnews'] . ";");

            while ($data = $querynews -> fetch()) {
                echo '<br /><img src="' . BASEDIR . 'images/img/news.gif" alt="Новость" /> ';
                echo '<b>' . $data['news_title'] . '</b><br />';
                echo bb_code($data['news_text']) . '<br />';
                echo '<a href="' . BASEDIR . 'news/index.php?act=comments&amp;id=' . $data['news_id'] . '&amp;' . SID . '">Комментарии</a> (' . $data['news_comments'] . ')';
            } 
        } 
    } 
} 
// ------------------- Функция присоединения идентификатора --------------------//
function verifi($link) {
    if (strpos($link, '?') === false) {
        return $link . '?' . SID;
    } else {
        return $link . '&' . SID;
    } 
} 
// ------------------------- Функция вывода пользовательских тегов ------------------------//
function quickcode() {
    echo 'BB-код<br />';
    echo '<a href="#form" onclick="javascript:tag(\'[url=]\', \'[/url]\');"><img src="' . BASEDIR . 'images/editor/a.gif" alt="url" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[b]\', \'[/b]\');"><img src="' . BASEDIR . 'images/editor/b.gif" alt="b" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[big]\', \'[/big]\');"><img src="' . BASEDIR . 'images/editor/big.gif" alt="big" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[small]\', \'[/small]\');"><img src="' . BASEDIR . 'images/editor/small.gif" alt="small" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[i]\', \'[/i]\');"><img src="' . BASEDIR . 'images/editor/i.gif" alt="i" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[u]\', \'[/u]\');"><img src="' . BASEDIR . 'images/editor/u.gif" alt="u" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[q]\', \'[/q]\');"><img src="' . BASEDIR . 'images/editor/q.gif" alt="q" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[del]\', \'[/del]\');"><img src="' . BASEDIR . 'images/editor/del.gif" alt="del" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[hide]\', \'[/hide]\');"><img src="' . BASEDIR . 'images/editor/hide.gif" alt="hide" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[code]\', \'[/code]\');"><img src="' . BASEDIR . 'images/editor/code.gif" alt="code" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[red]\', \'[/red]\');"><img src="' . BASEDIR . 'images/editor/red.gif" alt="red" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[green]\', \'[/green]\');"><img src="' . BASEDIR . 'images/editor/green.gif" alt="green" /></a>';
    echo '<a href="#form" onclick="javascript:tag(\'[blue]\', \'[/blue]\');"><img src="' . BASEDIR . 'images/editor/blue.gif" alt="blue" /></a>';
    echo '<br />';
} 
// ------------------------- Функция вывода быстрых смайлов ------------------------//
function quicksmiles() {
    echo 'Смайлы<br />';
    echo '<a href="#form" onclick="javascript:tag(\' :) \', \'\');"><img src="' . BASEDIR . 'images/smiles/).gif" alt=":)" /></a> ';
    echo '<a href="#form" onclick="javascript:tag(\' :( \', \'\');"><img src="' . BASEDIR . 'images/smiles/(.gif" alt=":(" /></a> ';
    echo '<a href="#form" onclick="javascript:tag(\' :E \', \'\');"><img src="' . BASEDIR . 'images/smiles/E.gif" alt=":E" /></a> ';
    echo '<a href="#form" onclick="javascript:tag(\' :hello \', \'\');"><img src="' . BASEDIR . 'images/smiles/hello.gif" alt="hello" /></a> ';
    echo '<a href="#form" onclick="javascript:tag(\' :cry \', \'\');"><img src="' . BASEDIR . 'images/smiles/cry.gif" alt="cry" /></a> ';
    echo '<a href="#form" onclick="javascript:tag(\' :obana \', \'\');"><img src="' . BASEDIR . 'images/smiles/obana.gif" alt="obana" /></a> ';
    echo '<a href="#form" onclick="javascript:tag(\' :infat \', \'\');"><img src="' . BASEDIR . 'images/smiles/infat.gif" alt="infat" /></a> ';
    echo '<a href="#form" onclick="javascript:tag(\' :krut \', \'\');"><img src="' . BASEDIR . 'images/smiles/krut.gif" alt="krut" /></a> ';
    echo '<a href="#form" onclick="javascript:tag(\' :klass \', \'\');"><img src="' . BASEDIR . 'images/smiles/klass.gif" alt="klass" /></a> ';
    echo '<a href="#form" onclick="javascript:tag(\' :vtopku \', \'\');"><img src="' . BASEDIR . 'images/smiles/vtopku.gif" alt="vtopku" /></a> ';
    echo '<br />';
} 
// ------------------------- Вспомогательная функция быстрой вставки  ------------------------//
function quickpaste($form) {
    echo '<script language="JavaScript" type="text/javascript">
function tag(text1, text2) { 
if ((document.selection)) { 
document.form.' . $form . '.focus(); 
document.form.document.selection.createRange().text = text1+document.form.document.selection.createRange().text+text2; 
} else if(document.forms[\'form\'].elements[\'' . $form . '\'].selectionStart!=undefined) { 
var element = document.forms[\'form\'].elements[\'' . $form . '\']; 
var str = element.value; 
var start = element.selectionStart; 
var length = element.selectionEnd - element.selectionStart; 
element.value = str.substr(0, start) + text1 + str.substr(start, length) + text2 + str.substr(start + length); 
} else document.form.' . $form . '.value += text1+text2; 
}	
</script>';
} 
// ------------------------- Функция проверки аккаунта  ------------------------//
function check_user($login) {
    $queryuser = DB :: $dbh -> querySingle("SELECT `users_id` FROM `users` WHERE `users_login`=? LIMIT 1;", array($login));
    if (!empty($queryuser)) {
        return true;
    } 

    return false;
} 
// ------------------------- Функция проверки авторизации  ------------------------//
function is_user() {
    static $user = 0;

    if (empty($user)) {
        if (isset($_SESSION['log']) && isset($_SESSION['par'])) {
            $querycheck = DB :: $dbh -> query("SELECT `users_login`, `users_pass` FROM `users` WHERE `users_login`=? LIMIT 1;", array(check($_SESSION['log'])));
            $udata = $querycheck -> fetch();

            if (!empty($udata)) {
                if ($_SESSION['log'] == $udata['users_login'] && md5(md5($_SESSION['par'])) == $udata['users_pass']) {
                    $user = 1;
                } 
            } 
        } 
    } 

    return $user;
} 
// ------------------------- Функция проверки администрации  ------------------------//
function is_admin($access) {
    if (is_user()) {
        global $udata;
        if (in_array($udata['users_level'], $access)) {
            return true;
        } 
    } 

    return false;
} 
// ------------------------- Функция добавления копирайта в изображение ------------------------//
/**
 * function copyright_image($file){
 * 
 * if (file_exists($file)){
 * $ext = getimagesize($file); 
 * 
 * if ($ext[2]==1){
 * 
 * $img = imagecreatefromgif($file); 
 * $color = imagecolorallocate($img, 51, 51, 51); 
 * $color2 = imagecolorallocate($img, 255, 255, 255);
 * 
 * imageTTFtext($img, 10, 0, imagesx($img)-59, imagesy($img)-2, $color, BASEDIR."gallery/fonts/font2.ttf",'Visavi.net');
 * imageTTFtext($img, 10, 0, imagesx($img)-60, imagesy($img)-3, $color2, BASEDIR."gallery/fonts/font2.ttf",'Visavi.net');
 * imagegif($img, $file);
 * imagedestroy($img);
 * 
 * } else if ($ext[2]==2){
 * 
 * $img = imagecreatefromjpeg($file); 
 * $color = imagecolorallocate($img, 51, 51, 51); 
 * $color2 = imagecolorallocate($img, 255, 255, 255);
 * 
 * imageTTFtext($img, 10, 0, imagesx($img)-59, imagesy($img)-2, $color, BASEDIR."gallery/fonts/font2.ttf",'Visavi.net');
 * imageTTFtext($img, 10, 0, imagesx($img)-60, imagesy($img)-3, $color2, BASEDIR."gallery/fonts/font2.ttf",'Visavi.net');
 * imagejpeg ($img, $file);
 * imagedestroy($img);
 * 
 * }
 * return true;  
 * }}
 */
// ------------------------- Функция вывода заголовков ------------------------//
function show_title($image, $title) {
    echo '<img src="' . BASEDIR . 'images/img/' . $image . '" alt="' . $title . '" /> <b>' . $title . '</b><br /><br />';
} 
// ------------------------- Функция вывода ошибок ------------------------//
function show_error($error) {
    echo '<img src="' . BASEDIR . 'images/img/error.gif" alt="Ошибка" /> <b>' . $error . '</b><br /><br />';
} 
// ------------------------- Функция вывода предупреждения ------------------------//
function show_login($notice) {
    echo '<div class="login">' . $notice . '<br /><b><a href="' . BASEDIR . 'pages/login.php?' . SID . '">Авторизоваться</a></b> или в начале ';
    echo '<b><a href="' . BASEDIR . 'pages/registration.php?' . SID . '">Зарегистрироваться</a></b></div>';
} 
// ------------------------- Функция замены заголовков ------------------------//
function ob_processing($str) {
    global $config;
    if (isset($config['newtitle'])) {
        $str = str_replace('%TITLE%', $config['newtitle'] . ' - ' . $config['title'], $str);
    } else {
        $str = str_replace('%TITLE%', $config['logos'] . ' - ' . $config['title'], $str);
    } 
    $str = str_replace('%KEYWORDS%', $config['keywords'], $str);
    $str = str_replace('%DESCRIPTION%', $config['description'], $str);
    return $str;
} 
// ------------------ Функция вывода иконки расширения --------------------//
function icons($ext) {
    switch ($ext) {
    case 'dir': $ico = 'dir.gif';
        break;
    case '.php': $ico = 'php.gif';
        break;
    case '.txt': case '.css': case '.dat': $ico = 'txt.gif';
        break;
    case '.htm': case '.html': $ico = 'htm.gif';
        break;
    case '.wav': case '.amr': $ico = 'wav.gif';
        break;
    case '.zip': case '.rar': $ico = 'zip.gif';
        break;
    case '.jpg': case '.jpeg': $ico = 'jpg.gif';
        break;
    case '.bmp': case '.wbmp': $ico = 'bmp.gif';
        break;
    case '.gif': $ico = 'gif.gif';
        break;
    case '.png': $ico = 'png.gif';
        break;
    case '.mmf': $ico = 'mmf.gif';
        break;
    case '.jad': $ico = 'jad.gif';
        break;
    case '.jar': $ico = 'jar.gif';
        break;
    case '.mid': $ico = 'mid.gif';
        break;
    case '.mp3': $ico = 'mp3.gif';
        break;
    case '.exe': $ico = 'exe.gif';
        break;
    case '.ttf': $ico = 'ttf.gif';
        break;
    case '.htaccess': $ico = 'htaccess.gif';
        break;
    default: $ico = 'file.gif';
    } 
    return $ico;
} 
// ------------------ Функция смешивания ассоциативного массива --------------------//
function shuffle_assoc(&$array) {
    $keys = array_keys($array);

    shuffle($keys);
    $new = array();

    foreach($keys as $key) {
        $new[$key] = $array[$key];
    } 

    $array = $new;
    return true;
} 
// --------------- Функция обрезки слов -------------------//
function strip_str($str) {
    $str = str_replace('<br />', ' ', $str);
    return implode(' ', array_slice(explode(' ', strip_tags($str)), 0, 20));
} 
// ------------------ Функция вывода админской рекламы --------------------//
function show_advertadmin() {
    if (filemtime(DATADIR . "temp/rekadmin.dat") < time()-1800) {
        save_advertadmin();
    } 

    $datafile = unserialize(file_get_contents(DATADIR . "temp/rekadmin.dat"));

    if (!empty($datafile)) {
        $quot_rand = array_rand($datafile);
        return $datafile[$quot_rand];
    } 
} 
// --------------- Функция кэширования админской рекламы -------------------//
function save_advertadmin() {
    $queryadv = DB :: $dbh -> query("SELECT `adv_url`, `adv_title` FROM `advert`;");
    $data = $queryadv -> fetchAll();

    $arraylink = array();

    if (count($data) > 0) {
        foreach ($data as $val) {
            $arraylink[] = '<b><a href="' . $val['adv_url'] . '" target="_blank">' . $val['adv_title'] . '</a></b><br />';
        } 
    } 

    file_put_contents(DATADIR . "temp/rekadmin.dat", serialize($arraylink), LOCK_EX);
} 
// ----------- Функция проверки лицензии и обновления ------------//
function site_verification() {
    global $config;

    if (!empty($config['rotorlicense'])) {
        echo '<b><a href="changes.php?act=verifi&amp;' . SID . '"><span style="color:#00cc00">Лицензионная версия (' . $config['rotorversion'] . ')</span></a></b><br /><br />';
    } else {
        echo '<b><a href="changes.php?act=verifi&amp;' . SID . '"><span style="color:#ff0000">Бесплатная версия (' . $config['rotorversion'] . ')</span></a></b><br /><br />';
    } 

    if (stats_changes() > $config['rotorversion']) {
        echo '<img src="../images/img/custom.gif" alt="image" />  <b><a href="changes.php?' . SID . '"><span style="color:#ff0000">Доступна новая версия ' . stats_changes() . '</span></a></b><br /><br />';
    } 
} 
// ----------- Функция определения последней версии RotorCMS ------------//
function stats_changes() {
    if (filemtime(DATADIR . "temp/changes.dat") < time()-86400) {
        if (@copy("http://visavi.net/rotorcms/rotor.txt", DATADIR . "temp/changes.dat")) {
        } else {
            $data = curl_connect("http://visavi.net/rotorcms/rotor.txt");
            file_put_contents(DATADIR . "temp/changes.dat", $data);
        } 
    } 

    $data = file_get_contents(DATADIR . "temp/changes.dat");

    if (is_serialized($data)) {
        $data = unserialize($data);
        return $data['version'];
    } 
} 
// ----------- Функция проверки сериализации ------------//
function is_serialized($data) {
    if (trim($data) == "") {
        return false;
    } 
    if (preg_match("/^(i|s|a|o|d)(.*);/si", $data)) {
        return true;
    } 
    return false;
} 
// ----------- Функция закачки файла через curl ------------//
function curl_connect($url, $user_agent = 'Mozilla/5.0') {
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt ($ch, CURLOPT_URL, $url);
        curl_setopt ($ch, CURLOPT_USERAGENT, $user_agent);
        curl_setopt ($ch, CURLOPT_HEADER, 0);
        curl_setopt ($ch, CURLOPT_REFERER, $url);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt ($ch, CURLOPT_TIMEOUT, 10);
        $result = curl_exec ($ch);
        curl_close ($ch);
        return $result;
    } 
} 

?>