<?php
#-----------------------------------------------------#
#          ********* ROTORCMS *********               #
#              Made by  :  VANTUZ                     #
#               E-mail  :  visavi.net@mail.ru         #
#                 Site  :  http://pizdec.ru           #
#             WAP-Site  :  http://visavi.net          #
#                  ICQ  :  36-44-66                   #
#  Вы не имеете право вносить изменения в код скрипта #
#        для его дальнейшего распространения          #
#-----------------------------------------------------#
$debugmode = 0;

if ($debugmode) {
  @error_reporting(E_ALL);
  @ini_set('display_errors', true);
  @ini_set('html_errors', true);
  @ini_set('error_reporting', E_ALL);
} else {
  @error_reporting(E_ALL ^ E_NOTICE);
  @ini_set('display_errors', false);
  @ini_set('html_errors', false);
  @ini_set('error_reporting', E_ALL ^ E_NOTICE);
} 

@ini_set('url_rewriter.tags', '');
@ini_set('session.use_trans_sid', 1);
session_name('SID');
session_start();

$starttime = microtime(1);
$ip = preg_replace('|[^0-9\.]|', '', $_SERVER['REMOTE_ADDR']);
if (version_compare(PHP_VERSION, '5.2.1') < 0) {
  die('<b>Ошибка! Версия PHP должна быть 5.2.1 или выше!</b>');
} 

if (get_magic_quotes_gpc()) {
  $in = array(&$_GET, &$_POST, &$_COOKIE);
  while (list($k, $v) = each($in)) {
    foreach ($v as $key => $val) {
      if (!is_array($val)) {
        $in[$k][$key] = stripslashes($val);
        continue;
      } 
      $in[] = &$in[$k][$key];
    } 
  } 
  unset ($in);
  if (!empty ($_FILES)) {
    foreach ($_FILES as $k => $v) {
      $_FILES[$k]['name'] = stripslashes((string) $v['name']);
    } 
  } 
} 

$level = 0;
$folder_level = '';
while (!file_exists($folder_level . 'input.php') && $level < 5) {
  $folder_level .= '../';
  ++$level;
} 
unset($level);

define('BASEDIR', $folder_level);
define('DATADIR', BASEDIR . 'local/');
define('ADMINDIR', BASEDIR . 'mpanel/');

foreach ($_GET as $check_url) {
  if (!is_string($check_url) || !preg_match('#^(?:[a-z0-9_\-/]+|\.+(?!/))*$#i', $check_url)) {
    $_SESSION['note'] = 'ERROR 403. Недопустимый запрос!';
    header ('Location: ' . BASEDIR . 'index.php?' . SID);
    exit;
  } 
} 
unset($check_url);
// ---------------------------- Класс для работы с базами данных -------------------------------//
class PDO_ extends PDO {
  function __construct($dsn, $username, $password) {
    parent :: __construct($dsn, $username, $password);
    $this -> setAttribute(PDO :: ATTR_ERRMODE, PDO :: ERRMODE_EXCEPTION);
    $this -> setAttribute(PDO :: ATTR_DEFAULT_FETCH_MODE, PDO :: FETCH_ASSOC);
  } 

  function prepare($sql) {
    $stmt = parent :: prepare($sql, array(
        PDO :: ATTR_STATEMENT_CLASS => array('PDOStatement_')
        ));
    return $stmt;
  } 

  function query($sql, $params = array()) {
    $stmt = $this -> prepare($sql);
    $stmt -> execute($params);
    return $stmt;
  } 

  function querySingle($sql, $params = array()) {
    $stmt = $this -> query($sql, $params);
    $stmt -> execute($params);
    return $stmt -> fetchColumn(0);
  } 

  function queryFetch($sql, $params = array()) {
    $stmt = $this -> query($sql, $params);
    $stmt -> execute($params);
    return $stmt -> fetch();
  } 
} 
// ----------------------------------------------------//
class PDOStatement_ extends PDOStatement {
  function execute($params = array()) {
    if (func_num_args() == 1) {
      $params = func_get_arg(0);
    } else {
      $params = func_get_args();
    } 
    if (!is_array($params)) {
      $params = array($params);
    } 
    parent :: execute($params);
    return $this;
  } 

  function fetchSingle() {
    return $this -> fetchColumn(0);
  } 

  function fetchAssoc() {
    $this -> setFetchMode(PDO :: FETCH_NUM);
    $data = array();
    while ($row = $this -> fetch()) {
      $data[$row[0]] = $row[1];
    } 
    return $data;
  } 
} 

include_once (BASEDIR . 'includes/connect.php');

class DB {
  static $dbh;

  public function __construct() {
    try {
      self :: $dbh = new PDO_('mysql:host=' . DBHOST . ';port=' . DBPORT . ';dbname=' . DBNAME, DBUSER, DBPASS);
      self :: $dbh -> exec('SET CHARACTER SET utf8');
      self :: $dbh -> exec('SET NAMES utf8');
    } 
    catch (PDOException $e) {
      if (file_exists(BASEDIR . 'install/index.php')) {
        header ('Location: ' . BASEDIR . 'install/index.php');
        exit;
      } 
      die('Connection failed: ' . $e -> getMessage());
    } 
  } 

  final public function __destruct() {
    self :: $dbh = null;
  } 
} 

$database = new DB();

if (file_exists(DATADIR . 'temp/setting.dat')) {
  $config = unserialize(file_get_contents(DATADIR . 'temp/setting.dat'));
} else {
  $queryset = DB :: $dbh -> query("SELECT `setting_name`, `setting_value` FROM `setting`;");
  $config = $queryset -> fetchAssoc();
} 

define('SITETIME', time() + $config['timeclocks'] * 3600); # Установка временного сдвига сайта


?>