<?php
#-----------------------------------------------------#
#          ********* ROTORCMS *********               #
#              Made by  :  VANTUZ                     #
#               E-mail  :  visavi.net@mail.ru         #
#                 Site  :  http://pizdec.ru           #
#             WAP-Site  :  http://visavi.net          #
#                  ICQ  :  36-44-66                   #
#  Вы не имеете право вносить изменения в код скрипта #
#        для его дальнейшего распространения          #
#-----------------------------------------------------#	
require_once ('../includes/start.php');
require_once ('../includes/functions.php');
require_once ('../includes/header.php');
include_once ('../themes/' . $config['themes'] . '/index.php');

if (isset($_GET['act'])) {
  $act = check($_GET['act']);
} else {
  $act = 'index';
} 
if (isset($_GET['cid'])) {
  $cid = abs(intval($_GET['cid']));
} else {
  $cid = 0;
} 
if (isset($_GET['id'])) {
  $id = abs(intval($_GET['id']));
} else {
  $id = 0;
} 

show_title('site.png', 'Публикация нового файла');

if (is_user()) {
  switch ($act): 
  # ###########################################################################################
  # #                                   Главная страница                                     ##
  # ###########################################################################################
  case 'index':

    $config['newtitle'] = 'Публикация нового файла';

    $querydown = DB :: $dbh -> query("SELECT `cats_id`, `cats_parent`, `cats_name` FROM `cats` ORDER BY `cats_order` ASC;");
    $downs = $querydown -> fetchAll();

    if (count($downs) > 0) {
      echo '<div class="form">';
      echo '<form action="add.php?act=addfile&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" method="post">';
      echo 'Категория*:<br />';

      $output = array();

      foreach ($downs as $row) {
        $i = $row['cats_id'];
        $p = $row['cats_parent'];
        $output[$p][$i] = $row;
      } 

      echo '<select name="cid">';
      echo '<option value="0">Выберите категорию</option>';

      foreach ($output[0] as $key => $data) {
        $selected = ($cid == $data['cats_id']) ? ' selected="selected"' : '';
        echo '<option value="' . $data['cats_id'] . '"' . $selected . '>' . $data['cats_name'] . '</option>';

        if (isset($output[$key])) {
          foreach($output[$key] as $datasub) {
            $selected = ($cid == $datasub['cats_id']) ? ' selected="selected"' : '';
            echo '<option value="' . $datasub['cats_id'] . '"' . $selected . '>– ' . $datasub['cats_name'] . '</option>';
          } 
        } 
      } 

      echo '</select><br />';

      echo 'Название*:<br />';
      echo '<input type="text" name="title" size="50" maxlength="50" /><br />';
      echo 'Описание*:<br />';
      echo '<textarea cols="25" rows="10" name="text"></textarea><br />';
      echo 'Автор файла:<br />';
      echo '<input type="text" name="author" maxlength="50" /><br />';
      echo 'Сайт автора:<br />';
      echo '<input type="text" name="site" maxlength="50" value="http://" /><br />';

      echo '<input value="Продолжить" type="submit" /></form></div><br />';

      echo 'Все поля отмеченные знаком *, обязательны для заполнения<br />';
      echo 'Файл и скриншот вы сможете загрузить после добавления описания<br />';
      echo 'Если вы ошиблись в названии или описании файла, вы всегда можете его отредактировать<br /><br />';
    } else {
      show_error('Категории файлов еще не созданы!');
    } 
    break; 
  # ###########################################################################################
  # #                                  Публикация файла                                      ##
  # ###########################################################################################
  case 'addfile':

    $config['newtitle'] = 'Публикация нового файла';

    $uid = check($_GET['uid']);
    $cid = abs(intval($_POST['cid']));
    $title = check($_POST['title']);
    $text = check($_POST['text']);
    $author = (!empty($_POST['author'])) ? check($_POST['author']) : '';
    $site = ($_POST['site'] != 'http://') ? check($_POST['site']) : '';

    if ($uid == $_SESSION['token']) {
      if (!empty($cid)) {
        if (utf_strlen($title) >= 5 && utf_strlen($title) < 50) {
          if (utf_strlen($text) >= 10 && utf_strlen($text) < 5000) {
            if (utf_strlen($author) < 50) {
              if (empty($site) || preg_match('#^http://([а-яa-z0-9_\-\.])+(\.([а-яa-z0-9\/])+)+$#u', $site)) {
                $downs = DB :: $dbh -> querySingle("SELECT `cats_id` FROM `cats` WHERE `cats_id`=? LIMIT 1;", array($cid));
                if (!empty($downs)) {
                  $downtitle = DB :: $dbh -> querySingle("SELECT `downs_title` FROM `downs` WHERE `downs_title`=? LIMIT 1;", array($title));
                  if (empty($downtitle)) {
                    $text = no_br($text);

                    DB :: $dbh -> query("UPDATE `cats` SET `cats_count`=`cats_count`+1 WHERE `cats_id`=?", array($cid));
                    DB :: $dbh -> query("INSERT INTO `downs` (`downs_cats_id`, `downs_title`, `downs_text`, `downs_link`, `downs_user`, `downs_author`, `downs_site`, `downs_screen`, `downs_time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);", array($cid, $title, $text, '', $log, $author, $site, '', SITETIME));

                    $lastid = DB :: $dbh -> lastInsertId();

                    $_SESSION['note'] = 'Данные успешно добавлены!';
                    header ("Location: add.php?act=editdown&id=$lastid&" . SID);
                    exit;
                  } else {
                    show_error('Ошибка! Название ' . $title . ' уже имеется в файлах!');
                  } 
                } else {
                  show_error('Ошибка! Выбранный вами раздел не существует!');
                } 
              } else {
                show_error('Ошибка! Недопустимый адрес сайта, необходим формат http://site.domen!');
              } 
            } else {
              show_error('Ошибка! Слишком длинный ник (логин) автора (до 50 символов)!');
            } 
          } else {
            show_error('Ошибка! Слишком длинный или короткий текст описания (от 10 до 5000 символов)!');
          } 
        } else {
          show_error('Ошибка! Слишком длинное или короткое название (от 5 до 50 символов)!');
        } 
      } else {
        show_error('Ошибка! Вы не выбрали категорию для добавления файла!');
      } 
    } else {
      show_error('Ошибка! Неверный идентификатор сессии, повторите действие!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="add.php?act=newfile&amp;cid=' . $cid . '&amp;' . SID . '">Вернуться</a><br />';
    break; 
  # ###########################################################################################
  # #                            Подготовка к редактированию файла                           ##
  # ###########################################################################################
  case 'editdown':

    $config['newtitle'] = 'Редактирование файла';

    $new = DB :: $dbh -> queryFetch("SELECT `downs`.*, `cats`.* FROM `downs` LEFT JOIN `cats` ON `downs`.`downs_cats_id`=`cats`.`cats_id` WHERE `downs_id`=? LIMIT 1;", array($id));

    if (!empty($new)) {
      if ($new['downs_user'] == $log) {
        echo '<a href="#down"><img src="../images/img/downs.gif" alt="Вниз" /></a> <a href="index.php?' . SID . '">Категории</a> / ';

        if (!empty($new['cats_parent'])) {
          $podcats = DB :: $dbh -> queryFetch("SELECT `cats_id`, `cats_name` FROM `cats` WHERE `cats_id`=? LIMIT 1;", array($new['cats_parent']));
          echo '<a href="load.php?act=down&amp;cid=' . $podcats['cats_id'] . '&amp;' . SID . '">' . $podcats['cats_name'] . '</a> / ';
        } 

        echo '<a href="down.php?act=view&amp;id=' . $id . '&amp;' . SID . '">Обзор файла</a><br /><br />';

        if (empty($new['downs_link'])) {
          echo '<b><big>Загрузка файла</big></b><br /><br />';

          echo '<div class="form">';
          echo '<form action="add.php?act=loadfile&amp;id=' . $id . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" method="post" enctype="multipart/form-data">';
          echo 'Прикрепить файл*:<br /><input type="file" name="loadfile" /><br />';
          echo '<input value="Загрузить" type="submit" /></form></div><br />';
        } else {
          echo '<img src="../images/img/download.gif" alt="image" /> <b>' . $new['downs_link'] . '</b> (' . read_file(BASEDIR . 'load/files/' . $new['downs_link']) . ') (<a href="add.php?act=delfile&amp;id=' . $id . '&amp;' . SID . '">Удалить</a>)<br />';

          $ext = substr(strrchr($new['downs_link'], '.'), 1);
          if ($ext != 'jpg' && $ext != 'jpeg' && $ext != 'gif' && $ext != 'png') {
            if (empty($new['downs_screen'])) {
              echo '<br /><b><big>Загрузка скриншота</big></b><br /><br />';
              echo '<div class="form">';
              echo '<form action="add.php?act=loadscreen&amp;id=' . $id . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" method="post" enctype="multipart/form-data">';
              echo 'Прикрепить скрин (jpg,jpeg,gif,png):<br /><input type="file" name="screen" /><br />';
              echo '<input value="Загрузить" type="submit" /></form></div><br />';
            } else {
              echo '<img src="../images/img/gallery.gif" alt="image" /> <b>' . $new['downs_screen'] . '</b> (' . read_file(BASEDIR . 'load/screen/' . $new['downs_screen']) . ') (<a href="add.php?act=delscreen&amp;id=' . $id . '&amp;' . SID . '">Удалить</a>)<br />';
            } 
          } 
        } 

        echo '<br />';
        echo '<b><big>Редактирование</big></b><br /><br />';
        echo '<div class="form">';
        echo '<form action="add.php?act=changedown&amp;id=' . $id . '&amp;uid=' . $_SESSION['token'] . '&amp;' . SID . '" method="post">';

        $new['downs_text'] = nosmiles($new['downs_text']);
        $new['downs_text'] = yes_br($new['downs_text']);

        echo 'Название*:<br />';
        echo '<input type="text" name="title" size="50" maxlength="50" value="' . $new['downs_title'] . '" /><br />';
        echo 'Описание*:<br />';
        echo '<textarea cols="25" rows="5" name="text">' . $new['downs_text'] . '</textarea><br />';
        echo 'Автор файла:<br />';
        echo '<input type="text" name="author" maxlength="50" value="' . $new['downs_author'] . '" /><br />';
        echo 'Сайт автора:<br />';
        echo '<input type="text" name="site" maxlength="50" value="' . $new['downs_site'] . '" /><br />';

        echo '<input value="Изменить" type="submit" /></form></div><br />';
      } else {
        show_error('Ошибка! Изменение невозможно, вы не автор данного файла!');
      } 
    } else {
      show_error('Данного файла не существует!');
    } 

    break; 
  # ###########################################################################################
  # #                                  Редактирование файла                                  ##
  # ###########################################################################################
  case 'changedown':

    $uid = check($_GET['uid']);
    $title = check($_POST['title']);
    $text = check($_POST['text']);
    $author = (!empty($_POST['author'])) ? check($_POST['author']) : '';
    $site = ($_POST['site'] != 'http://') ? check($_POST['site']) : '';

    if ($uid == $_SESSION['token']) {
      if (utf_strlen($title) >= 5 && utf_strlen($title) < 50) {
        if (utf_strlen($text) >= 50 && utf_strlen($text) < 5000) {
          if (utf_strlen($author) < 50) {
            if (empty($site) || preg_match('#^http://([а-яa-z0-9_\-\.])+(\.([а-яa-z0-9\/])+)+$#u', $site)) {
              $new = DB :: $dbh -> queryFetch("SELECT * FROM `downs` WHERE `downs_id`=?;", array($id));
              if (!empty($new)) {
                if ($new['downs_user'] == $log) {
                  $text = no_br($text);

                  DB :: $dbh -> query("UPDATE `downs` SET `downs_title`=?, `downs_text`=?, `downs_author`=?, `downs_site`=?, `downs_time`=? WHERE `downs_id`=?;", array($title, $text, $author, $site, $new['downs_time'], $id));

                  $_SESSION['note'] = 'Данные успешно изменены!';
                  header ("Location: add.php?act=editdown&id=$id&" . SID);
                  exit;
                } else {
                  show_error('Ошибка! Изменение невозможно, вы не автор данного файла!');
                } 
              } else {
                show_error('Данного файла не существует!');
              } 
            } else {
              show_error('Ошибка! Недопустимый адрес сайта, необходим формат http://site.domen!');
            } 
          } else {
            show_error('Ошибка! Слишком длинный ник (логин) автора (до 50 символов)!');
          } 
        } else {
          show_error('Ошибка! Слишком длинный или короткий текст описания (от 50 до 5000 символов)!');
        } 
      } else {
        show_error('Ошибка! Слишком длинное или короткое название (от 5 до 50 символов)!');
      } 
    } else {
      show_error('Ошибка! Неверный идентификатор сессии, повторите действие!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="add.php?act=editdown&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    break; 
  # ###########################################################################################
  # #                                   Загрузка файла                                       ##
  # ###########################################################################################
  case 'loadfile':
    $config['newtitle'] = 'Загрузка файла';

    $down = DB :: $dbh -> queryFetch("SELECT * FROM `downs` WHERE `downs_id`=?;", array($id));
    if (!empty($down)) {
      if ($down['downs_user'] == $log) {
        if (empty($down['downs_link'])) {
          if (is_uploaded_file($_FILES['loadfile']['tmp_name'])) {
            $filename = check(strtolower($_FILES['loadfile']['name']));
            if (preg_match('|^[a-z0-9_\.\-]+$|i', $filename)) {
              $arrext = explode(',', $config['allowextload']);
              $ext = strtolower(substr(strrchr($filename, '.'), 1));

              if (in_array($ext, $arrext) && $ext != 'php') {
                if (!preg_match('/\.(php|pl|cgi|phtml|htaccess)/i', $filename)) {
                  if ($_FILES['loadfile']['size'] > 0 && $_FILES['loadfile']['size'] <= $config['fileupload']) {
                    $downlink = DB :: $dbh -> querySingle("SELECT `downs_link` FROM `downs` WHERE `downs_link`=? LIMIT 1;", array($filename));
                    if (empty($downlink)) {
                      move_uploaded_file($_FILES['loadfile']['tmp_name'], BASEDIR . 'load/files/' . $filename);
                      @chmod(BASEDIR . 'load/files/' . $filename, 0666);

                      DB :: $dbh -> query("UPDATE `downs` SET `downs_link`=? WHERE `downs_id`=?;", array($filename, $id));

                      $_SESSION['note'] = 'Файл успешно загружен!';
                      header ("Location: add.php?act=editdown&id=$id&" . SID);
                      exit;
                    } else {
                      show_error('Ошибка! Файл ' . $filename . ' уже имеется в общих файлах!');
                    } 
                  } else {
                    show_error('Ошибка! Максимальный размер загружаемого файла ' . formatsize($config['fileupload']) . '!');
                  } 
                } else {
                  show_error('Ошибка! В названии файла присутствуют недопустимые расширения!');
                } 
              } else {
                show_error('Ошибка! Недопустимое расширение файла!');
              } 
            } else {
              show_error('Ошибка! В названии файла присутствуют недопустимые символы!');
            } 
          } else {
            show_error('Ошибка! Не удалось загрузить файл!');
          } 
        } else {
          show_error('Ошибка! Файл уже загружен!');
        } 
      } else {
        show_error('Ошибка! Изменение невозможно, вы не автор данного файла!');
      } 
    } else {
      show_error('Данного файла не существует!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="add.php?act=editdown&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    break; 
  # ###########################################################################################
  # #                                   Загрузка скриншота                                   ##
  # ###########################################################################################
  case 'loadscreen':
    $config['newtitle'] = 'Загрузка скриншота';

    $down = DB :: $dbh -> queryFetch("SELECT * FROM `downs` WHERE `downs_id`=?;", array($id));
    if (!empty($down)) {
      if ($down['downs_user'] == $log) {
        if (empty($down['downs_screen'])) {
          if (is_uploaded_file($_FILES['screen']['tmp_name'])) {
            $screenname = check(strtolower($_FILES['screen']['name']));
            $ext = substr(strrchr($screenname, '.'), 1);

            if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'gif' || $ext == 'png') {
              if (!preg_match('/\.(php|pl|cgi|phtml|htaccess)/i', $screenname)) {
                if ($_FILES['screen']['size'] > 0 && $_FILES['screen']['size'] <= $config['screenupload']) {
                  $getimagesize = GetImageSize($_FILES['screen']['tmp_name']);
                  $width = $getimagesize[0];
                  $height = $getimagesize[1];

                  if ($width <= $config['screensize'] && $height <= $config['screensize'] && $width >= 100 && $height >= 100) {
                    move_uploaded_file ($_FILES['screen']['tmp_name'], BASEDIR . 'load/screen/' . $down['downs_link'] . '.' . $ext);
                    @chmod(BASEDIR . 'load/screen/' . $down['downs_link'] . '.' . $ext, 0666);

                    DB :: $dbh -> query("UPDATE `downs` SET `downs_screen`=? WHERE `downs_id`=?;", array($down['downs_link'] . '.' . $ext, $id));

                    $_SESSION['note'] = 'Скриншот успешно загружен!';
                    header ("Location: add.php?act=editdown&id=$id&" . SID);
                    exit;
                  } else {
                    show_error('Ошибка! Требуемый размер скриншота: от 100 до ' . $config['screensize'] . ' px');
                  } 
                } else {
                  show_error('Ошибка! Максимальный размер загружаемого скриншота ' . formatsize($config['screenupload']) . '!');
                } 
              } else {
                show_error('Ошибка! В названии скриншота присутствуют недопустимые расширения!');
              } 
            } else {
              show_error('Ошибка! Разрешается загружать скриншоты с расширением jpg, jpeg, gif и png!');
            } 
          } else {
            show_error('Ошибка! Вы не загрузили скриншот!');
          } 
        } else {
          show_error('Ошибка! Скриншот уже загружен!');
        } 
      } else {
        show_error('Ошибка! Изменение невозможно, вы не автор данного файла!');
      } 
    } else {
      show_error('Данного файла не существует!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="add.php?act=editdown&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    break; 
  # ###########################################################################################
  # #                                   Удаление файла                                       ##
  # ###########################################################################################
  case 'delfile':

    $link = DB :: $dbh -> queryFetch("SELECT * FROM `downs` WHERE `downs_id`=?;", array($id));
    if (!empty($link)) {
      if ($link['downs_user'] == $log) {
        if (!empty($link['downs_link']) && file_exists(BASEDIR . 'load/files/' . $link['downs_link'])) {
          unlink(BASEDIR . 'load/files/' . $link['downs_link']);
        } 
        if (!empty($link['downs_screen']) && file_exists(BASEDIR . 'load/screen/' . $link['downs_screen'])) {
          unlink(BASEDIR . 'load/screen/' . $link['downs_screen']);
        } 

        DB :: $dbh -> query("UPDATE `downs` SET `downs_link`=?, `downs_screen`=? WHERE `downs_id`=?;", array('', '', $id));

        $_SESSION['note'] = 'Файл успешно удален!';
        header ("Location: add.php?act=editdown&id=$id&" . SID);
        exit;
      } else {
        show_error('Ошибка! Удаление невозможно, вы не автор данного файла!');
      } 
    } else {
      show_error('Ошибка! Данного файла не существует!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="add.php?act=editdown&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    break; 
  # ###########################################################################################
  # #                                    Удаление скриншота                                  ##
  # ###########################################################################################
  case 'delscreen':

    $screen = DB :: $dbh -> queryFetch("SELECT * FROM `downs` WHERE `downs_id`=?;", array($id));
    if (!empty($screen)) {
      if ($screen['downs_user'] == $log) {
        if (file_exists(BASEDIR . 'load/screen/' . $screen['downs_screen'])) {
          unlink(BASEDIR . 'load/screen/' . $screen['downs_screen']);
        } 
        DB :: $dbh -> query("UPDATE `downs` SET `downs_screen`=? WHERE `downs_id`=?;", array('', $id));

        $_SESSION['note'] = 'Скриншот успешно удален!';
        header ("Location: add.php?act=editdown&id=$id&" . SID);
        exit;
      } else {
        show_error('Ошибка! Удаление невозможно, вы не автор данного файла!');
      } 
    } else {
      show_error('Ошибка! Данного файла не существует!');
    } 

    echo '<img src="../images/img/back.gif" alt="image" /> <a href="add.php?act=editdown&amp;id=' . $id . '&amp;' . SID . '">Вернуться</a><br />';
    break;

  default:
    header("location: add.php?" . SID);
    exit;
    endswitch;
  } else {
  show_login('Вы не авторизованы, для добавления скрипта, необходимо');
} 

echo '<img src="../images/img/reload.gif" alt="image" /> <a href="index.php?' . SID . '">Категории</a><br />';
echo '<img src="../images/img/homepage.gif" alt="image" /> <a href="../index.php?' . SID . '">На главную</a>';

include_once ('../themes/' . $config['themes'] . '/foot.php');

?>