<?php
class Navigation {
// конструктор, высчитывание обязательных (и не очень) переменных
public function __construct($input,$on_page,$print_str = false, $order = 'asc',$link = '?')
{
    
    // если входящий массив
    if(is_array($input))
    {
        // перестройка массива в нужный формат для навигации
        $this->rfile=array_values($input);
        // счетчик файлов
        $this->all_files = count($this->rfile);
        // оборачиваем(сортируем в нужном направлении) или оставляем без изменений массив файлов
        $this->rfile = $order == 'asc' ? $this->rfile : array_reverse($this->rfile);
    }
    else
    {
        $this->all_files = $input;
    }
    
    
    // линк который цеплять к ссылкам постранички
    $this->link = $link;
    // сколько результатов на страницу
    $this->on_page = $on_page < 1 ? 1 : $on_page;
    // пишем или не пишем Стр.
    $this->str = $print_str === true ? 'Стр. ' : '';
    // сортировка, asc - по убыванию, desc - по возрастанию
    $this->order = $order;
    
    // всего страниц
    $this->all_pages = ceil($this->all_files / $this->on_page);
    
    // если не установлен page = он равен 1, если установленый page больше
    // за все страниц - окончательный page равен последней странице
    $this->page = !isset($_GET['p']) || $_GET['p'] <= 0 ? 1 : abs(intval($_GET['p']));
    $this->page = $this->page > $this->all_pages ? $this->all_pages : $this->page;
    // бросать ли на последнюю страницу
    $this->page = isset($_GET['last']) ? $this->all_pages : $this->page;    
    
    // старт и конец отсчета файлов в массиве
    $this->start = ($this->page * $this->on_page) - 1;
    // если число больше чем файлов, знач максим число = это число файлов
    $this->start = $this->start > $this->all_files  ? $this->all_files : $this->start;
    // начальное число массива
    $this->end   = ($this->page * $this->on_page)- $this->on_page;
    // последние 3 страницы
    $this->last_three_page = $this->all_pages - 2;
    // "стрелочки" возле ссылок Вперед/Назад
    $this->lt = '&lt;&lt; '; // Назад
    $this->gt = ' &gt;&gt;'; // Вперед
}
/**
  *  вывод списка страниц 
  */
public function pagination() {
    // пишем или не пишем Стр.
    $string_pages = $this->str;
    
    // если страниц больше чем 10, выводим тройной линк, иначе все ссылки подряд
    if($this->all_pages > 10)
    {
        // если текущая страница меньше равна 3
        // выводим первые три ссылки и последние
        if($this->page <= 3)
        {
            // выводим первые три ссылки
            for($i=1;$i<=3;$i++)
            {
                $string_pages .= $this->page == $i ? ' '.$i.' ' : ' <a href="'.$this->link.'&amp;p='.$i.'">'.$i.'</a> ';
            }
            
            // если пейдж 3 - рендерим 4 сстраницу
            if($this->page == 3)
            {
                $string_pages .= ' <a href="'.$this->link.'&amp;p=4">4</a> ';
            }
            
            // и последние 3 ссылки, через троеточие
            $string_pages .= '...';
            
            for($i = $this->last_three_page;$i<=$this->all_pages;$i++)
            {
                $string_pages .= $this->page == $i ? ' '.$i.' ' : ' <a href="'.$this->link.'&amp;p='.$i.'">'.$i.'</a> ';
            }
            
        }
        // если ссылки вышли за радиус обзора, т.е в середину списка
        elseif($this->page < 6 && $this->page <= $this->last_three_page)
        {
            
            // выводим первые три ссылки
            for($i=1;$i<=6;$i++)
            {
                
                $string_pages .= $this->page == $i ? ' '.$i.' ' : ' <a href="'.$this->link.'&amp;p='.$i.'">'.$i.'</a> ';
            }
            
            // и последние 3 ссылки, через троеточие
            $string_pages .= '...';
            
            for($i = $this->last_three_page;$i<=$this->all_pages;$i++)
            {
                $string_pages .= $this->page == $i ? ' '.$i.' ' : ' <a href="'.$this->link.'&amp;p='.$i.'">'.$i.'</a> ';
            }
        }
        // если выбранная страница >= 6
        elseif($this->page >= 6 && $this->page <= ($this->last_three_page - 2))
        {
            
            // выводим первые три ссылки
            for($i=1;$i<=3;$i++)
            {
                
                $string_pages .= $this->page == $i ? ' '.$i.' ' : ' <a href="'.$this->link.'&amp;p='.$i.'">'.$i.'</a> ';
            }
            $string_pages .= '...';
            
            // одна ссылка слева/ неактивная посредине / ссылка справа
            $string_pages .= ' <a href="'.$this->link.'&amp;p='.($this->page - 1).'">'.($this->page - 1).'</a> ';
            $string_pages .= ' '.$this->page.' ';
            $string_pages .= ' <a href="'.$this->link.'&amp;p='.($this->page + 1).'">'.($this->page + 1).'</a> ';
            
            // и последние 3 ссылки, через троеточие
            $string_pages .= '...';
            
            for($i = ($this->last_three_page);$i<=$this->all_pages;$i++)
            {
                $string_pages .= $this->page == $i ? ' '.$i.' ' : ' <a href="'.$this->link.'&amp;p='.$i.'">'.$i.'</a> ';
            }
        }
        // если выбранные ссылки в конце
        elseif(($this->page + 1) >= ($this->last_three_page))
        {
            // выводим первые три ссылки
            for($i=1;$i<=3;$i++)
            {
                
                $string_pages .= $this->page == $i ? ' '.$i.' ' : ' <a href="'.$this->link.'&amp;p='.$i.'">'.$i.'</a> ';
            }
                        
            // и последние 3 ссылки, через троеточие
            $string_pages .= '...';
            
            for($i = ($this->last_three_page - 3);$i<=$this->all_pages;$i++)
            {
                $string_pages .= $this->page == $i ? ' '.$i.' ' : ' <a href="'.$this->link.'&amp;p='.$i.'">'.$i.'</a> ';
            }
        }
    }
    else
    {
        // вывод всех ссылок, если ссылок <= 10
        for($i=1;$i<=$this->all_pages;$i++)
        {
            $string_pages .= $this->page == $i ? ' '.$i.' ' : ' <a href="'.$this->link.'&amp;p='.$i.'">'.$i.'</a> ';
        }
    }
    return $string_pages; 
}

/*
 * function result_files
 * результирующий массив файлов
 */

public function result_files() {
    
    for($i=$this->end;$i<=$this->start;$i++)
    {
        if(isset($this->rfile[$i]))
        {
        $this->arr[$i] = $this->rfile[$i];
        }
    }
    
    return $this->arr;
}
/*
 * function show_info
 * выводим сколько всего файлов
 */

public function show_info() {
    return 'Файлов: '.$this->all_files;
}

/*
 * function back_forward_links
 * функция вывода линков вида - Назад | Вперед
 */

public function back_forward_links() {
    
    if($this->page <= 1)
    {
        $this->this_links = '<a href="'.$this->link.'&amp;p='.($this->page+1).'">Вперед'.$this->gt.'</a>';
    }
    elseif($this->page >= $this->all_pages)
    {
        $this->this_links = '<a href="'.$this->link.'&amp;p='.($this->page-1).'">'.$this->lt.'Назад</a>';
    }
    else
    {
        $this->this_links = '<a href="'.$this->link.'&amp;p='.($this->page-1).'">'.$this->lt.'Назад</a> | <a href="'.$this->link.'&amp;p='.($this->page+1).'">Вперед'.$this->gt.'</a>';
    }
    
    return $this->this_links;
}

/*
 * function show_form
 * функция показа формы для перехода
 */

public function show_form() {
    return '<form action="'.$_SERVER['PHP_SELF'].'" method="get">'.
    '<div>'.
    'Стр. <input type="text" size="4" name="p" value="'.$this->page.'" />'.
    '<input type="submit" value="Go!" />'.    
    '</div>'.
    '</form>';
}

/*
 * function limit
 * Лимит выводящих записей
 */

function limit() {
    // высчитываем лимиты
    
    
    return (($this->page*$this->on_page)-$this->on_page).' ,'.$this->on_page;
}

}
?>