<?php

use Phinx\Migration\AbstractMigration;

class ChangeIndexEmailInUsers extends AbstractMigration
{
    /**
     * Migrate Up.
     */
    public function up()
    {
        $table = $this->table('users');
        $table->removeIndexByName('email');
        $table->addIndex('email')
            ->save();
    }

    /**
     * Migrate Down.
     */
    public function down()
    {
        $table = $this->table('users');
        $table->removeIndexByName('email');
        $table->addIndex('email', ['unique' => true])
            ->save();
    }
}
