CREATE TABLE users (
       id INT PRIMARY KEY AUTO_INCREMENT,
       login VARCHAR(255) NOT NULL UNIQUE,
       name VARCHAR(255),
       city VARCHAR(255),
       website TEXT,
       about TEXT,
       password VARCHAR(255) NOT NULL,
       avatar TEXT,
       is_admin BOOLEAN DEFAULT FALSE,
       created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
   );

   CREATE TABLE messages (
       id INT PRIMARY KEY AUTO_INCREMENT,
       sender_id INT NOT NULL,
       receiver_id INT NOT NULL,
       message TEXT NOT NULL,  -- Исправлено с content на message, основываясь на последней ошибке
       created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
       is_read BOOLEAN DEFAULT FALSE,
       FOREIGN KEY (sender_id) REFERENCES users(id) ON DELETE CASCADE,
       FOREIGN KEY (receiver_id) REFERENCES users(id) ON DELETE CASCADE
   );