<?php
function is_logged_in() {
    return isset($_SESSION['user_id']);
}

function require_login() {
    if (!is_logged_in()) {
        header('Location: login.php');
        exit;
    }
}

// Генерация CSRF-токена
function generate_csrf_token() {
    if (!isset($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32)); // 64-значный hex-строковый токен
    }
    return $_SESSION['csrf_token'];
}

// Проверка CSRF-токена
function verify_csrf_token() {
    if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        error_log("CSRF токен недействителен: " . print_r($_POST, true));
        return false;
    }
    return true;
}

function login($login, $password) {
    global $pdo;
    try {
        $stmt = $pdo->prepare("SELECT id, password, is_admin FROM users WHERE login = ?");
        $stmt->execute([$login]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['is_admin'] = (bool)$user['is_admin'];
            // Генерация нового CSRF-токена после входа
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
            return true;
        }
        return false;
    } catch (PDOException $e) {
        error_log("Ошибка авторизации: " . $e->getMessage());
        return false;
    }
}

function logout() {
    session_destroy();
    session_start();
}