<?php
// Включение отображения ошибок для отладки (убрать на продакшене)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Проверка, была ли сессия уже запущена
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

// Проверка авторизации
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

global $pdo;
$user_id = $_SESSION['user_id'];

// Проверка наличия непрочитанных сообщений
$stmt = $pdo->prepare("SELECT COUNT(*) FROM messages WHERE receiver_id = ? AND is_read = FALSE");
$stmt->execute([$user_id]);
$unread_count = $stmt->fetchColumn();
$has_unread = $unread_count > 0;
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="assets/css/style.css">
    <title>Главная — AstralForge</title>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <?php if (isset($_SESSION['user_id'])): ?>
                <div class="navbar-user">
                    <a href="profile.php" class="navbar-avatar-link">
                        <?php 
                        $current_user = $pdo->prepare("SELECT avatar, login FROM users WHERE id = ?");
                        $current_user->execute([$_SESSION['user_id']]);
                        $current_user_data = $current_user->fetch();
                        ?>
                        <?php if (empty($current_user_data['avatar'])): ?>
                            <span class="default-avatar navbar-avatar">?</span>
                        <?php else: ?>
                            <img src="<?php echo htmlspecialchars($current_user_data['avatar']); ?>" alt="Ваш аватар" class="navbar-avatar" onerror="this.replaceWith(document.createElement('span').classList.add('default-avatar', 'navbar-avatar').textContent='?');">
                        <?php endif; ?>
                    </a>
                    <a href="profile.php" class="navbar-username"><?php echo htmlspecialchars($current_user_data['login']); ?></a>
                </div>
                <div class="navbar-links">
                    <a href="user_list.php">Пользователи</a>
                    <a href="messages.php" class="<?php echo $has_unread ? 'has-unread' : ''; ?>">
                        <span class="message-icon"></span>
                    </a>
                    <?php if (isset($_SESSION['is_admin']) && $_SESSION['is_admin']) echo '<a href="admin/index.php">Админ-панель</a>'; ?>
                    <a href="logout.php">Выход</a>
                </div>
            <?php endif; ?>
        </div>
    </nav>

    <div class="container">
        <h1>Добро пожаловать в AstralForge!</h1>
        <p>CMS находится в стадии разработки. Здесь вы можете начать взаимодействовать с другими пользователями, просматривать сообщения и управлять своим профилем.</p>
        <a href="user_list.php" class="chat-button">Перейти к пользователям</a>
        <a href="messages.php" class="chat-button">Перейти к сообщениям</a>
    </div>
</body>
</html>