<?php
session_start();
require_once 'config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

if (isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

$csrf_token = generate_csrf_token(); // Генерация CSRF-токена

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Проверка CSRF-токена
    if (!verify_csrf_token()) {
        $error = "Недействительный запрос. Попробуйте снова.";
    } else {
        $login = trim($_POST['login'] ?? '');
        $password = $_POST['password'] ?? '';

        if (!empty($login) && !empty($password)) {
            if (login($login, $password)) {
                header('Location: index.php');
                exit;
            }
            $error = "Неверный логин или пароль.";
        } else {
            $error = "Заполните все поля.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="assets/css/style.css">
    <title>Вход — AstralForge</title>
</head>
<body>
    <div class="container">
        <h1>Вход в AstralForge</h1>
        <?php if (isset($error)): ?>
            <p style="color: #e74c3c;"><?php echo htmlspecialchars($error); ?></p>
        <?php endif; ?>
        <form method="POST" class="profile-form">
            <div class="profile-details">
                <div class="form-group">
                    <label for="login" class="info-label">Логин:</label>
                    <input type="text" id="login" name="login" class="info-value" placeholder="Введите логин" required>
                </div>
                <div class="form-group">
                    <label for="password" class="info-label">Пароль:</label>
                    <input type="password" id="password" name="password" class="info-value" placeholder="Введите пароль" required>
                </div>
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                <button type="submit" class="chat-button">Войти</button>
                <p>Нет аккаунта? <a href="register.php" class="info-link">Зарегистрироваться</a></p>
            </div>
        </form>
    </div>
</body>
</html>